/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_server;

import com.mna.ManaAndArtifice;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.recipes.IManaweavePattern;
import com.mna.blocks.tileentities.ManaweavingAltarTile;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.entities.EntityInit;
import com.mna.entities.manaweaving.Manaweave;
import com.mna.events.EventDispatcher;
import com.mna.items.manaweaving.ItemManaweaverWand;
import com.mna.network.messages.BaseServerMessage;
import com.mna.recipes.manaweaving.ManaweavingPattern;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class ManaweavePatternDrawnMessage
extends BaseServerMessage {
    private ResourceLocation patternID;
    private Vec3 position;
    private InteractionHand hand;
    private int ticksDrawn;

    public ManaweavePatternDrawnMessage(ResourceLocation patternID, Vec3 position, InteractionHand hand, int ticksDrawn) {
        this.patternID = patternID;
        this.position = position;
        this.hand = hand;
        this.ticksDrawn = ticksDrawn;
        this.messageIsValid = true;
    }

    public ManaweavePatternDrawnMessage() {
        this.messageIsValid = false;
    }

    public ResourceLocation getPatternID() {
        return this.patternID;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public int getTicksDrawn() {
        return this.ticksDrawn;
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public static ManaweavePatternDrawnMessage decode(FriendlyByteBuf buf) {
        ManaweavePatternDrawnMessage msg = new ManaweavePatternDrawnMessage();
        try {
            msg.patternID = buf.m_130281_();
            msg.position = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
            msg.hand = InteractionHand.values()[buf.readInt()];
            msg.ticksDrawn = buf.readInt();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading ManaweavePatternDrawnMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(ManaweavePatternDrawnMessage msg, FriendlyByteBuf buf) {
        buf.m_130085_(msg.getPatternID());
        buf.writeDouble(msg.getPosition().f_82479_);
        buf.writeDouble(msg.getPosition().f_82480_);
        buf.writeDouble(msg.getPosition().f_82481_);
        buf.writeInt(msg.getHand().ordinal());
        buf.writeInt(msg.getTicksDrawn());
    }

    @Override
    public void Handle(ServerLevel world, ServerPlayer player) {
        BlockEntity worldTile;
        BlockPos messagePos = BlockPos.m_274446_((Position)this.getPosition());
        if (!player.m_9236_().m_46749_(messagePos)) {
            return;
        }
        Recipe pattern = player.m_9236_().m_7465_().m_44043_(this.getPatternID()).orElse(null);
        if (!(pattern instanceof IManaweavePattern)) {
            return;
        }
        if (!EventDispatcher.DispatchManaweavePatternDrawn((IManaweavePattern)pattern, (LivingEntity)player)) {
            return;
        }
        BlockPos storedPos = ItemManaweaverWand.getStoredBlockPos(player.m_21120_(this.getHand()));
        ManaweavingAltarTile tile = null;
        if (storedPos != null && storedPos.m_123331_((Vec3i)messagePos) <= 64.0 && (worldTile = player.m_9236_().m_7702_(storedPos)) != null && worldTile instanceof ManaweavingAltarTile) {
            tile = (ManaweavingAltarTile)worldTile;
        }
        if (tile == null) {
            Entity weave = ((EntityType)EntityInit.MANAWEAVE_ENTITY.get()).m_20615_(player.m_9236_());
            if (weave != null) {
                weave.m_7678_(this.getPosition().f_82479_, this.getPosition().f_82480_, this.getPosition().f_82481_, 0.0f, 0.0f);
                if (weave instanceof Manaweave) {
                    Manaweave manaweave = (Manaweave)weave;
                    manaweave.setPattern(this.getPatternID());
                    manaweave.setCaster((LivingEntity)player, this.getHand());
                    manaweave.setManuallyDrawn();
                    manaweave.setManaRefunded(this.getTicksDrawn());
                }
                player.m_9236_().m_7967_(weave);
            }
        } else {
            tile.pushPattern((ManaweavingPattern)pattern, (Player)player);
        }
        player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> m.addMagicXP(3, (Player)player, (IPlayerProgression)p)));
        player.m_21205_().m_41622_(1, (LivingEntity)player, i -> {});
    }
}

