/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_server;

import com.mna.ManaAndArtifice;
import com.mna.api.items.inventory.SpellInventory;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.gui.containers.item.ContainerRoteBook;
import com.mna.items.ItemInit;
import com.mna.items.sorcery.BookOfRote;
import com.mna.items.sorcery.SpellBook;
import com.mna.network.messages.BaseServerMessage;
import com.mna.spells.crafting.SpellRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.mutable.MutableInt;

public class RoteSpellsSyncMessageToServer
extends BaseServerMessage {
    private NonNullList<ItemStack> _roteInventory = NonNullList.m_122779_();

    public RoteSpellsSyncMessageToServer() {
        this.messageIsValid = false;
    }

    public RoteSpellsSyncMessageToServer(SpellInventory roteInventory) {
        this();
        for (int i = 0; i < roteInventory.m_6643_(); ++i) {
            this._roteInventory.add((Object)roteInventory.m_8020_(i).m_41777_());
        }
        this.messageIsValid = true;
    }

    public final NonNullList<ItemStack> getInventory() {
        return this._roteInventory;
    }

    public static final RoteSpellsSyncMessageToServer decode(FriendlyByteBuf buf) {
        RoteSpellsSyncMessageToServer msg = new RoteSpellsSyncMessageToServer();
        try {
            int count = buf.readInt();
            for (int i = 0; i < count; ++i) {
                msg._roteInventory.add((Object)buf.m_130267_());
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading RoteSpellsSyncMessageToServer: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static final void encode(RoteSpellsSyncMessageToServer msg, FriendlyByteBuf buf) {
        buf.writeInt(msg._roteInventory.size());
        for (int i = 0; i < msg._roteInventory.size(); ++i) {
            buf.m_130055_((ItemStack)msg._roteInventory.get(i));
        }
    }

    public static final RoteSpellsSyncMessageToServer fromRoteBookContainer(ContainerRoteBook container) {
        return new RoteSpellsSyncMessageToServer(container.roteBook);
    }

    @Override
    public void Handle(ServerLevel world, ServerPlayer player) {
        player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
            MutableInt playerTier = new MutableInt(0);
            player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> playerTier.setValue(p.getTier()));
            for (int i = 0; i < this.getInventory().size(); ++i) {
                ItemStack roteStack = (ItemStack)this.getInventory().get(i);
                SpellRecipe spell = SpellRecipe.fromNBT(roteStack.m_41784_());
                if (!spell.isValid()) {
                    m.getRoteInventory().m_6836_(i, new ItemStack((ItemLike)ItemInit.SPELL.get()));
                    continue;
                }
                m.getRoteInventory().m_6836_(i, roteStack);
            }
            ItemStack spellStack = player.m_150109_().m_8020_(player.m_150109_().f_35977_);
            if (spellStack.m_41720_() instanceof BookOfRote) {
                int slot = SpellBook.getActiveSpellSlot(spellStack);
                SpellBook.setSlot((Player)player, spellStack, slot, InteractionHand.MAIN_HAND, null, false);
            }
            m.setSyncRote();
            m.forceSync();
        });
    }
}

