/*
 * Decompiled with CFR 0.152.
 */
package com.mna.particles.bolt;

import com.mna.api.particles.MAParticleType;
import com.mna.particles.base.MAParticleBase;
import com.mna.particles.bolt.LightningData;
import com.mna.particles.bolt.Segment;
import com.mna.particles.types.render.ParticleRenderTypes;
import com.mna.tools.math.Vector3;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

public class FXLightningBolt
extends MAParticleBase {
    private LightningData data;

    public FXLightningBolt(ClientLevel worldIn, double startX, double startY, double startZ, double endX, double endY, double endZ, int maxAge, SpriteSet sprite) {
        super(worldIn, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.f_108321_ = sprite.m_213979_(this.f_107223_);
        this.data = new LightningData(new Vector3(startX, startY, startZ), new Vector3(endX, endY, endZ), (long)(Math.random() * 9.223372036854776E18), maxAge);
        this.f_107225_ = this.data.getMaxAge() + 5;
        this.m_107264_(startX, startY, startZ);
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.f_107227_ = 0.2f;
        this.f_107228_ = 0.2f;
        this.f_107229_ = 0.8f;
        this.f_107663_ = 0.25f;
        this.data.setMaxOffset(0.2f);
    }

    @Override
    public void m_5989_() {
        super.m_5989_();
        this.data.onUpdate();
        if (this.f_107224_ > this.m_107273_() - 10) {
            float delta;
            this.f_107230_ = delta = (float)(this.m_107273_() - this.f_107224_) / 10.0f;
        }
    }

    public boolean shouldCull() {
        return false;
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        Vec3 vec3d = renderInfo.m_90583_();
        float f = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - vec3d.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - vec3d.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - vec3d.m_7094_());
        Vector3 posOffset = new Vector3(f, f1, f2);
        Vector3 particleOrigin = new Vector3(this.f_107212_, this.f_107213_, this.f_107214_);
        int count = 0;
        int maxIndex = (int)Math.ceil(((float)this.data.getAge() + partialTicks) / (float)this.data.getMaxAge() * (float)this.data.numSegments());
        Vector3 lastEnd1 = null;
        Vector3 lastEnd2 = null;
        for (Segment s : this.data.getSegments()) {
            if (count > maxIndex) break;
            float width = Math.min(0.01f * this.data.getLength(), this.f_107663_);
            Vector3 start = s.getStart().sub(particleOrigin);
            Vector3 end = s.getEnd().sub(particleOrigin);
            Vector3 dir = end.sub(start).normalize().scale(this.data.getLength() * 3.0E-4f);
            Vector3f[] avector3f = new Vector3f[]{(lastEnd1 == null ? start.add(new Vector3(-width, 0.0, -width)) : lastEnd1.sub(dir)).toVector3f(), (lastEnd2 == null ? start.add(new Vector3(-width, 0.0, width)) : lastEnd2.sub(dir)).toVector3f(), end.add(new Vector3(width, 0.0, width)).toVector3f(), end.add(new Vector3(width, 0.0, -width)).toVector3f()};
            lastEnd1 = new Vector3(avector3f[2].x(), avector3f[2].y(), avector3f[2].z());
            lastEnd2 = new Vector3(avector3f[3].x(), avector3f[3].y(), avector3f[3].z());
            for (int i = 0; i < 4; ++i) {
                avector3f[i].add(posOffset.x, posOffset.y, posOffset.z);
            }
            float minU = this.m_5970_();
            float maxU = this.m_5952_();
            float minV = this.m_5951_();
            float maxV = this.m_5950_();
            int j = 0xF000F0;
            buffer.m_5483_((double)avector3f[3].x(), (double)avector3f[3].y(), (double)avector3f[3].z()).m_7421_(maxU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
            buffer.m_5483_((double)avector3f[2].x(), (double)avector3f[2].y(), (double)avector3f[2].z()).m_7421_(maxU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
            buffer.m_5483_((double)avector3f[0].x(), (double)avector3f[0].y(), (double)avector3f[0].z()).m_7421_(minU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
            buffer.m_5483_((double)avector3f[1].x(), (double)avector3f[1].y(), (double)avector3f[1].z()).m_7421_(minU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
            buffer.m_5483_((double)avector3f[1].x(), (double)avector3f[1].y(), (double)avector3f[1].z()).m_7421_(maxU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
            buffer.m_5483_((double)avector3f[0].x(), (double)avector3f[0].y(), (double)avector3f[0].z()).m_7421_(maxU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
            buffer.m_5483_((double)avector3f[2].x(), (double)avector3f[2].y(), (double)avector3f[2].z()).m_7421_(minU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
            buffer.m_5483_((double)avector3f[3].x(), (double)avector3f[3].y(), (double)avector3f[3].z()).m_7421_(minU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
            ++count;
        }
    }

    @Override
    public ParticleRenderType m_7556_() {
        return ParticleRenderTypes.ADDITIVE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FXLightningBoltFactory
    extends MAParticleBase.FXParticleFactoryBase {
        public FXLightningBoltFactory(SpriteSet spriteset) {
            super(spriteset);
        }

        @Override
        public Particle createParticle(MAParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FXLightningBolt particle = new FXLightningBolt(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.getLife() != null ? typeIn.getLife().value() : 10, this.spriteSet);
            this.configureParticle(particle, typeIn);
            if (typeIn.getGravity() != null) {
                particle.data.setMaxOffset(typeIn.getGravity().value());
            }
            if (typeIn.getLifePadding() != null) {
                particle.setLifePadding(0);
                particle.data.fractalize(typeIn.getLifePadding().value());
            } else {
                particle.data.fractalize();
            }
            particle.data.finalize();
            return particle;
        }
    }
}

