/*
 * Decompiled with CFR 0.152.
 */
package com.mna.recipes.manaweaving;

import com.google.gson.JsonObject;
import com.mna.ManaAndArtifice;
import com.mna.Registries;
import com.mna.recipes.AMRecipeBaseSerializer;
import com.mna.recipes.manaweaving.ManaweavingRecipe;
import java.util.HashMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class ManaweavingRecipeSerializer
extends AMRecipeBaseSerializer<ManaweavingRecipe> {
    public static HashMap<ResourceLocation, ManaweavingRecipe> ALL_RECIPES = new HashMap();

    @Override
    public ManaweavingRecipe readExtra(ResourceLocation recipeId, JsonObject json) {
        ManaweavingRecipe recipe = new ManaweavingRecipe(recipeId);
        recipe.parseJSON(json);
        ALL_RECIPES.put(recipeId, recipe);
        return recipe;
    }

    @Override
    public ManaweavingRecipe readExtra(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        try {
            ManaweavingRecipe recipe = new ManaweavingRecipe(recipeId);
            recipe.setOutput(buffer.m_130281_());
            recipe.setOutputQuantity(buffer.readInt());
            recipe.setEnchantment(buffer.m_130281_());
            recipe.setEnchantmentMagnitude(buffer.readInt());
            recipe.setCopyNBT(buffer.readBoolean());
            if (buffer.readBoolean()) {
                recipe.setRequiredFaction(buffer.m_130281_());
            }
            int numItems = buffer.readInt();
            ResourceLocation[] requiredItems = new ResourceLocation[numItems];
            for (int i = 0; i < numItems; ++i) {
                requiredItems[i] = buffer.m_130281_();
            }
            recipe.setRequiredItems(requiredItems);
            int numPatterns = buffer.readInt();
            ResourceLocation[] requiredPatterns = new ResourceLocation[numPatterns];
            for (int i = 0; i < numPatterns; ++i) {
                requiredPatterns[i] = buffer.m_130281_();
            }
            recipe.setRequiredPatterns(requiredPatterns);
            ALL_RECIPES.put(recipeId, recipe);
            return recipe;
        }
        catch (Exception e) {
            ManaAndArtifice.LOGGER.error("Error reading manaweaving recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void writeExtra(FriendlyByteBuf buffer, ManaweavingRecipe recipe) {
        try {
            int i;
            buffer.m_130085_(recipe.getOutput());
            buffer.writeInt(recipe.getOutputQuantity());
            buffer.m_130085_(recipe.getEnchantment());
            buffer.writeInt(recipe.getEnchantmentMagnitude());
            buffer.writeBoolean(recipe.getCopyNBT());
            if (recipe.getFactionRequirement() != null) {
                buffer.writeBoolean(true);
                buffer.m_130085_(Registries.Factions.get().getKey((Object)recipe.getFactionRequirement()));
            } else {
                buffer.writeBoolean(false);
            }
            ResourceLocation[] items = recipe.getRequiredItems();
            ResourceLocation[] patterns = recipe.getRequiredPatterns();
            buffer.writeInt(items.length);
            for (i = 0; i < items.length; ++i) {
                buffer.m_130085_(items[i]);
            }
            buffer.writeInt(patterns.length);
            for (i = 0; i < patterns.length; ++i) {
                buffer.m_130085_(patterns[i]);
            }
        }
        catch (Exception e) {
            ManaAndArtifice.LOGGER.error("Error writing manaweaving recipe to packet.", (Throwable)e);
            throw e;
        }
    }
}

