/*
 * Decompiled with CFR 0.152.
 */
package com.mna.rituals.effects;

import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.rituals.IRitualContext;
import com.mna.api.rituals.RitualEffect;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.entities.EntityInit;
import com.mna.entities.boss.DemonLord;
import com.mna.entities.rituals.DemonStone;
import com.mna.factions.Factions;
import com.mna.tools.StructureUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.Vec3;

public class RitualEffectBurningHells
extends RitualEffect {
    public RitualEffectBurningHells(ResourceLocation ritualName) {
        super(ritualName);
    }

    @Override
    public Component canRitualStart(IRitualContext context) {
        IPlayerProgression progression = (IPlayerProgression)context.getCaster().getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (progression == null) {
            return Component.m_237115_((String)"Progression could not be found...this is a problem.");
        }
        DemonLord tempBoss = new DemonLord(context.getLevel(), Vec3.m_82539_((Vec3i)context.getCenter()));
        if (!StructureUtils.isPointInStructure((ServerLevel)context.getLevel(), context.getCenter(), tempBoss.getArenaStructureID(), tempBoss.getArenaStructureSegment())) {
            if (progression.getTierProgress(context.getLevel()) < 1.0f) {
                return Component.m_237115_((String)"ritual.mna.progression.not_ready");
            }
            if (progression != null && progression.hasAlliedFaction() && progression.getAlliedFaction() != Factions.DEMONS) {
                return Component.m_237115_((String)"event.mna.faction_ritual_failed");
            }
        }
        return null;
    }

    @Override
    protected boolean applyRitualEffect(IRitualContext context) {
        BlockPos pos = context.getCenter();
        if (context.getCaster() == null || context.getCaster().m_20148_() == null) {
            return false;
        }
        DemonStone e = new DemonStone((EntityType)EntityInit.DEMON_STONE.get(), context.getLevel());
        e.m_7678_((float)pos.m_123341_() + 0.5f, pos.m_123342_(), (float)pos.m_123343_() + 0.5f, 0.0f, 0.0f);
        e.setCasterUUID(context.getCaster().m_20148_());
        DemonLord tempDemon = new DemonLord(context.getLevel());
        if (StructureUtils.isPointInStructure((ServerLevel)context.getLevel(), pos, tempDemon.getArenaStructureID(), tempDemon.getArenaStructureSegment())) {
            e.setSummonAsHostile();
        }
        context.getLevel().m_7967_((Entity)e);
        return true;
    }

    @Override
    protected int getApplicationTicks(IRitualContext context) {
        return 200;
    }
}

