/*
 * Decompiled with CFR 0.152.
 */
package com.mna.rituals.effects;

import com.mna.api.rituals.IRitualContext;
import com.mna.api.rituals.RitualEffect;
import com.mna.entities.utility.PresentItem;
import com.mna.items.ItemInit;
import com.mna.items.artifice.ThaumaturgicCompass;
import com.mna.items.ritual.ThaumaturgicLink;
import com.mna.rituals.effects.WorldUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RitualEffectLocate
extends RitualEffect {
    public RitualEffectLocate(ResourceLocation ritualName) {
        super(ritualName);
    }

    @Override
    protected boolean applyRitualEffect(IRitualContext context) {
        Optional thaumLinkOptional = context.getCollectedReagents(i -> i.m_41720_() == ItemInit.THAUMATURGIC_LINK.get()).stream().findFirst();
        if (!thaumLinkOptional.isPresent()) {
            return false;
        }
        ItemStack outputCompass = new ItemStack((ItemLike)ItemInit.THAUMATURGIC_COMPASS.get());
        ItemStack thaumLink = (ItemStack)thaumLinkOptional.get();
        boolean isBiome = false;
        BlockPos targetPos = WorldUtils.locateStructure((ServerLevel)context.getLevel(), context.getCenter(), thaumLink);
        if (targetPos == null) {
            isBiome = true;
            targetPos = WorldUtils.locateBiome((ServerLevel)context.getLevel(), context.getCenter(), thaumLink);
            if (targetPos == null) {
                context.getCollectedReagents().forEach(i -> {
                    ItemEntity item = new ItemEntity(context.getLevel(), (double)context.getCenter().m_123341_(), (double)context.getCenter().m_7494_().m_123342_(), (double)context.getCenter().m_123343_(), i);
                    context.getLevel().m_7967_((Entity)item);
                });
                if (context.getCaster() != null) {
                    context.getCaster().m_213846_((Component)Component.m_237115_((String)"mna:rituals/locating.failed"));
                }
                return false;
            }
        }
        context.getLevel().m_5594_((Player)null, context.getCenter(), SoundEvents.f_12107_, SoundSource.PLAYERS, 1.0f, 1.0f);
        ThaumaturgicCompass.setTrackedPosition(outputCompass, (ResourceKey<Level>)context.getLevel().m_46472_(), targetPos, ((ThaumaturgicLink)((Object)ItemInit.THAUMATURGIC_LINK.get())).getLocationKey(thaumLink), isBiome ? ThaumaturgicCompass.TrackType.Biome : ThaumaturgicCompass.TrackType.Structure);
        PresentItem epi = new PresentItem(context.getLevel(), context.getCenter().m_123341_(), context.getCenter().m_7494_().m_123342_(), context.getCenter().m_123343_(), outputCompass);
        context.getLevel().m_7967_((Entity)epi);
        return false;
    }

    @Override
    protected int getApplicationTicks(IRitualContext context) {
        return 0;
    }
}

