/*
 * Decompiled with CFR 0.152.
 */
package com.mna.rituals.effects;

import com.mna.api.capabilities.IRitualTeleportLocation;
import com.mna.api.capabilities.IWorldMagic;
import com.mna.api.rituals.IRitualContext;
import com.mna.api.rituals.RitualEffect;
import com.mna.capabilities.worlddata.WorldMagicProvider;
import com.mna.entities.EntityInit;
import com.mna.entities.rituals.Portal;
import com.mna.items.ritual.WorldCharm;
import com.mna.tools.TeleportHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistries;

public class RitualEffectReturn
extends RitualEffect {
    public RitualEffectReturn(ResourceLocation ritualName) {
        super(ritualName);
    }

    @Override
    protected boolean applyRitualEffect(IRitualContext context) {
        if (context.getCaster() == null) {
            return false;
        }
        List<ItemStack> reagents = context.getCollectedReagents();
        if (reagents.size() == 9 && !context.getLevel().f_46443_) {
            ServerLevel targetWorld;
            ResourceKey worldKey;
            ItemStack reagentEight = reagents.get(8);
            ResourceKey resourceKey = worldKey = !reagentEight.m_41619_() && reagentEight.m_41720_() instanceof WorldCharm ? ((WorldCharm)reagentEight.m_41720_()).GetWorldTarget(reagentEight) : context.getLevel().m_46472_();
            if (worldKey == null) {
                worldKey = context.getLevel().m_46472_();
            }
            if ((targetWorld = TeleportHelper.resolveRegistryKey((ServerLevel)context.getLevel(), worldKey.m_135782_())) == null) {
                context.getCaster().m_213846_((Component)Component.m_237115_((String)"mna:rituals/return.world_not_found"));
                return false;
            }
            LazyOptional worldMagicContainer = targetWorld.getCapability(WorldMagicProvider.MAGIC);
            if (worldMagicContainer.isPresent()) {
                IWorldMagic worldMagic = (IWorldMagic)worldMagicContainer.orElse(null);
                ArrayList<ResourceLocation> runes = new ArrayList<ResourceLocation>();
                for (int i = 0; i < 8; ++i) {
                    runes.add(ForgeRegistries.ITEMS.getKey((Object)reagents.get(i).m_41720_()));
                }
                IRitualTeleportLocation teleportTarget = worldMagic.getRitualTeleportBlockLocation(runes, (ResourceKey<Level>)worldKey);
                if (teleportTarget == null) {
                    context.getCaster().m_213846_((Component)Component.m_237115_((String)"mna:rituals/return.not_found"));
                    return false;
                }
                Portal portal = new Portal((EntityType)EntityInit.PORTAL_ENTITY.get(), context.getLevel());
                portal.m_146884_(Vec3.m_82539_((Vec3i)context.getCenter()));
                portal.setTeleportBlockPos(teleportTarget.getPos().m_7494_(), teleportTarget.getWorldType());
                context.getLevel().m_7967_((Entity)portal);
                return true;
            }
        }
        return true;
    }

    @Override
    protected int getApplicationTicks(IRitualContext context) {
        return 20;
    }
}

