/*
 * Decompiled with CFR 0.152.
 */
package com.mna.spells.components;

import com.mna.api.affinity.Affinity;
import com.mna.api.entities.DamageHelper;
import com.mna.api.faction.IFaction;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.SpellPartTags;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.attributes.AttributeValuePair;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.config.GeneralConfig;
import com.mna.particles.types.movers.ParticleVelocityMover;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class ComponentShatter
extends SpellEffect {
    public ComponentShatter(ResourceLocation guiIcon) {
        super(guiIcon, new AttributeValuePair(Attribute.DAMAGE, 10.0f, 10.0f, 40.0f, 5.0f, 7.0f));
        this.addReagent(new ItemStack((ItemLike)Items.f_41980_), new IFaction[0]);
    }

    @Override
    public int requiredXPForRote() {
        return 200;
    }

    @Override
    public ComponentApplicationResult ApplyEffect(SpellSource source, SpellTarget target, IModifiedSpellPart<SpellEffect> modificationData, SpellContext context) {
        if (!target.isLivingEntity()) {
            return ComponentApplicationResult.FAIL;
        }
        LivingEntity living = target.getLivingEntity();
        if (living.m_146890_()) {
            living.m_146917_(0);
            float damage = modificationData.getValue(Attribute.DAMAGE) * GeneralConfig.getDamageMultiplier();
            living.m_6469_(DamageHelper.createSourcedType(DamageHelper.FROST, context.getLevel().m_9598_(), (Entity)source.getCaster()), damage);
            context.getServerLevel().m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), SFX.Spell.Impact.Single.ICE, SoundSource.HOSTILE, 1.0f, 1.0f);
            context.getServerLevel().m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), SoundEvents.f_11983_, SoundSource.HOSTILE, 1.0f, 1.0f);
            return ComponentApplicationResult.SUCCESS;
        }
        return ComponentApplicationResult.FAIL;
    }

    @Override
    public void SpawnParticles(Level world, Vec3 impact_position, Vec3 normal, int age, LivingEntity caster, ISpellDefinition recipe) {
        if (age == 0) {
            RandomSource rnd = world.m_213780_();
            ItemStack ice = new ItemStack((ItemLike)Blocks.f_50126_);
            for (int i = 0; i < 25; ++i) {
                double dx = (-0.5 + rnd.m_188583_()) * 0.25;
                double dy = 0.25 + 0.5 * rnd.m_188500_();
                double dz = (-0.5 + rnd.m_188583_()) * 0.25;
                world.m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ITEM.get())).setStack(ice).setMover(new ParticleVelocityMover(dx, dy, dz, false)).setGravity(0.05f).setMaxAge(30).setPhysics(true), impact_position.f_82479_, impact_position.f_82480_ + rnd.m_188583_(), impact_position.f_82481_, dx, dy, dz);
            }
        }
    }

    @Override
    public boolean targetsBlocks() {
        return false;
    }

    @Override
    public Affinity getAffinity() {
        return Affinity.ICE;
    }

    @Override
    public float initialComplexity() {
        return 20.0f;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.HARMFUL;
    }
}

