/*
 * Decompiled with CFR 0.152.
 */
package com.mna.tools;

import com.mna.api.ManaAndArtificeMod;
import com.mna.api.items.DynamicItemFilter;
import com.mna.api.items.IPositionalItem;
import com.mna.api.tools.MATags;
import com.mna.inventory.InventoryRitualKit;
import com.mna.inventory.ItemInventoryBase;
import com.mna.items.ItemInit;
import com.mna.items.ritual.PractitionersPouch;
import com.mna.items.ritual.PractitionersPouchPatches;
import com.mna.items.runes.ItemRuneMarking;
import com.mna.items.sorcery.EntityCrystal;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import top.theillusivec4.curios.api.CuriosApi;

public class InventoryUtilities {
    public static boolean hasRoomFor(IItemHandler inventory, ItemStack item) {
        ItemStack workingCopy = item.m_41777_();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            if (!inventory.isItemValid(i, workingCopy)) continue;
            ItemStack remaining = inventory.insertItem(i, workingCopy, true);
            if (remaining.m_41619_()) {
                return true;
            }
            workingCopy.m_41764_(remaining.m_41613_());
        }
        return false;
    }

    public static boolean hasRoomForAny(IItemHandler inventory, ItemStack item) {
        ItemStack workingCopy = item.m_41777_();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack remaining;
            if (!inventory.isItemValid(i, workingCopy) || (remaining = inventory.insertItem(i, workingCopy, true)).m_41613_() == workingCopy.m_41613_()) continue;
            return true;
        }
        return false;
    }

    public static boolean mergeIntoInventory(IItemHandler handler, ItemStack toMerge) {
        return InventoryUtilities.mergeIntoInventory(handler, toMerge, toMerge.m_41613_());
    }

    public static boolean mergeIntoInventory(IItemHandler handler, ItemStack toMerge, int quantity) {
        return InventoryUtilities.mergeIntoInventory(handler, toMerge, quantity, false);
    }

    public static boolean mergeIntoInventory(IItemHandler handler, ItemStack toMerge, int quantity, boolean simulate) {
        if (quantity > toMerge.m_41613_()) {
            quantity = toMerge.m_41613_();
        }
        int emptySlot = -1;
        ItemStack insertStack = toMerge.m_41777_();
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (!handler.isItemValid(i, insertStack)) continue;
            ItemStack inventoryStack = handler.getStackInSlot(i);
            if (inventoryStack.m_41619_()) {
                if (emptySlot != -1) continue;
                emptySlot = i;
                continue;
            }
            if (!ItemStack.m_150942_((ItemStack)inventoryStack, (ItemStack)insertStack) || inventoryStack.m_41613_() >= handler.getSlotLimit(i)) continue;
            int spaceAvailable = handler.getSlotLimit(i) - inventoryStack.m_41613_();
            ItemStack split = insertStack.m_41620_(Math.min(quantity, spaceAvailable));
            ItemStack remainder = handler.insertItem(i, split, simulate);
            int amountInserted = split.m_41613_() - remainder.m_41613_();
            quantity -= amountInserted;
            if (!simulate) {
                toMerge.m_41764_(toMerge.m_41613_() - amountInserted);
            }
            if (quantity <= 0) {
                return true;
            }
            if (remainder.m_41613_() <= 0) continue;
            insertStack = remainder;
        }
        if (quantity > 0 && emptySlot > -1) {
            ItemStack insert = ItemStack.f_41583_;
            int maxStackSize = handler.getSlotLimit(emptySlot);
            if (insertStack.m_41613_() > maxStackSize) {
                insert = insertStack.m_41620_(maxStackSize);
                insert = handler.insertItem(emptySlot, insert, false);
                insertStack.m_41764_(insertStack.m_41613_() + insert.m_41613_());
            } else {
                insertStack = handler.insertItem(emptySlot, insertStack, false);
            }
            if (!simulate) {
                toMerge.m_41764_(insertStack.m_41613_());
            }
            return insertStack.m_41613_() == 0;
        }
        return false;
    }

    public static ItemStack mergeToPlayerInvPrioritizeOffhand(Player player, ItemStack toMerge) {
        if (player == null) {
            return toMerge;
        }
        ItemStack summonerOffhand = player.m_6844_(EquipmentSlot.OFFHAND);
        if (summonerOffhand.m_41619_()) {
            player.m_8061_(EquipmentSlot.OFFHAND, toMerge);
            return ItemStack.f_41583_;
        }
        if (ItemStack.m_150942_((ItemStack)toMerge, (ItemStack)summonerOffhand) && summonerOffhand.m_41613_() < summonerOffhand.m_41741_()) {
            int toAdd = Math.min(summonerOffhand.m_41741_() - summonerOffhand.m_41613_(), toMerge.m_41613_());
            summonerOffhand.m_41764_(summonerOffhand.m_41613_() + toAdd);
            toMerge.m_41764_(toMerge.m_41613_() - toAdd);
            if (toMerge.m_41613_() <= 0) {
                return ItemStack.f_41583_;
            }
        }
        if (player.m_36356_(toMerge)) {
            return ItemStack.f_41583_;
        }
        return toMerge;
    }

    public static ItemStack getFirstItemFromContainer(List<Item> items, int maxCount, IItemHandler handler, Direction side) {
        return InventoryUtilities.getFirstItemFromContainer(items, maxCount, handler, side, false);
    }

    public static ItemStack getFirstItemFromContainer(List<Item> items, int maxCount, IItemHandler handler, Direction side, boolean simulate) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.m_41619_() || items.size() != 0 && !items.contains(stack.m_41720_())) continue;
            int count = Math.min(stack.m_41613_(), maxCount);
            return handler.extractItem(i, count, simulate);
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getFirstItemFromContainer(DynamicItemFilter filter, int maxCount, IItemHandler handler, Direction side) {
        return InventoryUtilities.getFirstItemFromContainer(filter, maxCount, handler, side, false);
    }

    public static ItemStack getFirstItemFromContainer(DynamicItemFilter filter, int maxCount, IItemHandler handler, Direction side, boolean simulate) {
        return InventoryUtilities.getFirstItemFromContainer(filter, maxCount, handler, side, false, simulate);
    }

    public static ItemStack getFirstItemFromContainer(DynamicItemFilter filter, int maxCount, IItemHandler handler, Direction side, boolean randomFilterItem, boolean simulate) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).m_41619_()) continue;
            slots.add(i);
        }
        if (randomFilterItem) {
            Collections.shuffle(slots);
        }
        for (Integer i : slots) {
            ItemStack stack = handler.getStackInSlot(i.intValue());
            if (stack.m_41619_() || !filter.matches(stack)) continue;
            int count = Math.min(stack.m_41613_(), maxCount);
            if (simulate) {
                ItemStack extractedSimulated = handler.extractItem(i.intValue(), count, true);
                if (extractedSimulated.m_41619_()) continue;
                return extractedSimulated;
            }
            if (handler.extractItem(i.intValue(), count, true).m_41619_()) continue;
            return handler.extractItem(i.intValue(), count, false);
        }
        return ItemStack.f_41583_;
    }

    public static boolean hasStackInInventory(DynamicItemFilter search, IItemHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.m_41619_() || !search.matches(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasStackInInventory(ItemStack search, boolean ignoreDurability, boolean compareNBT, IItemHandler inventory) {
        int countToFind = search.m_41613_();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            boolean equal;
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            boolean bl = ignoreDurability ? ItemStack.m_41656_((ItemStack)stack, (ItemStack)search) : (equal = ItemStack.m_41656_((ItemStack)stack, (ItemStack)search) && stack.m_41773_() == search.m_41773_());
            if (compareNBT) {
                equal &= ManaAndArtificeMod.getItemHelper().AreTagsEqual(stack, search);
            }
            if (!equal || (countToFind -= stack.m_41613_()) > 0) continue;
            return true;
        }
        return false;
    }

    public static boolean removeItemFromInventory(ItemStack search, boolean ignoreDurability, boolean compareNBT, IItemHandler inventory) {
        int countToRemove = search.m_41613_();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            boolean equal;
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            boolean bl = ignoreDurability ? ItemStack.m_41656_((ItemStack)stack, (ItemStack)search) : (equal = ItemStack.m_41656_((ItemStack)stack, (ItemStack)search) && stack.m_41773_() == search.m_41773_());
            if (compareNBT) {
                equal = search.m_41720_() == ItemInit.ENTITY_ENTRAPMENT_CRYSTAL.get() ? (equal &= EntityCrystal.getEntityType(search) == EntityCrystal.getEntityType(stack)) : (equal &= ManaAndArtificeMod.getItemHelper().AreTagsEqual(stack, search));
            }
            if (!equal) continue;
            int removeQty = Math.min(countToRemove, stack.m_41613_());
            stack.m_41774_(removeQty);
            if ((countToRemove -= removeQty) > 0) continue;
            return true;
        }
        return false;
    }

    public static boolean hasStackInInventory(ItemStack search, boolean ignoreDurability, boolean compareNBT, IItemHandler inventory, Direction face) {
        int countToFind = search.m_41613_();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            boolean equal;
            ItemStack stack = inventory.extractItem(i, countToFind, true);
            if (stack.m_41619_()) continue;
            boolean bl = ignoreDurability ? ItemStack.m_41656_((ItemStack)stack, (ItemStack)search) : (equal = ItemStack.m_41656_((ItemStack)stack, (ItemStack)search) && stack.m_41773_() == search.m_41773_());
            if (compareNBT) {
                equal = search.m_41720_() == ItemInit.ENTITY_ENTRAPMENT_CRYSTAL.get() ? (equal &= EntityCrystal.getEntityType(search) == EntityCrystal.getEntityType(stack)) : (equal &= ManaAndArtificeMod.getItemHelper().AreTagsEqual(stack, search));
            }
            if (!equal || (countToFind -= stack.m_41613_()) > 0) continue;
            return true;
        }
        return false;
    }

    public static boolean removeItemFromInventory(ItemStack search, boolean ignoreDurability, boolean compareNBT, IItemHandler inventory, Direction face) {
        int countToRemove = search.m_41613_();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack extracted;
            boolean equal;
            ItemStack stack = inventory.extractItem(i, countToRemove, true);
            if (stack.m_41619_()) continue;
            boolean bl = ignoreDurability ? ItemStack.m_41656_((ItemStack)stack, (ItemStack)search) : (equal = ItemStack.m_41656_((ItemStack)stack, (ItemStack)search) && stack.m_41773_() == search.m_41773_());
            if (compareNBT) {
                equal &= ManaAndArtificeMod.getItemHelper().AreTagsEqual(stack, search);
            }
            if (!equal || (extracted = inventory.extractItem(i, countToRemove, false)).m_41619_() || (countToRemove -= extracted.m_41613_()) > 0) continue;
            return true;
        }
        return false;
    }

    public static boolean consumeAcrossInventories(ItemStack search, boolean ignoreDurability, boolean compareNBT, boolean simulate, List<Pair<IItemHandler, Direction>> inventories) {
        int count = search.m_41613_();
        for (int idx = 0; idx < inventories.size(); ++idx) {
            IItemHandler inventory = (IItemHandler)inventories.get(idx).getFirst();
            if (inventory == null) continue;
            boolean invConsumed = false;
            for (int i = 0; i < inventory.getSlots(); ++i) {
                boolean equal;
                ItemStack stack = inventory.extractItem(i, count, true);
                if (stack.m_41619_()) continue;
                boolean bl = ignoreDurability ? ItemStack.m_41656_((ItemStack)stack, (ItemStack)search) : (equal = ItemStack.m_41656_((ItemStack)stack, (ItemStack)search) && stack.m_41773_() == search.m_41773_());
                if (compareNBT) {
                    boolean tagMatch = ManaAndArtificeMod.getItemHelper().AreTagsEqual(stack, search);
                    if (stack.m_41783_() == null && search.m_41783_() != null && search.m_41783_().m_128456_()) {
                        tagMatch = true;
                    } else if (stack.m_41783_() != null && search.m_41783_() == null && stack.m_41783_().m_128456_()) {
                        tagMatch = true;
                    }
                    equal &= tagMatch;
                }
                if (!equal) continue;
                if (!simulate) {
                    ItemStack extracted = inventory.extractItem(i, count, false);
                    if (!extracted.m_41619_()) {
                        count -= extracted.m_41613_();
                        invConsumed = true;
                    }
                } else {
                    count -= stack.m_41613_();
                    invConsumed = true;
                }
                if (count > 0) continue;
                if (inventory instanceof ItemInventoryBase) {
                    ((ItemInventoryBase)inventory).writeItemStack();
                }
                return true;
            }
            if (!invConsumed || !(inventory instanceof ItemInventoryBase)) continue;
            ((ItemInventoryBase)inventory).writeItemStack();
        }
        return false;
    }

    public static boolean consumeAcrossInventories(List<Item> search, int count, boolean ignoreDurability, boolean compareNBT, boolean simulate, List<Pair<IItemHandler, Direction>> inventories) {
        for (int idx = 0; idx < inventories.size(); ++idx) {
            IItemHandler inventory = (IItemHandler)inventories.get(idx).getFirst();
            if (inventory == null) continue;
            boolean invConsumed = false;
            for (int i = 0; i < inventory.getSlots(); ++i) {
                boolean equal;
                ItemStack stack = inventory.extractItem(i, count, true);
                if (stack.m_41619_() || !(equal = search.contains(stack.m_41720_()))) continue;
                if (!simulate) {
                    ItemStack extracted = inventory.extractItem(i, count, false);
                    if (!extracted.m_41619_()) {
                        count -= extracted.m_41613_();
                        invConsumed = true;
                    }
                } else {
                    count -= stack.m_41613_();
                    invConsumed = true;
                }
                if (count > 0) continue;
                if (inventory instanceof ItemInventoryBase) {
                    ((ItemInventoryBase)inventory).writeItemStack();
                }
                return true;
            }
            if (!invConsumed || !(inventory instanceof ItemInventoryBase)) continue;
            ((ItemInventoryBase)inventory).writeItemStack();
        }
        return false;
    }

    public static int countItem(ItemStack search, IItemHandler inventory, Direction face, boolean compareNBT, boolean ignoreDurability) {
        int i = 0;
        for (int j = 0; j < inventory.getSlots(); ++j) {
            boolean equal;
            ItemStack stack = inventory.getStackInSlot(j);
            boolean bl = ignoreDurability ? ItemStack.m_41656_((ItemStack)stack, (ItemStack)search) : (equal = ItemStack.m_41656_((ItemStack)stack, (ItemStack)search) && stack.m_41773_() == search.m_41773_());
            if (!equal) continue;
            if (compareNBT) {
                boolean tagMatch = false;
                tagMatch = search.m_41720_() == ItemInit.ENTITY_ENTRAPMENT_CRYSTAL.get() ? EntityCrystal.getEntityType(search) == EntityCrystal.getEntityType(stack) : ManaAndArtificeMod.getItemHelper().AreTagsEqual(stack, search);
                if (stack.m_41783_() == null && search.m_41783_() != null && search.m_41783_().m_128456_()) {
                    tagMatch = true;
                } else if (stack.m_41783_() != null && search.m_41783_() == null && stack.m_41783_().m_128456_()) {
                    tagMatch = true;
                }
                equal &= tagMatch;
            }
            if (!equal) continue;
            i += stack.m_41613_();
        }
        return i;
    }

    public static int countItem(DynamicItemFilter filter, IItemHandler inventory, Direction face) {
        int i = 0;
        for (int j = 0; j < inventory.getSlots(); ++j) {
            ItemStack stack = inventory.getStackInSlot(j);
            boolean equal = filter.matches(stack);
            if (!equal) continue;
            i += stack.m_41613_();
        }
        return i;
    }

    public static ItemStack removeSingleItemFromInventory(ResourceLocation search, Container inventory) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_() || !MATags.isItemEqual(stack, search)) continue;
            return stack.m_41620_(1);
        }
        return ItemStack.f_41583_;
    }

    public static void redirectCaptureOrDrop(Player player, Level world, List<ItemStack> drops, boolean allowRedirect) {
        if (allowRedirect) {
            ItemStack mainHand = player.m_21205_();
            ItemStack offHand = player.m_21206_();
            BlockPos redirLoc = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(mainHand.m_41720_() instanceof IPositionalItem ? mainHand : offHand);
            if (redirLoc != null) {
                LazyOptional handler;
                BlockEntity te;
                Direction redirFace = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getFace(mainHand.m_41720_() instanceof IPositionalItem ? mainHand : offHand);
                if (world.m_46749_(redirLoc) && (te = world.m_7702_(redirLoc)) != null && (handler = te.getCapability(ForgeCapabilities.ITEM_HANDLER, redirFace)).isPresent()) {
                    for (int i = 0; i < drops.size(); ++i) {
                        if (!InventoryUtilities.mergeIntoInventory((IItemHandler)handler.resolve().get(), drops.get(i))) continue;
                        drops.remove(i);
                        --i;
                    }
                }
            }
        }
        ArrayList<InventoryRitualKit> playerKits = new ArrayList<InventoryRitualKit>();
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!(stack.m_41720_() instanceof PractitionersPouch) || ((PractitionersPouch)stack.m_41720_()).getPatchLevel(stack, PractitionersPouchPatches.COLLECTION) <= 0) continue;
            playerKits.add(new InventoryRitualKit(stack));
        }
        for (ItemStack stack : drops) {
            InventoryRitualKit kit;
            Iterator iterator = playerKits.iterator();
            while (iterator.hasNext() && !(stack = (kit = (InventoryRitualKit)iterator.next()).addItem(stack)).m_41619_()) {
            }
            if (stack.m_41619_() || player.m_36356_(stack)) continue;
            player.m_19983_(stack);
        }
        for (InventoryRitualKit kit : playerKits) {
            kit.writeItemStack();
        }
    }

    public static Pair<Boolean, Boolean> getCaptureAndRedirect(Player player) {
        boolean captureDrops = false;
        boolean redirectDrops = false;
        if (CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ItemInit.COLLECTOR_RING_GREATER.get()).isPresent()) {
            captureDrops = true;
            redirectDrops = true;
        } else if (CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ItemInit.COLLECTOR_RING_LESSER.get()).isPresent()) {
            captureDrops = true;
        }
        return new Pair((Object)captureDrops, (Object)redirectDrops);
    }

    public static void DropItemAt(ItemStack stack, Vec3 pos, Level world, boolean randomVelocity) {
        InventoryUtilities.DropItemAt(stack, pos, world, randomVelocity ? new Vec3(((double)world.f_46441_.m_188501_() - 0.5) * 0.1, ((double)world.f_46441_.m_188501_() - 0.5) * 0.1, ((double)world.f_46441_.m_188501_() - 0.5) * 0.1) : Vec3.f_82478_);
    }

    public static void DropItemAt(ItemStack stack, Vec3 pos, Level world, Vec3 velocity) {
        ItemEntity item = new ItemEntity(world, pos.f_82479_, pos.f_82480_, pos.f_82481_, stack.m_41777_());
        item.m_20256_(velocity);
        world.m_7967_((Entity)item);
    }

    public static boolean hasEmptySlot(IItemHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            if (!inventory.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public static void consumeByTag(IItemHandler inventory, ResourceLocation tag, int quantity) {
        List<Item> items = MATags.getItemTagContents(tag);
        InventoryUtilities.consumeAcrossInventories(items, quantity, true, false, false, Arrays.asList(new Pair((Object)inventory, (Object)Direction.UP)));
    }
}

