/*
 * Decompiled with CFR 0.152.
 */
package com.mna.tools;

import com.mna.api.blocks.tile.TileEntityWithInventory;
import com.mna.api.tools.MATags;
import com.mna.entities.EntityInit;
import com.mna.entities.boss.PumpkinKing;
import com.mna.events.seasonal.SeasonalHelper;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class ShearHelper {
    public static List<ItemStack> shearBlock(ServerLevel world, BlockPos position, Direction face, Player player) {
        return ShearHelper.shearBlock(world, position, face, player, new ItemStack((ItemLike)Items.f_42574_));
    }

    public static List<ItemStack> shearBlock(ServerLevel world, BlockPos position, Direction face, Player player, ItemStack shearStack) {
        List<ItemStack> output = new ArrayList<ItemStack>();
        if (world.m_5776_()) {
            return output;
        }
        if (ShearHelper.shearSpecial(world, position, face)) {
            return output;
        }
        BlockState targetState = world.m_8055_(position);
        if (targetState.m_60734_() instanceof IForgeShearable && (output = ShearHelper.shearIForgeShearable((IForgeShearable)targetState.m_60734_(), player, position, shearStack, (Level)world)).size() > 0) {
            return output;
        }
        BlockEntity te = world.m_7702_(position);
        if (te != null && (world.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent() || te instanceof TileEntityWithInventory)) {
            return output;
        }
        FakePlayer entity = FakePlayerFactory.get((ServerLevel)world, (GameProfile)player.m_36316_());
        entity.m_150109_().m_6211_();
        entity.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42574_));
        entity.m_6034_((double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_());
        output = new ArrayList();
        BlockHitResult brtr = new BlockHitResult(new Vec3((double)position.m_123341_() + 0.5, (double)position.m_123342_() + 0.5, (double)position.m_123343_() + 0.5), face, position, true);
        InteractionResult interRes = world.m_8055_(position).m_60664_((Level)world, (Player)entity, InteractionHand.MAIN_HAND, brtr);
        if (interRes == InteractionResult.FAIL || interRes == InteractionResult.PASS || interRes == InteractionResult.CONSUME) {
            List shearDrops = Block.m_49874_((BlockState)targetState, (ServerLevel)world, (BlockPos)position, (BlockEntity)te, (Entity)entity, (ItemStack)shearStack);
            List nonShearDrops = Block.m_49874_((BlockState)targetState, (ServerLevel)world, (BlockPos)position, (BlockEntity)te, (Entity)entity, (ItemStack)ItemStack.f_41583_);
            if (shearDrops.size() != nonShearDrops.size()) {
                world.m_7471_(position, false);
                output.addAll(shearDrops);
            } else {
                entity.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                for (ItemStack item : entity.m_150109_().f_35974_) {
                    if (item.m_41619_()) continue;
                    output.add(item);
                }
                for (ItemStack item : entity.m_150109_().f_35976_) {
                    if (item.m_41619_()) continue;
                    output.add(item);
                }
            }
        }
        return output;
    }

    public static List<ItemStack> shearEntity(ServerLevel world, Player player, Entity entity, InteractionHand hand) {
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        if (entity.m_9236_().m_5776_()) {
            return output;
        }
        if (entity instanceof IForgeShearable) {
            return ShearHelper.shearIForgeShearable((IForgeShearable)entity, player, entity.m_20183_(), player.m_21120_(hand), (Level)world);
        }
        return output;
    }

    public static boolean canBlockBeSheared(Level world, BlockState state, BlockPos pos) {
        if (state.m_60734_() instanceof IForgeShearable && ((IForgeShearable)state.m_60734_()).isShearable(new ItemStack((ItemLike)Items.f_42574_), world, pos)) {
            return true;
        }
        if (state.m_60734_() instanceof BeehiveBlock) {
            return (Integer)state.m_61143_((Property)BeehiveBlock.f_49564_) >= 5;
        }
        return MATags.isBlockIn(state.m_60734_(), MATags.Blocks.SHEARABLES);
    }

    private static List<ItemStack> shearIForgeShearable(IForgeShearable target, Player player, BlockPos pos, ItemStack heldItem, Level world) {
        List<Object> output = new ArrayList<ItemStack>();
        if (target.isShearable(heldItem, world, pos)) {
            int enchantmentLevel = heldItem.getEnchantmentLevel(Enchantments.f_44987_);
            output = target.onSheared(player, heldItem, world, pos, enchantmentLevel);
        }
        return output;
    }

    private static boolean shearSpecial(ServerLevel world, BlockPos pos, Direction face) {
        if (!SeasonalHelper.isHalloween()) {
            return false;
        }
        if (world.m_142425_((EntityTypeTest)EntityInit.PUMPKIN_KING.get(), new AABB(pos).m_82400_(16.0), e -> true).size() != 0) {
            return false;
        }
        for (int i = 1; i < 5; ++i) {
            if (world.m_46859_(pos.m_6630_(i))) continue;
            return false;
        }
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() == Blocks.f_50133_) {
            world.m_7471_(pos, false);
            PumpkinKing eds = new PumpkinKing((Level)world);
            eds.m_6034_((float)pos.m_123341_() + 0.5f, pos.m_123342_(), (float)pos.m_123343_() + 0.5f);
            eds.setupSpawn();
            switch (face) {
                case EAST: {
                    eds.m_146922_(270.0f);
                    break;
                }
                case NORTH: {
                    eds.m_146922_(-180.0f);
                    break;
                }
                case SOUTH: {
                    eds.m_146922_(0.0f);
                    break;
                }
                default: {
                    eds.m_146922_(90.0f);
                }
            }
            eds.f_19859_ = eds.m_146908_();
            eds.f_20883_ = eds.m_146908_();
            eds.f_20884_ = eds.m_146908_();
            world.m_7967_((Entity)eds);
            return true;
        }
        return false;
    }
}

