/*
 * Decompiled with CFR 0.152.
 */
package com.mna.tools;

import com.mna.api.tools.MATags;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class StructureUtils {
    public static boolean isPointInStructure(ServerLevel world, BlockPos pos) {
        return world.m_215010_().m_220486_(pos);
    }

    public static boolean isPointInStructure(ServerLevel world, BlockPos pos, ResourceLocation structureID, int pieceIndex) {
        Structure csf = MATags.getStructure(world, structureID);
        if (csf == null) {
            return false;
        }
        return world.m_215010_().m_220522_(pos).entrySet().stream().filter(entry -> csf == entry.getKey()).anyMatch(entry -> {
            StructureStart start = world.m_215010_().m_220494_(pos, (Structure)entry.getKey());
            if (start == null) {
                return false;
            }
            if (start.m_73602_().size() == 0) {
                return true;
            }
            if (pieceIndex < 0) {
                for (StructurePiece piece : start.m_73602_()) {
                    if (!piece.m_73547_().m_71051_((Vec3i)pos)) continue;
                    return true;
                }
            } else if (pieceIndex < start.m_73602_().size()) {
                return ((StructurePiece)start.m_73602_().get(pieceIndex)).m_73547_().m_71051_((Vec3i)pos);
            }
            return false;
        });
    }

    public static boolean isPointInAnyStructure(ServerLevel world, BlockPos pos, ResourceLocation structureTagID) {
        List<Holder<Structure>> taggedStructures = MATags.getStructureContents(world, structureTagID);
        if (taggedStructures.size() == 0) {
            return false;
        }
        return world.m_215010_().m_220522_(pos).entrySet().stream().filter(entry -> taggedStructures.stream().anyMatch(structure -> structure.m_203334_() == entry.getKey())).anyMatch(entry -> {
            StructureStart start = world.m_215010_().m_220494_(pos, (Structure)entry.getKey());
            if (start == null) {
                return false;
            }
            if (start.m_73602_().size() == 0) {
                return true;
            }
            for (StructurePiece piece : start.m_73602_()) {
                if (!piece.m_73547_().m_71051_((Vec3i)pos)) continue;
                return true;
            }
            return false;
        });
    }

    public static BoundingBox getStructureBoundingBoxAt(ServerLevel world, BlockPos pos, ResourceLocation structureID, int subPieceIndex) {
        Structure csf = MATags.getStructure(world, structureID);
        if (csf == null) {
            return null;
        }
        StructureStart start = world.m_215010_().m_220524_(pos, csf);
        if (start == null || start.m_73602_().size() == 0) {
            return null;
        }
        if (subPieceIndex > -1 && subPieceIndex < start.m_73602_().size()) {
            return ((StructurePiece)start.m_73602_().get(subPieceIndex)).m_73547_();
        }
        return start.m_73601_();
    }

    public static List<Holder<Structure>> getAllStructures(ServerLevel world) {
        ArrayList<Holder<Structure>> result = new ArrayList<Holder<Structure>>();
        Registry registry = world.m_9598_().m_175515_(Registries.f_256944_);
        registry.m_206115_().forEach(holder -> result.add((Holder<Structure>)holder));
        return result;
    }

    public static List<ResourceLocation> getAllStructureIDs(ServerLevel world) {
        ArrayList<ResourceLocation> result = new ArrayList<ResourceLocation>();
        Registry registry = world.m_9598_().m_175515_(Registries.f_256944_);
        registry.m_6579_().forEach(entry -> result.add(((ResourceKey)entry.getKey()).m_135782_()));
        return result;
    }

    @Nullable
    public static ResourceLocation getStructureID(ServerLevel world, Holder<Structure> structure) {
        if (!structure.m_203633_()) {
            return null;
        }
        Registry registry = world.m_9598_().m_175515_(Registries.f_256944_);
        return registry.m_7981_((Object)((Structure)structure.get()));
    }
}

