/*
 * Decompiled with CFR 0.152.
 */
package com.mna.tools.loot;

import com.mna.tools.loot.Conditional;
import com.mna.tools.loot.ICustomLootFunction;
import com.mna.tools.loot.LootDrop;
import java.util.stream.IntStream;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class LootFunctionHelper {
    private static final int STATISTICAL_TEST = 100;

    public static void applyFunction(ServerLevel serverLevel, LootItemFunction lootFunction, LootDrop lootDrop) {
        LootContext randContext = new LootContext.Builder(new LootParams.Builder(serverLevel).m_287235_(LootContextParamSets.f_81410_)).m_287259_(null);
        if (lootFunction instanceof SetItemCountFunction) {
            lootDrop.minDrop = LootFunctionHelper.getMin(serverLevel, ((SetItemCountFunction)lootFunction).f_80997_);
            if (lootDrop.minDrop < 0) {
                lootDrop.minDrop = 0;
            }
            lootDrop.item.m_41764_(Math.max(lootDrop.minDrop, 1));
            lootDrop.maxDrop = LootFunctionHelper.getMax(serverLevel, ((SetItemCountFunction)lootFunction).f_80997_);
        } else if (lootFunction instanceof SetItemDamageFunction) {
            ((SetItemDamageFunction)lootFunction).m_7372_(lootDrop.item, randContext);
        } else if (lootFunction instanceof EnchantRandomlyFunction || lootFunction instanceof EnchantWithLevelsFunction) {
            lootDrop.enchanted = true;
        } else if (!(lootFunction instanceof SmeltItemFunction)) {
            if (lootFunction instanceof LootingEnchantFunction) {
                lootDrop.addConditional(Conditional.affectedByLooting);
            } else if (lootFunction instanceof ICustomLootFunction) {
                ((ICustomLootFunction)lootFunction).apply(lootDrop);
            } else {
                try {
                    lootDrop.item = (ItemStack)lootFunction.apply((Object)lootDrop.item, null);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }

    public static int getMin(ServerLevel serverLevel, NumberProvider randomRange) {
        LootContext randContext = new LootContext.Builder(new LootParams.Builder(serverLevel).m_287235_(LootContextParamSets.f_81410_)).m_287259_(null);
        if (randomRange instanceof ConstantValue) {
            return randomRange.m_142683_(randContext);
        }
        if (randomRange instanceof UniformGenerator) {
            return Mth.m_14143_((float)((UniformGenerator)randomRange).f_165774_.m_142683_(randContext));
        }
        if (randomRange instanceof BinomialDistributionGenerator) {
            return 0;
        }
        return IntStream.iterate(0, i -> randomRange.m_142683_(randContext)).limit(100L).min().orElse(0);
    }

    public static int getMax(ServerLevel serverLevel, NumberProvider randomRange) {
        LootContext randContext = new LootContext.Builder(new LootParams.Builder(serverLevel).m_287235_(LootContextParamSets.f_81410_)).m_287259_(null);
        if (randomRange instanceof ConstantValue) {
            return randomRange.m_142683_(randContext);
        }
        if (randomRange instanceof UniformGenerator) {
            return Mth.m_14143_((float)((UniformGenerator)randomRange).f_165775_.m_142683_(randContext));
        }
        if (randomRange instanceof BinomialDistributionGenerator) {
            return ((BinomialDistributionGenerator)randomRange).f_165653_.m_142683_(randContext);
        }
        return IntStream.iterate(0, i -> randomRange.m_142683_(randContext)).limit(100L).max().orElse(0);
    }
}

