/*
 * Decompiled with CFR 0.152.
 */
package com.mna.tools.loot;

import com.mna.tools.loot.LootDrop;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class LootTableHelper {
    private static LootTableHelper instance;
    private static LootDataManager lootDataManager;

    public static LootTableHelper instance() {
        if (instance == null) {
            instance = new LootTableHelper();
        }
        return instance;
    }

    public static List<LootPool> getPoolsOBF(LootTable table) {
        return (List)ObfuscationReflectionHelper.getPrivateValue(LootTable.class, (Object)table, (String)"f_79109_");
    }

    public NumberProvider getRolls(LootPool pool) {
        return pool.getRolls();
    }

    public NumberProvider getBonusRolls(LootPool pool) {
        return pool.getBonusRolls();
    }

    public static List<LootPool> getPools(LootTable table) {
        return LootTableHelper.getPoolsOBF(table);
    }

    public static List<LootPoolEntryContainer> getLootEntries(LootPool pool) {
        return Arrays.asList(pool.f_79023_);
    }

    public static List<LootItemCondition> getLootConditions(LootPool pool) {
        return Arrays.asList(pool.f_79024_);
    }

    public static List<LootDrop> toDrops(ServerLevel serverLevel, LootTable table) {
        ArrayList<LootDrop> drops = new ArrayList<LootDrop>();
        LootDataManager lootDataManager = LootTableHelper.getLootDataManager((Level)serverLevel);
        LootContext baseContext = new LootContext.Builder(new LootParams.Builder(serverLevel).m_287235_(LootContextParamSets.f_81410_)).m_287259_(null);
        LootTableHelper.getPools(table).forEach(pool -> {
            float totalWeight = LootTableHelper.getLootEntries(pool).stream().filter(entry -> entry instanceof LootPoolSingletonContainer).map(entry -> (LootPoolSingletonContainer)entry).mapToInt(entry -> entry.f_79675_).sum();
            List<LootItemCondition> poolConditions = LootTableHelper.getLootConditions(pool);
            LootTableHelper.getLootEntries(pool).stream().filter(entry -> entry instanceof LootItem).map(entry -> (LootItem)entry).map(entry -> new LootDrop(serverLevel, entry.f_79564_, (float)entry.f_79675_ / totalWeight, entry.f_79636_, entry.f_79677_)).map(drop -> drop.addLootConditions(poolConditions)).forEach(d -> {
                d.minDrop *= pool.getRolls().m_142683_(baseContext);
                d.maxDrop *= pool.getRolls().m_142683_(baseContext) + pool.getBonusRolls().m_142683_(baseContext);
                drops.add((LootDrop)d);
            });
            LootTableHelper.getLootEntries(pool).stream().filter(entry -> entry instanceof LootTableReference).map(entry -> (LootTableReference)entry).map(entry -> LootTableHelper.toDrops(serverLevel, lootDataManager.m_278676_(entry.f_79754_))).forEach(drops::addAll);
        });
        drops.removeIf(Objects::isNull);
        return drops;
    }

    public static List<LootDrop> toDrops(ServerLevel serverLevel, ResourceLocation lootTable) {
        return LootTableHelper.toDrops(serverLevel, LootTableHelper.getLootDataManager((Level)serverLevel).m_278676_(lootTable));
    }

    public static LootDataManager getLootDataManager(Level level) {
        if (level.m_7654_() == null) {
            if (lootDataManager == null) {
                lootDataManager = new LootDataManager();
                return lootDataManager;
            }
            return lootDataManager;
        }
        return level.m_7654_().m_278653_();
    }
}

