/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.serialization.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import corgitaco.corgilib.serialization.codec.FromFileOps;
import corgitaco.corgilib.serialization.codec.Wrapped;
import java.util.Map;
import java.util.Optional;

public record FromFileCodec<E>(Codec<E> elementCodec, String internalKey) implements Codec<Wrapped<E>>
{
    public static <E> FromFileCodec<E> create(Codec<E> codec, String internalKey) {
        return new FromFileCodec<E>(codec, internalKey);
    }

    public <T> DataResult<Pair<Wrapped<E>, T>> decode(DynamicOps<T> ops, T input) {
        if (ops instanceof FromFileOps) {
            Wrapped wrapped;
            FromFileOps ops1 = (FromFileOps)ops;
            Map registry = ops1.getAccess(this.internalKey);
            DataResult id = Codec.STRING.decode(ops, input);
            if (id.result().isEmpty()) {
                return this.elementCodec.decode(ops, input).map(m -> m.mapFirst(e -> new Wrapped<Object>(Optional.empty(), e)));
            }
            Pair stringTPair = (Pair)id.result().get();
            String key = (String)stringTPair.getFirst();
            if (!registry.containsKey(key)) {
                return DataResult.error(() -> String.format("\"%s\" does not exist", key));
            }
            Object e = registry.get(key);
            if (e instanceof Wrapped) {
                Wrapped wrapped2 = (Wrapped)e;
                wrapped = wrapped2;
            } else {
                wrapped = new Wrapped(Optional.of(key), e);
            }
            return DataResult.success((Object)Pair.of(wrapped, (Object)stringTPair.getSecond()));
        }
        return this.elementCodec.decode(ops, input).map(etPair -> Pair.of(new Wrapped<Object>(Optional.empty(), etPair.getFirst()), (Object)etPair.getSecond()));
    }

    public <T> DataResult<T> encode(Wrapped<E> input, DynamicOps<T> ops, T prefix) {
        Optional<String> id = input.id();
        if (ops instanceof FromFileOps) {
            FromFileOps fromFileOps = (FromFileOps)ops;
            if (id.isPresent() && fromFileOps.getAccess(this.internalKey).containsKey(id.get())) {
                return Codec.STRING.encode((Object)id.get(), ops, prefix);
            }
        }
        return this.elementCodec.encode(input.value(), ops, prefix);
    }
}

