/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.candle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.data.candle.AbstractCandleEffect;
import net.joefoxe.hexerei.data.candle.CandleData;
import net.joefoxe.hexerei.tileentity.CandleTile;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.message.CandleEffectParticlePacket;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionCandleEffect
extends AbstractCandleEffect {
    private static final int MAX_TIME = 160;
    @Nullable
    public MobEffect effect;

    public PotionCandleEffect(@Nullable MobEffect effect, ParticleOptions particleOptions) {
        super(particleOptions);
        this.effect = effect;
    }

    public PotionCandleEffect(@Nullable MobEffect effect) {
        this.effect = effect;
    }

    @Override
    public void tick(Level level, CandleTile blockEntity, CandleData candleData) {
        if (this.effect == null) {
            return;
        }
        if (candleData.lit) {
            if (candleData.cooldown >= 160) {
                int duration = 200;
                if (!level.m_5776_()) {
                    PotionCandleEffect.applyEffects(level, blockEntity.m_58899_(), 5.0f, this.effect.m_8093_() ? 1 : (int)((float)duration * candleData.getEffectDurationMultiplier()), Math.max(0, (int)candleData.getEffectAmplifierMultiplier() - 1), this.effect, candleData.effectParticle, candleData);
                }
                candleData.cooldown = 0;
            }
            if (candleData.effectParticle != null && level.m_5776_() && candleData.effectParticle != null && candleData.effectParticle.size() > 0) {
                String resourceLocation = candleData.effectParticle.get(new Random().nextInt(candleData.effectParticle.size()));
                try {
                    this.particle = ParticleArgument.m_247456_((StringReader)new StringReader(resourceLocation), (HolderLookup)BuiltInRegistries.f_257034_.m_255303_());
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                }
            }
            candleData.cooldown = (candleData.cooldown + 1) % Integer.MAX_VALUE;
        }
    }

    private static void applyEffects(Level pLevel, BlockPos pPos, float size, int duration, int amplifier, @Nullable MobEffect pPrimary, List<String> particle, CandleData candleData) {
        if (pPrimary != null) {
            AABB aabb = new AABB(pPos).m_82400_((double)size).m_82363_(0.0, size * 4.0f < 4.0f ? 4.0 : (double)(size * 4.0f), 0.0);
            List list = pLevel.m_45976_(LivingEntity.class, aabb);
            PacketDistributor.TargetPoint point = new PacketDistributor.TargetPoint((double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), 500.0, pLevel.m_46472_());
            for (LivingEntity living : list) {
                if (pLevel.f_46443_) continue;
                living.m_7292_(new MobEffectInstance(pPrimary, duration, amplifier, true, false, true));
                if (particle == null || particle.size() <= 0) continue;
                HexereiPacketHandler.instance.send(PacketDistributor.NEAR.with(() -> point), (Object)new CandleEffectParticlePacket(pPos, particle, living.m_19879_(), 0));
            }
            if (particle != null && particle.size() > 0) {
                HexereiPacketHandler.instance.send(PacketDistributor.NEAR.with(() -> point), (Object)new CandleEffectParticlePacket(pPos, particle, 0, 1));
            }
        }
    }

    public static void spawnParticles(Level pLevel, List<String> particle, LivingEntity living) {
        float heightOffset = living.m_20206_() / 4.0f;
        for (int i = 0; i < 5; ++i) {
            float rotation = random.nextFloat() * 360.0f;
            Vec3 offset = new Vec3(random.nextDouble() * 2.0 * Math.cos(rotation), 0.0, random.nextDouble() * 2.0 * Math.sin(rotation));
            if (particle == null) continue;
            try {
                pLevel.m_7106_(ParticleArgument.m_247456_((StringReader)new StringReader(particle.get(random.nextInt(particle.size()))), (HolderLookup)BuiltInRegistries.f_257034_.m_255303_()), living.m_20185_(), living.m_20186_() + (double)heightOffset, living.m_20189_(), offset.f_82479_ / 32.0, (random.nextDouble() + 0.5) * 0.015, offset.f_82481_ / 32.0);
                continue;
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public <T> AbstractCandleEffect getCopy() {
        return new PotionCandleEffect(this.effect, this.particle);
    }

    @Override
    public String getLocationName() {
        ResourceLocation loc = this.effect == null ? null : ForgeRegistries.MOB_EFFECTS.getKey((Object)this.effect);
        return loc != null ? loc.toString() : this.effect.m_19481_();
    }
}

