/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.recipes;

import java.util.UUID;
import net.joefoxe.hexerei.data.recipes.ModRecipeTypes;
import net.joefoxe.hexerei.item.custom.BroomItem;
import net.joefoxe.hexerei.item.custom.WhistleItem;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class WhistleBindRecipe
extends CustomRecipe {
    public WhistleBindRecipe(ResourceLocation registryName, CraftingBookCategory cBc) {
        super(registryName, cBc);
    }

    public boolean m_5598_() {
        return true;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer p_44004_) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)p_44004_.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            Item item;
            ItemStack item2 = p_44004_.m_8020_(i);
            if (item2.hasCraftingRemainingItem()) {
                nonnulllist.set(i, (Object)item2.getCraftingRemainingItem());
            }
            if (!((item = item2.m_41720_()) instanceof BroomItem)) continue;
            BroomItem broomItem = (BroomItem)item;
            nonnulllist.set(i, (Object)item2.m_41777_());
        }
        return nonnulllist;
    }

    public boolean matches(CraftingContainer inventory, Level world) {
        int whistle = 0;
        int other = 0;
        int broom = 0;
        ItemStack whistleItem = null;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof WhistleItem) {
                ++whistle;
                whistleItem = stack;
            } else if (stack.m_41720_() instanceof BroomItem) {
                ++broom;
            } else {
                ++other;
            }
            if (other <= 1 && whistle <= 1 && broom <= 1) continue;
            return false;
        }
        return whistle == 1 && other == 0 && (broom == 1 || whistleItem.m_41782_() && whistleItem.m_41784_().m_128441_("UUID"));
    }

    public ItemStack assemble(CraftingContainer inventory, RegistryAccess pRegistryAccess) {
        ItemStack whistleItem = ItemStack.f_41583_;
        UUID broomUUID = null;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof WhistleItem) {
                whistleItem = stack.m_41777_();
                whistleItem.m_41764_(1);
            }
            if (!(stack.m_41720_() instanceof BroomItem)) continue;
            broomUUID = BroomItem.getUUID(stack);
        }
        if (broomUUID != null) {
            whistleItem.m_41784_().m_128362_("broomUUID", broomUUID);
        } else if (whistleItem.m_41782_()) {
            whistleItem.m_41784_().m_128473_("broomUUID");
        }
        return whistleItem;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 2 && height >= 1;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeTypes.WHISTLE_BIND_SERIALIZER.get();
    }
}

