/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.fluid;

import java.util.Collection;
import java.util.function.Consumer;
import net.joefoxe.hexerei.fluid.PotionFluid;
import net.joefoxe.hexerei.fluid.PotionFluidHandler;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;

public class PotionFluidType
extends FluidType {
    private final ResourceLocation stillTexture;
    private final ResourceLocation flowingTexture;

    public PotionFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
        super(properties);
        this.stillTexture = stillTexture;
        this.flowingTexture = flowingTexture;
    }

    public static int getTintColor(FluidStack stack) {
        CompoundTag tag = stack.getOrCreateTag();
        int color = PotionUtils.m_43564_((Collection)PotionUtils.m_43566_((CompoundTag)tag)) | 0xD0000000;
        return color;
    }

    public static int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
        return -1;
    }

    public String getDescriptionId(FluidStack stack) {
        CompoundTag tag = stack.getOrCreateTag();
        ItemLike itemFromBottleType = PotionFluidHandler.itemFromBottleType(HexereiUtil.readEnum(tag, "Bottle", PotionFluid.BottleType.class));
        return PotionUtils.m_43577_((CompoundTag)tag).m_43492_(itemFromBottleType.m_5456_().m_5524_() + ".effect.");
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return PotionFluidType.this.stillTexture;
            }

            public ResourceLocation getFlowingTexture() {
                return PotionFluidType.this.flowingTexture;
            }

            public int getTintColor(FluidStack stack) {
                return PotionFluidType.getTintColor(stack);
            }

            public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                return PotionFluidType.getTintColor(state, getter, pos);
            }
        });
    }
}

