/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.mixin.light;

import net.joefoxe.hexerei.light.LambHexereiDynamicLight;
import net.joefoxe.hexerei.light.LightManager;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityRenderer.class})
public class HexereiEntityRendererMixin<T extends Entity> {
    @Inject(method={"getBlockLightLevel"}, at={@At(value="RETURN")}, cancellable=true)
    private void onGetBlockLight(T entity, BlockPos pos, CallbackInfoReturnable<Integer> cir) {
        if (!LightManager.shouldUpdateDynamicLight()) {
            return;
        }
        int vanilla = cir.getReturnValueI();
        int entityLuminance = ((LambHexereiDynamicLight)entity).getLuminanceH();
        if (entityLuminance >= 15) {
            cir.setReturnValue((Object)entityLuminance);
        }
        int posLuminance = (int)LightManager.getDynamicLightLevel(pos);
        cir.setReturnValue((Object)Math.max(Math.max(vanilla, entityLuminance), posLuminance));
    }
}

