/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.particle;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.particle.CauldronParticleData;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public class CauldronParticle
extends TextureSheetParticle {
    private final ResourceLocation TEXTURE = new ResourceLocation("hexerei", "textures/particle/cauldron_boil_particle.png");
    public static final Vec3[] CUBE = new Vec3[]{new Vec3(-0.5, -0.1, -0.5), new Vec3(-0.5, -0.1, 0.5), new Vec3(0.5, -0.1, 0.5), new Vec3(0.5, -0.1, -0.5), new Vec3(0.5, 0.1, -0.5), new Vec3(0.5, 0.1, 0.5), new Vec3(-0.5, 0.1, 0.5), new Vec3(-0.5, 0.1, -0.5), new Vec3(-0.5, -0.1, 0.5), new Vec3(-0.5, 0.1, 0.5), new Vec3(0.5, 0.1, 0.5), new Vec3(0.5, -0.1, 0.5), new Vec3(0.5, -0.1, -0.5), new Vec3(0.5, 0.1, -0.5), new Vec3(-0.5, 0.1, -0.5), new Vec3(-0.5, -0.1, -0.5), new Vec3(-0.5, -0.1, -0.5), new Vec3(-0.5, 0.1, -0.5), new Vec3(-0.5, 0.1, 0.5), new Vec3(-0.5, -0.1, 0.5), new Vec3(0.5, -0.1, 0.5), new Vec3(0.5, 0.1, 0.5), new Vec3(0.5, 0.1, -0.5), new Vec3(0.5, -0.1, -0.5), new Vec3(0.5, -0.1, -0.5), new Vec3(0.5, -0.1, 0.5), new Vec3(-0.5, -0.1, 0.5), new Vec3(-0.5, -0.1, -0.5), new Vec3(-0.5, 0.1, -0.5), new Vec3(-0.5, 0.1, 0.5), new Vec3(0.5, 0.1, 0.5), new Vec3(0.5, 0.1, -0.5), new Vec3(-0.5, 0.1, 0.5), new Vec3(-0.5, -0.1, 0.5), new Vec3(0.5, -0.1, 0.5), new Vec3(0.5, 0.1, 0.5), new Vec3(0.5, 0.1, -0.5), new Vec3(0.5, -0.1, -0.5), new Vec3(-0.5, -0.1, -0.5), new Vec3(-0.5, 0.1, -0.5), new Vec3(-0.5, 0.1, -0.5), new Vec3(-0.5, -0.1, -0.5), new Vec3(-0.5, -0.1, 0.5), new Vec3(-0.5, 0.1, 0.5), new Vec3(0.5, 0.1, 0.5), new Vec3(0.5, -0.1, 0.5), new Vec3(0.5, -0.1, -0.5), new Vec3(0.5, 0.1, -0.5)};
    public static final Vec3[] CUBE_NORMALS = new Vec3[]{new Vec3(0.0, -0.1, 0.0), new Vec3(0.0, 0.25, 0.0), new Vec3(0.0, 0.0, 0.5), new Vec3(0.0, 0.0, -0.5), new Vec3(-0.5, 0.0, 0.0), new Vec3(0.5, 0.0, 0.0)};
    public static final ResourceLocation TEXTURE_BLANK = new ResourceLocation("hexerei", "textures/block/blank.png");
    private static final ParticleRenderType renderType = new ParticleRenderType(){

        public void m_6505_(BufferBuilder bufferBuilder, TextureManager textureManager) {
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_BLANK);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
        }

        public void m_6294_(Tesselator tesselator) {
            tesselator.m_85914_();
        }
    };
    protected float scale;
    protected float rotationDirection;
    protected float rotation;
    private IClientFluidTypeExtensions clientFluid;
    private boolean canPop;
    int pixelCol = -1;

    public CauldronParticle(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z);
        this.f_107215_ = motionX;
        this.f_107216_ = motionY;
        this.f_107217_ = motionZ;
        this.rotation = 0.0f;
        Random random = new Random();
        this.setScale(0.2f);
        this.setRotationDirection(random.nextFloat() - 0.5f);
        this.canPop = random.nextInt(3) == 0 && this.f_107225_ > 10;
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.m_107250_(scale * 0.5f, scale * 0.5f);
    }

    public void setRotationDirection(float rotationDirection) {
        this.rotationDirection = rotationDirection;
    }

    public void m_5989_() {
        this.rotation = this.rotationDirection * 0.1f + this.rotation;
        super.m_5989_();
    }

    public float ease(float x) {
        return (float)(1.0 - Math.pow(1.0f - x, 5.0));
    }

    public static float[] rgbaIntToFloatArray(int rgbInt) {
        int a = rgbInt >> 24 & 0xFF;
        int r = rgbInt >> 16 & 0xFF;
        int g = rgbInt >> 8 & 0xFF;
        int b = rgbInt >> 0 & 0xFF;
        return new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f};
    }

    public void m_5744_(VertexConsumer builder, Camera renderInfo, float partial) {
        Vec3 projectedView = renderInfo.m_90583_();
        float lerpX = (float)(Mth.m_14139_((double)partial, (double)this.f_107209_, (double)this.f_107212_) - projectedView.m_7096_());
        float lerpY = (float)(Mth.m_14139_((double)partial, (double)this.f_107210_, (double)this.f_107213_) - projectedView.m_7098_());
        float lerpZ = (float)(Mth.m_14139_((double)partial, (double)this.f_107211_, (double)this.f_107214_) - projectedView.m_7094_());
        int light = 0xF000F0;
        double ageMultiplier = 1.0 - Math.pow(Mth.m_14036_((float)((float)this.f_107224_ + partial), (float)0.0f, (float)this.f_107225_), 3.0) / Math.pow(this.f_107225_, 3.0);
        RenderSystem._setShaderTexture((int)0, (ResourceLocation)this.TEXTURE);
        for (int i = 0; i < 12; ++i) {
            for (int j = 0; j < 4; ++j) {
                float alpha = this.f_107230_ * 0.75f;
                Vec3 vec = CUBE[i * 4 + j];
                float popScale = Mth.m_14036_((float)((float)this.f_107224_ + partial - (float)(this.f_107225_ - 5)), (float)0.0f, (float)5.0f) / 5.0f;
                vec = vec.m_82524_(this.rotation).m_82490_((double)this.scale * ageMultiplier * (double)(this.canPop && i % 6 != 0 && i % 6 != 1 ? 1.0f + this.ease(popScale) : 1.0f)).m_82520_((double)lerpX, (double)lerpY, (double)lerpZ);
                Vec3 normal = CUBE_NORMALS[i % 6];
                if (this.canPop && popScale > 0.0f) {
                    vec = vec.m_82549_(normal.m_82524_(this.rotation).m_82490_((double)(this.ease(popScale) / 4.0f)));
                    alpha *= Mth.m_14036_((float)this.ease(Mth.m_14036_((float)(1.0f - popScale), (float)0.0f, (float)1.0f)), (float)0.0f, (float)1.0f);
                }
                float[] cols = CauldronParticle.rgbaIntToFloatArray(this.pixelCol);
                if (i / 6 == 1) {
                    normal = normal.m_82542_(-1.0, -1.0, -1.0);
                }
                if (i % 6 == 1) {
                    builder.m_5483_((double)((float)vec.f_82479_), (double)((float)vec.f_82480_), (double)((float)vec.f_82481_)).m_7421_(0.0f, 0.0f).m_85950_(Mth.m_14036_((float)(this.f_107227_ * 1.35f * cols[2]), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(this.f_107228_ * 1.35f * cols[1]), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(this.f_107229_ * 1.35f * cols[0]), (float)0.0f, (float)1.0f), alpha * cols[3]).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_85969_(0xF000F0).m_86008_(OverlayTexture.f_118083_).m_5752_();
                    continue;
                }
                if (i % 6 == 0) {
                    builder.m_5483_((double)((float)vec.f_82479_), (double)((float)vec.f_82480_), (double)((float)vec.f_82481_)).m_7421_(0.0f, 0.0f).m_85950_(Mth.m_14036_((float)(this.f_107227_ * 0.95f * cols[2]), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(this.f_107228_ * 0.95f * cols[1]), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(this.f_107229_ * 0.95f * cols[0]), (float)0.0f, (float)1.0f), alpha * cols[3]).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_85969_(0xF000F0).m_86008_(OverlayTexture.f_118083_).m_5752_();
                    continue;
                }
                if (i % 6 == 2) {
                    builder.m_5483_((double)((float)vec.f_82479_), (double)((float)vec.f_82480_), (double)((float)vec.f_82481_)).m_7421_(0.0f, 0.0f).m_85950_(Mth.m_14036_((float)(this.f_107227_ * 1.15f * cols[2]), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(this.f_107228_ * 1.15f * cols[1]), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(this.f_107229_ * 1.15f * cols[0]), (float)0.0f, (float)1.0f), alpha * cols[3]).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_85969_(0xF000F0).m_86008_(OverlayTexture.f_118083_).m_5752_();
                    continue;
                }
                if (i % 6 == 3) {
                    builder.m_5483_((double)((float)vec.f_82479_), (double)((float)vec.f_82480_), (double)((float)vec.f_82481_)).m_7421_(0.0f, 0.0f).m_85950_(Mth.m_14036_((float)(this.f_107227_ * 1.2f * cols[2]), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(this.f_107228_ * 1.2f * cols[1]), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(this.f_107229_ * 1.2f * cols[0]), (float)0.0f, (float)1.0f), alpha * cols[3]).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_85969_(0xF000F0).m_86008_(OverlayTexture.f_118083_).m_5752_();
                    continue;
                }
                if (i % 6 == 4) {
                    builder.m_5483_((double)((float)vec.f_82479_), (double)((float)vec.f_82480_), (double)((float)vec.f_82481_)).m_7421_(0.0f, 0.0f).m_85950_(Mth.m_14036_((float)(this.f_107227_ * 1.25f * cols[2]), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(this.f_107228_ * 1.25f * cols[1]), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(this.f_107229_ * 1.25f * cols[0]), (float)0.0f, (float)1.0f), alpha * cols[3]).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_85969_(0xF000F0).m_86008_(OverlayTexture.f_118083_).m_5752_();
                    continue;
                }
                builder.m_5483_((double)((float)vec.f_82479_), (double)((float)vec.f_82480_), (double)((float)vec.f_82481_)).m_7421_(0.0f, 0.0f).m_85950_(Mth.m_14036_((float)(this.f_107227_ * 1.2f * cols[2]), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(this.f_107228_ * 1.2f * cols[1]), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(this.f_107229_ * 1.2f * cols[0]), (float)0.0f, (float)1.0f), alpha * cols[3]).m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_85969_(0xF000F0).m_86008_(OverlayTexture.f_118083_).m_5752_();
            }
        }
    }

    public ParticleRenderType m_7556_() {
        return renderType;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<CauldronParticleData> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        @Nullable
        public Particle createParticle(CauldronParticleData data, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ResourceLocation stillLoc;
            CauldronParticle cauldronParticle = new CauldronParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
            Random random = new Random();
            Object mixingCauldronTile = null;
            FluidStack fluidStack = data.fluid;
            Color color = new Color(BiomeColors.m_108811_((BlockAndTintGetter)worldIn, (BlockPos)new BlockPos((int)x, (int)y, (int)z)));
            BlockState blockStateAtPos = worldIn.m_8055_(new BlockPos((int)x, (int)(y - 0.1), (int)z));
            cauldronParticle.clientFluid = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
            Function textureAtlasSpriteFunction = Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_);
            TextureAtlasSprite sprite = (TextureAtlasSprite)textureAtlasSpriteFunction.apply(stillLoc = cauldronParticle.clientFluid.getStillTexture(fluidStack));
            if (sprite != null) {
                cauldronParticle.pixelCol = sprite.getPixelRGBA(0, random.nextInt(sprite.m_245424_().m_246492_()), random.nextInt(sprite.m_245424_().m_245330_()));
            }
            int colorInt = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack);
            float alpha = (float)(colorInt >> 24 & 0xFF) / 275.0f;
            float red = (float)(colorInt >> 16 & 0xFF) / 275.0f;
            float green = (float)(colorInt >> 8 & 0xFF) / 275.0f;
            float blue = (float)(colorInt & 0xFF) / 275.0f;
            float colorOffset = random.nextFloat() * 0.15f;
            cauldronParticle.m_107253_(Mth.m_14036_((float)(red + colorOffset), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(green + colorOffset), (float)0.0f, (float)1.0f), Mth.m_14036_((float)(blue + colorOffset), (float)0.0f, (float)1.0f));
            if (fluidStack.isFluidEqual(new FluidStack((Fluid)Fluids.f_76193_, 1))) {
                cauldronParticle.m_107253_((float)color.getRed() / 450.0f + colorOffset, (float)color.getGreen() / 450.0f + colorOffset, (float)color.getBlue() / 450.0f + colorOffset);
            }
            cauldronParticle.m_107271_(1.0f);
            cauldronParticle.m_108335_(this.spriteSet);
            return cauldronParticle;
        }
    }
}

