/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Optional;
import net.joefoxe.hexerei.client.renderer.entity.custom.BroomEntity;
import net.joefoxe.hexerei.container.BroomContainer;
import net.joefoxe.hexerei.util.HexereiTags;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class BroomScreen
extends AbstractContainerScreen<BroomContainer> {
    private final ResourceLocation GUI = new ResourceLocation("hexerei", "textures/gui/broom_gui.png");
    private final ResourceLocation INVENTORY = new ResourceLocation("hexerei", "textures/gui/inventory.png");
    public final BroomEntity broomEntity;
    public float dropdownOffset = 0.0f;
    public int offset = 0;
    public boolean dropdownClicked = false;

    public BroomScreen(BroomContainer broomContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)broomContainer, inv, titleIn);
        this.broomEntity = broomContainer.broomEntity;
        this.f_97729_ = -33;
        this.f_97728_ = 4;
        this.f_97731_ = 60;
    }

    protected void m_181908_() {
        super.m_181908_();
        this.dropdownOffset = this.dropdownClicked ? HexereiUtil.moveTo(this.dropdownOffset, 58.0f, 4.0f) : HexereiUtil.moveTo(this.dropdownOffset, 0.0f, 4.0f);
    }

    protected void m_7856_() {
        super.m_7856_();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        this.renderButtonTooltip(guiGraphics, mouseX, mouseY);
    }

    public Component m_96636_() {
        return super.m_96636_();
    }

    public boolean isHovering(double mouseX, double mouseY, double x, double y, double width, double height) {
        return mouseX >= (double)this.f_97735_ + x && mouseX < (double)this.f_97735_ + x + width && mouseY >= (double)this.f_97736_ + y && mouseY < (double)this.f_97736_ + y + height;
    }

    public void renderButtonTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int offset = 0;
        if (this.broomEntity.getModule(BroomEntity.BroomSlot.SATCHEL).m_204117_(HexereiTags.Items.SMALL_SATCHELS)) {
            offset = 21;
        }
        if (this.broomEntity.getModule(BroomEntity.BroomSlot.SATCHEL).m_204117_(HexereiTags.Items.MEDIUM_SATCHELS)) {
            offset = 42;
        }
        if (this.broomEntity.getModule(BroomEntity.BroomSlot.SATCHEL).m_204117_(HexereiTags.Items.LARGE_SATCHELS)) {
            offset = 63;
        }
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
        if (this.isHovering(mouseX, mouseY, 188.25, 89 + offset - 34, 18.0, 18.0)) {
            components.add(Component.m_237115_((String)"tooltip.hexerei.broom_settings"));
            guiGraphics.m_280677_(Minecraft.m_91087_().f_91062_, components, Optional.empty(), mouseX, mouseY);
        } else if (this.dropdownOffset > 29.0f) {
            if (this.isHovering(mouseX, mouseY, 188.25, 88 + offset + (int)this.dropdownOffset - 34, 18.0, 18.0)) {
                components.add(Component.m_237115_((String)"tooltip.hexerei.broom_float_mode_off"));
                if (Screen.m_96638_()) {
                    components.add(Component.m_237110_((String)"<%s>", (Object[])new Object[]{Component.m_237115_((String)"tooltip.hexerei.shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAA6600)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                    components.add(Component.m_237115_((String)"tooltip.hexerei.broom_float_mode_off_0").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                } else {
                    components.add(Component.m_237110_((String)"[%s]", (Object[])new Object[]{Component.m_237115_((String)"tooltip.hexerei.shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAAAA00)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                }
                guiGraphics.m_280677_(Minecraft.m_91087_().f_91062_, components, Optional.empty(), mouseX, mouseY);
            }
            if (this.isHovering(mouseX, mouseY, 188.25, 60 + offset + (int)this.dropdownOffset - 34, 18.0, 18.0)) {
                components.add(Component.m_237115_((String)"tooltip.hexerei.broom_float_mode_on"));
                if (Screen.m_96638_()) {
                    components.add(Component.m_237110_((String)"<%s>", (Object[])new Object[]{Component.m_237115_((String)"tooltip.hexerei.shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAA6600)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                    components.add(Component.m_237115_((String)"tooltip.hexerei.broom_float_mode_on_0").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                    components.add(Component.m_237115_((String)"tooltip.hexerei.broom_float_mode_on_1").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                } else {
                    components.add(Component.m_237110_((String)"[%s]", (Object[])new Object[]{Component.m_237115_((String)"tooltip.hexerei.shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAAAA00)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                }
                guiGraphics.m_280677_(Minecraft.m_91087_().f_91062_, components, Optional.empty(), mouseX, mouseY);
            }
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.offset = 0;
        if (this.broomEntity.getModule(BroomEntity.BroomSlot.SATCHEL).m_204117_(HexereiTags.Items.SMALL_SATCHELS)) {
            this.offset = 21;
        }
        if (this.broomEntity.getModule(BroomEntity.BroomSlot.SATCHEL).m_204117_(HexereiTags.Items.MEDIUM_SATCHELS)) {
            this.offset = 42;
        }
        if (this.broomEntity.getModule(BroomEntity.BroomSlot.SATCHEL).m_204117_(HexereiTags.Items.LARGE_SATCHELS)) {
            this.offset = 63;
        }
        this.f_97731_ = 94 + this.offset - 34;
        guiGraphics.m_280218_(this.GUI, i + 184, j + 55 + this.offset + (int)this.dropdownOffset - 34, 230, 164, 26, 58);
        if (((BroomContainer)this.f_97732_).getFloatMode()) {
            guiGraphics.m_280218_(this.GUI, i + 188, j + 60 + this.offset + (int)this.dropdownOffset - 34, 238, 106, 18, 18);
        } else {
            guiGraphics.m_280218_(this.GUI, i + 188, j + 88 + this.offset + (int)this.dropdownOffset - 34, 238, 70, 18, 18);
        }
        guiGraphics.m_280218_(this.GUI, i, j - 3 - 34, 0, 0, 214, 82);
        guiGraphics.m_280218_(this.GUI, i, j + 79 + this.offset - 34, 0, 82, 214, 34);
        if (!this.broomEntity.getModule(BroomEntity.BroomSlot.MISC).m_41619_()) {
            guiGraphics.m_280218_(this.GUI, i + 37, j + 47 - 34, 235, 31, 16, 16);
        }
        if (!this.broomEntity.getModule(BroomEntity.BroomSlot.SATCHEL).m_41619_()) {
            guiGraphics.m_280218_(this.GUI, i + 99, j + 47 - 34, 235, 31, 16, 16);
        }
        if (!this.broomEntity.getModule(BroomEntity.BroomSlot.BRUSH).m_41619_()) {
            guiGraphics.m_280218_(this.GUI, i + 160, j + 47 - 34, 235, 31, 16, 16);
        }
        if (!this.broomEntity.isEnder()) {
            ItemStack satchel = this.broomEntity.getModule(BroomEntity.BroomSlot.SATCHEL);
            if (satchel.m_204117_(HexereiTags.Items.SMALL_SATCHELS)) {
                guiGraphics.m_280218_(this.GUI, i, j + 79 - 34, 0, 116, 214, 21);
            }
            if (satchel.m_204117_(HexereiTags.Items.MEDIUM_SATCHELS)) {
                guiGraphics.m_280218_(this.GUI, i, j + 79 - 34, 0, 116, 214, 21);
                guiGraphics.m_280218_(this.GUI, i, j + 79 + 21 - 34, 0, 116, 214, 21);
            }
            if (satchel.m_204117_(HexereiTags.Items.LARGE_SATCHELS)) {
                guiGraphics.m_280218_(this.GUI, i, j + 79 - 34, 0, 116, 214, 21);
                guiGraphics.m_280218_(this.GUI, i, j + 79 + 21 - 34, 0, 116, 214, 21);
                guiGraphics.m_280218_(this.GUI, i, j + 79 + 42 - 34, 0, 116, 214, 21);
            }
        } else {
            guiGraphics.m_280218_(this.GUI, i, j + 79 - 34, 0, 200, 214, 21);
            guiGraphics.m_280218_(this.GUI, i, j + 79 + 21 - 34, 0, 200, 214, 21);
            guiGraphics.m_280218_(this.GUI, i, j + 79 + 42 - 34, 0, 200, 214, 21);
            guiGraphics.m_280218_(this.GUI, i, j + 79 + 42 - 34 + 21, 0, 221, 214, 5);
            guiGraphics.m_280218_(this.GUI, i, j + 75 - 34, 0, 137, 214, 72);
        }
        guiGraphics.m_280218_(this.GUI, i + 94, j - 30 - 34, 230, 0, 26, 26);
        if (this.dropdownClicked) {
            guiGraphics.m_280218_(this.GUI, i + 188, j + 89 + this.offset - 34, 238, 124, 18, 18);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.INVENTORY);
        guiGraphics.m_280218_(this.INVENTORY, i + 3, j + 88 + this.offset - 34, 0, 0, 176, 100);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        int extraBrush = this.broomEntity.getExtraBrush();
        if (this.broomEntity.isReplacer() && extraBrush != -1) {
            guiGraphics.m_280218_(this.GUI, i + 12 + 21 * ((extraBrush - 3) % 9), j + 21 * ((extraBrush - 3) / 9) + 79 - 34, 234, 142, 22, 22);
        }
        Minecraft minecraft = Minecraft.m_91087_();
        ItemRenderer itemRenderer = minecraft.m_91291_();
        RenderSystem.disableDepthTest();
        guiGraphics.m_280480_(this.broomEntity.m_142340_(), this.f_97735_ + 99, this.f_97736_ - 25 - 34);
        MutableComponent misc = Component.m_237115_((String)"tooltip.hexerei.broom_misc");
        MutableComponent satchel = Component.m_237115_((String)"tooltip.hexerei.broom_satchel");
        MutableComponent brush = Component.m_237115_((String)"tooltip.hexerei.broom_brush");
        this.drawFont(guiGraphics, misc, this.f_97735_ + 34, this.f_97736_ + 29 - 34, -10461088, false);
        this.drawFont(guiGraphics, satchel, this.f_97735_ + 89, this.f_97736_ + 29 - 34, -10461088, false);
        this.drawFont(guiGraphics, brush, this.f_97735_ + 154, this.f_97736_ + 29 - 34, -10461088, false);
    }

    private void drawFont(GuiGraphics guiGraphics, MutableComponent component, float x, float y, int color, boolean shadow) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(x, y, 1.0f);
        guiGraphics.m_280614_(this.f_96541_.f_91062_, (Component)component, 0, 0, color, shadow);
        guiGraphics.m_280168_().m_85849_();
    }

    public boolean m_6375_(double x, double y, int button) {
        boolean mouseClicked = super.m_6375_(x, y, button);
        if (this.dropdownOffset > 29.0f) {
            if (x > (double)((float)this.f_97735_ + 188.25f) && x < (double)((float)this.f_97735_ + 188.25f + 18.0f) && y > (double)(this.f_97736_ + 88 + this.offset + (int)this.dropdownOffset - 34) && y < (double)(this.f_97736_ + 88 + this.offset + (int)this.dropdownOffset + 18 - 34)) {
                ((BroomContainer)this.f_97732_).setFloatMode(false);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            }
            if (x > (double)((float)this.f_97735_ + 188.25f) && x < (double)((float)this.f_97735_ + 188.25f + 18.0f) && y > (double)(this.f_97736_ + 60 + this.offset + (int)this.dropdownOffset - 34) && y < (double)(this.f_97736_ + 60 + this.offset + (int)this.dropdownOffset + 18 - 34)) {
                ((BroomContainer)this.f_97732_).setFloatMode(true);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            }
        }
        if (x > (double)((float)this.f_97735_ + 188.25f) && x < (double)((float)this.f_97735_ + 188.25f + 18.0f) && y > (double)(this.f_97736_ + 89 + this.offset - 34) && y < (double)(this.f_97736_ + 89 + 18 + this.offset - 34)) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            this.dropdownClicked = !this.dropdownClicked;
        }
        return mouseClicked;
    }
}

