/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.MixingCauldron;
import net.joefoxe.hexerei.container.MixingCauldronContainer;
import net.joefoxe.hexerei.fluid.PotionFluidHandler;
import net.joefoxe.hexerei.integration.HexereiModNameTooltipCompat;
import net.joefoxe.hexerei.integration.jei.HexereiJei;
import net.joefoxe.hexerei.screen.renderer.FluidStackRenderer;
import net.joefoxe.hexerei.tileentity.MixingCauldronTile;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.joefoxe.hexerei.util.message.DrainCauldronToServer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;

public class MixingCauldronScreen
extends AbstractContainerScreen<MixingCauldronContainer> {
    private final ResourceLocation GUI = new ResourceLocation("hexerei", "textures/gui/mixing_cauldron_gui.png");
    private final ResourceLocation INVENTORY = new ResourceLocation("hexerei", "textures/gui/inventory.png");
    private final FluidStackRenderer renderer;
    private float dumpOffset;
    public boolean clickedDump;
    public MixingCauldronTile mixingCauldron;
    private static final int FRONT_BLIT_LAYER = 1;
    private static final int BACK_BLIT_LAYER = 0;

    public MixingCauldronScreen(MixingCauldronContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        BlockEntity blockEntity = screenContainer.tileEntity;
        if (blockEntity instanceof MixingCauldronTile) {
            MixingCauldronTile mixingCauldronTile;
            this.mixingCauldron = mixingCauldronTile = (MixingCauldronTile)blockEntity;
        }
        this.f_97729_ = 4;
        this.f_97728_ = 28;
        this.f_97731_ = 108;
        this.f_97730_ = 12;
        this.renderer = new FluidStackRenderer(2000, true, 16, 32);
        this.dumpOffset = 0.0f;
        this.clickedDump = false;
    }

    private boolean isMouseAboveArea(int pMouseX, int pMouseY, int x, int y, int offsetX, int offsetY) {
        return MixingCauldronScreen.isMouseOver(pMouseX, pMouseY, x + offsetX, y + offsetY, this.renderer.getWidth(), this.renderer.getHeight());
    }

    public static boolean isMouseOver(double mouseX, double mouseY, int x, int y, int sizeX, int sizeY) {
        return mouseX >= (double)x && mouseX <= (double)(x + sizeX) && mouseY >= (double)y && mouseY <= (double)(y + sizeY);
    }

    private void drawFont(GuiGraphics guiGraphics, Component component, float x, float y, int z, int color, float scalePercent, boolean shadow) {
        guiGraphics.m_280168_().m_85836_();
        if (scalePercent != 0.0f) {
            guiGraphics.m_280168_().m_85841_(1.0f / scalePercent, 1.0f / scalePercent, 1.0f / scalePercent);
        }
        guiGraphics.m_280168_().m_252880_(x, y, (float)z);
        guiGraphics.m_280614_(this.f_96541_.f_91062_, component, 0, 0, color, shadow);
        guiGraphics.m_280168_().m_85849_();
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int pMouseX, int pMouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        ItemRenderer itemRenderer = minecraft.m_91291_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.dumpOffset = MixingCauldronScreen.isMouseOver(pMouseX, pMouseY, i + 20 - (int)this.dumpOffset, j + 56, 10 + (int)this.dumpOffset, 32) ? HexereiUtil.moveTo(this.dumpOffset, 31.0f, 2.0f * ((32.0f - this.dumpOffset) / 31.0f)) : HexereiUtil.moveTo(this.dumpOffset, 0.0f, Math.abs(2.0f * ((-1.0f - this.dumpOffset) / 31.0f)));
        MutableComponent component = Component.m_237115_((String)"Dump");
        float width = this.f_96547_.m_92724_(component.m_7532_());
        guiGraphics.m_280398_(this.GUI, i + 20 - (int)this.dumpOffset, j + 56, 0, 216.0f, 61.0f, 40, 32, 256, 256);
        if (this.clickedDump) {
            guiGraphics.m_280398_(this.GUI, i + 20 - (int)this.dumpOffset + 9, j + 56 + 9, 0, 226.0f, 47.0f, 30, 14, 256, 256);
        }
        Objects.requireNonNull(minecraft.f_91062_);
        float lineHeight = 9.0f / 2.0f;
        if (width > 20.0f) {
            float percent = width / 20.0f;
            this.drawFont(guiGraphics, (Component)component, ((float)i + 44.5f - width / percent / 2.0f - (float)((int)this.dumpOffset)) * percent + (this.clickedDump ? 1.0f : 0.0f), ((float)(j + 68) + lineHeight) * percent - 4.5f + (this.clickedDump ? 1.0f : 0.0f), 0, -12566464, percent, false);
        } else {
            this.drawFont(guiGraphics, (Component)component, (float)i + 44.5f - width / 2.0f - (float)((int)this.dumpOffset) + (this.clickedDump ? 1.0f : 0.0f), (float)(j + 68) + lineHeight - 4.5f + (this.clickedDump ? 1.0f : 0.0f), 0, -10461088, 1.0f, false);
        }
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        guiGraphics.m_280398_(this.GUI, i, j, 1, 0.0f, 0.0f, 207, 127, 256, 256);
        guiGraphics.m_280398_(this.GUI, i + 150, j + 52, 1, 220.0f, 0.0f, (int)(22.0f * ((MixingCauldronContainer)this.f_97732_).getCraftPercent()), 8, 256, 256);
        guiGraphics.m_280398_(this.GUI, i + 109, j + 46, 1, 242.0f, 0.0f, 8, (int)(22.0f * ((MixingCauldronContainer)this.f_97732_).getCraftPercent()), 256, 256);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.INVENTORY);
        guiGraphics.m_280398_(this.INVENTORY, i + 6, j + 102, 1, 0.0f, 0.0f, 176, 100, 256, 256);
        if (((MixingCauldronContainer)this.f_97732_).getRenderedFluid() != null) {
            FluidStack stack = ((MixingCauldronContainer)this.f_97732_).getRenderedFluid().copy();
            this.renderer.render(guiGraphics, i + 42, j + 56, stack);
        }
        RenderSystem.disableDepthTest();
        guiGraphics.m_280480_(new ItemStack((ItemLike)((MixingCauldron)ModBlocks.MIXING_CAULDRON.get()).m_5456_()), this.f_97735_ + 86, this.f_97736_ - 25);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        guiGraphics.m_280398_(this.GUI, i + 81, j - 30, 1, 230.0f, 21.0f, 26, 26, 256, 256);
        guiGraphics.m_280398_(this.GUI, i + 42, j + 56, 1, 208.0f, 12.0f, 16, 32, 256, 256);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        if (this.isMouseAboveArea(mouseX, mouseY, x, y, 42, 56)) {
            ArrayList<Component> tooltip = new ArrayList<Component>(this.renderer.getTooltip(((MixingCauldronContainer)this.f_97732_).getRenderedFluid() != null ? ((MixingCauldronContainer)this.f_97732_).getRenderedFluid() : ((MixingCauldronContainer)this.f_97732_).getFluid(), (TooltipFlag)TooltipFlag.Default.f_256752_));
            PotionFluidHandler.addPotionTooltip(((MixingCauldronContainer)this.f_97732_).getFluid(), tooltip, 1.0f);
            FluidStack fluidStack = ((MixingCauldronContainer)this.f_97732_).getFluid();
            if (!fluidStack.isEmpty()) {
                String modId = HexereiUtil.getRegistryName(fluidStack.getFluid()).m_135827_();
                String modName = HexereiUtil.getModNameForModId(modId);
                MutableComponent modNameComponent = Component.m_237115_((String)modName);
                modNameComponent.m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(0x5555FF));
                if (!HexereiModNameTooltipCompat.LOADED) {
                    tooltip.add((Component)modNameComponent);
                }
            }
            guiGraphics.m_280677_(Minecraft.m_91087_().f_91062_, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0) {
            this.clickedDump = false;
        }
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int button) {
        boolean mouseClicked = super.m_6375_(pMouseX, pMouseY, button);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        if (this.isMouseAboveArea((int)pMouseX, (int)pMouseY, x, y, 42, 56) && ModList.get().isLoaded("jei")) {
            if (button == 0) {
                HexereiJei.showRecipe(this.mixingCauldron.getFluidStack());
            }
            if (button == 1) {
                HexereiJei.showUses(this.mixingCauldron.getFluidStack());
            }
        }
        if (MixingCauldronScreen.isMouseOver(pMouseX, pMouseY, this.f_97735_ + 20 - (int)this.dumpOffset + 9, this.f_97736_ + 56 + 9, 30, 14) && this.dumpOffset > 20.0f) {
            this.clickedDump = true;
            if (this.mixingCauldron != null && this.mixingCauldron.m_58904_() != null && this.mixingCauldron.m_58904_().f_46443_) {
                HexereiPacketHandler.sendToServer(new DrainCauldronToServer(this.mixingCauldron));
            }
        }
        return mouseClicked;
    }
}

