/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import java.util.function.Supplier;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.screen.CourierLetterScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundOpenCourierLetterScreenPacket {
    int slotIndex;
    InteractionHand hand;

    public ClientboundOpenCourierLetterScreenPacket(int slotIndex, InteractionHand hand) {
        this.slotIndex = slotIndex;
        this.hand = hand;
    }

    public static void encode(ClientboundOpenCourierLetterScreenPacket object, FriendlyByteBuf buffer) {
        buffer.writeInt(object.slotIndex);
        buffer.writeBoolean(object.hand == InteractionHand.MAIN_HAND);
    }

    public static ClientboundOpenCourierLetterScreenPacket decode(FriendlyByteBuf buffer) {
        return new ClientboundOpenCourierLetterScreenPacket(buffer.readInt(), buffer.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
    }

    public static void consume(ClientboundOpenCourierLetterScreenPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                Level world = Hexerei.proxy.getLevel();
            } else {
                if (((NetworkEvent.Context)ctx.get()).getSender() == null) {
                    return;
                }
                Level world = ((NetworkEvent.Context)ctx.get()).getSender().m_9236_();
            }
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
                if (Minecraft.m_91087_().f_91074_ != null) {
                    ClientboundOpenCourierLetterScreenPacket.setScreen(packet.slotIndex, packet.hand, packet.slotIndex > 0 ? Minecraft.m_91087_().f_91074_.m_150109_().m_8020_(packet.slotIndex) : Minecraft.m_91087_().f_91074_.m_21120_(InteractionHand.OFF_HAND));
                }
            });
        });
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setScreen(int slotIndex, InteractionHand hand, ItemStack stack) {
        Minecraft.m_91087_().m_91152_((Screen)new CourierLetterScreen(slotIndex, hand, stack));
    }
}

