/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import java.util.function.Supplier;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.item.custom.DowsingRodItem;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class DowsingRodUpdatePositionPacket {
    ItemStack itemStack;
    BlockPos blockPos;
    Boolean swampMode;

    public DowsingRodUpdatePositionPacket(ItemStack itemStack, BlockPos blockPos, Boolean swampMode) {
        this.itemStack = itemStack;
        this.blockPos = blockPos;
        this.swampMode = swampMode;
    }

    public DowsingRodUpdatePositionPacket(FriendlyByteBuf buf) {
        this.itemStack = buf.m_130267_();
        this.blockPos = buf.m_130135_();
        this.swampMode = buf.readBoolean();
    }

    public static void encode(DowsingRodUpdatePositionPacket object, FriendlyByteBuf buffer) {
        buffer.m_130055_(object.itemStack);
        buffer.m_130064_(object.blockPos);
        buffer.writeBoolean(object.swampMode.booleanValue());
    }

    public static DowsingRodUpdatePositionPacket decode(FriendlyByteBuf buffer) {
        return new DowsingRodUpdatePositionPacket(buffer);
    }

    public static void consume(DowsingRodUpdatePositionPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                Level world = Hexerei.proxy.getLevel();
            } else {
                if (((NetworkEvent.Context)ctx.get()).getSender() == null) {
                    return;
                }
                Level world = ((NetworkEvent.Context)ctx.get()).getSender().m_9236_();
            }
            ((DowsingRodItem)packet.itemStack.m_41720_()).nearestPos = packet.blockPos;
            ((DowsingRodItem)packet.itemStack.m_41720_()).swampMode = packet.swampMode;
        });
        ctx.get().setPacketHandled(true);
    }
}

