/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.datagen;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.common.blocks.ElementalTurret;
import alexthw.ars_elemental.common.blocks.SporeBlossomGround;
import alexthw.ars_elemental.datagen.Datagen;
import alexthw.ars_elemental.registry.ModItems;
import com.hollingsworth.arsnouveau.common.block.ArchfruitPod;
import com.hollingsworth.arsnouveau.common.block.SpellPrismBlock;
import com.hollingsworth.arsnouveau.common.block.StrippableLog;
import com.hollingsworth.arsnouveau.common.block.TickableModBlock;
import java.util.HashSet;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class AEBlockStateProvider
extends BlockStateProvider {
    public AEBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "ars_elemental", exFileHelper);
    }

    protected void registerStatesAndModels() {
        HashSet blocks = new HashSet(ModItems.BLOCKS.getEntries());
        Datagen.takeAll(blocks, b -> b.get() instanceof FlowerPotBlock).forEach(this::registerOnlyState);
        Datagen.takeAll(blocks, b -> b.get() instanceof TickableModBlock || b.get() instanceof ElementalTurret || b.get() instanceof SpellPrismBlock);
        Datagen.takeAll(blocks, b -> b.get() instanceof RotatedPillarBlock || b.get() instanceof StrippableLog).forEach(this::logBlock);
        Datagen.takeAll(blocks, b -> b.get() instanceof SlabBlock).forEach(this::slabBlock);
        Datagen.takeAll(blocks, b -> b.get() instanceof StairBlock).forEach(this::stairsBlock);
        Datagen.takeAll(blocks, b -> b.get() instanceof LeavesBlock);
        Datagen.takeAll(blocks, b -> b.get() instanceof SaplingBlock);
        Datagen.takeAll(blocks, b -> b.get() instanceof ArchfruitPod);
        Datagen.takeAll(blocks, b -> b.get() instanceof SporeBlossomGround);
        blocks.forEach(this::basicBlock);
    }

    public void registerOnlyState(RegistryObject<Block> obj) {
        this.simpleBlock((Block)obj.get(), (ModelFile)new ModelFile.UncheckedModelFile(ArsElemental.prefix("block/" + obj.getId().m_135815_())));
    }

    public void slabBlock(RegistryObject<Block> blockRegistryObject) {
        String name = blockRegistryObject.getId().m_135815_();
        String baseName = name.substring(0, name.length() - 5);
        this.slabBlock((SlabBlock)blockRegistryObject.get(), ArsElemental.prefix(baseName), ArsElemental.prefix("block/" + baseName));
    }

    public void logBlock(RegistryObject<Block> blockRegistryObject) {
    }

    public void stairsBlock(RegistryObject<Block> blockRegistryObject) {
        String name = blockRegistryObject.getId().m_135815_();
        String baseName = name.substring(0, name.length() - 7);
        this.stairsBlock((StairBlock)blockRegistryObject.get(), ArsElemental.prefix("block/" + baseName));
    }

    public void basicBlock(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlock((Block)blockRegistryObject.get());
    }

    @NotNull
    public String m_6055_() {
        return "Ars Elemental BlockStates";
    }
}

