/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbfiltersystem.FTBFilterSystem;
import dev.ftb.mods.ftbfiltersystem.api.FilterException;
import dev.ftb.mods.ftbfiltersystem.network.FTBFilterSystemNet;
import dev.ftb.mods.ftbfiltersystem.registry.item.SmartFilterItem;
import dev.ftb.mods.ftbfiltersystem.util.FilterParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class SyncFilterMessage
extends BaseC2SMessage {
    private final String filterStr;
    @Nullable
    private final String newTitle;
    private final InteractionHand hand;

    public SyncFilterMessage(String filterStr, @Nullable String newTitle, InteractionHand hand) {
        this.filterStr = filterStr;
        this.newTitle = newTitle;
        this.hand = hand;
    }

    public SyncFilterMessage(FriendlyByteBuf buf) {
        this.filterStr = buf.m_130277_();
        this.newTitle = (String)buf.m_236868_(FriendlyByteBuf::m_130277_);
        this.hand = (InteractionHand)buf.m_130066_(InteractionHand.class);
    }

    public MessageType getType() {
        return FTBFilterSystemNet.SYNC_FILTER;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130070_(this.filterStr);
        buf.m_236821_((Object)this.newTitle, FriendlyByteBuf::m_130070_);
        buf.m_130068_((Enum)this.hand);
    }

    public void handle(NetworkManager.PacketContext context) {
        ItemStack stack = context.getPlayer().m_21120_(this.hand);
        if (stack.m_41720_() instanceof SmartFilterItem) {
            try {
                SmartFilterItem.setFilter(stack, FilterParser.parse(this.filterStr).toString());
                if (this.newTitle != null) {
                    if (this.newTitle.isEmpty()) {
                        stack.m_41787_();
                    } else {
                        stack.m_41714_((Component)Component.m_237113_((String)this.newTitle));
                    }
                }
            }
            catch (FilterException e) {
                FTBFilterSystem.LOGGER.error("received filter sync message with bad filter data from client {}: {}", (Object)context.getPlayer().m_36316_().getName(), (Object)e.getMessage());
            }
        }
    }
}

