/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.registry.item;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftbfiltersystem.FilterSystemCommands;
import dev.ftb.mods.ftbfiltersystem.api.FilterException;
import dev.ftb.mods.ftbfiltersystem.api.filter.SmartFilter;
import dev.ftb.mods.ftbfiltersystem.client.FTBFilterSystemClient;
import dev.ftb.mods.ftbfiltersystem.registry.ModItems;
import dev.ftb.mods.ftbfiltersystem.util.FilterParser;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SmartFilterItem
extends Item {
    private static final String FILTER_TAG_NAME = "ftbfiltersystem:filter";

    public SmartFilterItem() {
        super(ModItems.defaultProps());
    }

    public static String getFilterString(ItemStack filterStack) {
        return filterStack.m_41782_() ? filterStack.m_41783_().m_128461_(FILTER_TAG_NAME) : "";
    }

    public static SmartFilter getFilter(ItemStack filterStack) throws FilterException {
        return FilterParser.parse(SmartFilterItem.getFilterString(filterStack));
    }

    public static void setFilter(ItemStack filterStack, String string) {
        filterStack.m_41784_().m_128359_(FILTER_TAG_NAME, string);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack stack = player.m_21120_(interactionHand);
        if (level.f_46443_ && !player.m_6047_()) {
            FTBFilterSystemClient.INSTANCE.openFilterScreen(interactionHand);
        } else if (!level.f_46443_ && player.m_6047_()) {
            try {
                FilterSystemCommands.tryMatch(player.m_20203_());
            }
            catch (CommandSyntaxException | FilterException e) {
                player.m_5661_((Component)Component.m_237113_((String)e.getMessage()).m_130940_(ChatFormatting.RED), false);
            }
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        if (level == null || level.f_46443_ && !FTBFilterSystemClient.shouldShowItemTooltip()) {
            return;
        }
        list.add((Component)Component.m_237115_((String)"item.ftbfiltersystem.smart_filter.tooltip.1").m_130940_(ChatFormatting.GRAY));
        list.add((Component)Component.m_237115_((String)"item.ftbfiltersystem.smart_filter.tooltip.2").m_130940_(ChatFormatting.GRAY));
    }
}

