/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.util;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class NBTUtil {
    public static boolean compareNbt(@Nullable Tag tagA, @Nullable Tag tagB, boolean fuzzy, boolean compareLists) {
        if (tagA == tagB) {
            return true;
        }
        if (tagA == null) {
            return true;
        }
        if (tagB == null) {
            return false;
        }
        if (!tagA.m_6458_().equals(tagB.m_6458_())) {
            return false;
        }
        if (tagA instanceof CompoundTag) {
            CompoundTag compoundA = (CompoundTag)tagA;
            if (tagB instanceof CompoundTag) {
                CompoundTag compoundB = (CompoundTag)tagB;
                Set keysA = compoundA.m_128431_();
                Set keysB = compoundB.m_128431_();
                if (!(fuzzy || keysA.size() == keysB.size() && Sets.intersection((Set)keysA, (Set)keysB).size() == keysA.size())) {
                    return false;
                }
                return keysA.stream().allMatch(key -> NBTUtil.compareNbt(compoundA.m_128423_(key), compoundB.m_128423_(key), fuzzy, compareLists));
            }
        }
        if (compareLists && tagA instanceof ListTag) {
            ListTag listA = (ListTag)tagA;
            if (tagB instanceof ListTag) {
                ListTag listB = (ListTag)tagB;
                if (listA.isEmpty()) {
                    return listB.isEmpty();
                }
                if (listA.size() != listB.size()) {
                    return false;
                }
                return IntStream.range(0, listA.size()).allMatch(i -> NBTUtil.compareNbt(listA.get(i), listB.get(i), fuzzy, true));
            }
        }
        return tagA.equals(tagB);
    }
}

