/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.datagen;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import cy.jdkdigital.productivebees.datagen.BlockLootProvider;
import cy.jdkdigital.productivetrees.common.block.ProductiveFruitBlock;
import cy.jdkdigital.productivetrees.registry.TreeFinder;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.loot.CanToolPerformAction;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class LootDataProvider
implements DataProvider {
    private final PackOutput.PathProvider pathProvider;
    private final List<LootTableProvider.SubProviderEntry> subProviders;

    public LootDataProvider(PackOutput output, List<LootTableProvider.SubProviderEntry> providers) {
        this.pathProvider = output.m_245269_(PackOutput.Target.DATA_PACK, "loot_tables");
        this.subProviders = providers;
    }

    public String m_6055_() {
        return "Productive Trees Block Loot Table datagen";
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        HashMap map = Maps.newHashMap();
        this.subProviders.forEach(providerEntry -> ((LootTableSubProvider)providerEntry.f_243941_().get()).m_245126_((resourceLocation, builder) -> {
            builder.m_287223_(resourceLocation);
            if (map.put(resourceLocation, builder.m_79165_(providerEntry.f_244144_()).m_79167_()) != null) {
                throw new IllegalStateException("Duplicate loot table " + resourceLocation);
            }
        }));
        return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(entry -> DataProvider.m_253162_((CachedOutput)cache, (JsonElement)LootDataType.f_278413_.m_278857_().toJsonTree(entry.getValue()), (Path)this.pathProvider.m_245731_((ResourceLocation)entry.getKey()))).toArray(CompletableFuture[]::new));
    }

    public static class LootProvider
    extends BlockLootSubProvider {
        private static final float[] NORMAL_LEAVES_SAPLING_CHANCES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
        private static final float[] JUNGLE_LEAVES_SAPLING_CHANGES = new float[]{0.025f, 0.027777778f, 0.03125f, 0.041666668f, 0.1f};
        private static final float[] NORMAL_LEAVES_STICK_CHANCES = new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f};
        private static final Map<Block, Function<Block, LootTable.Builder>> functionTable = new HashMap<Block, Function<Block, LootTable.Builder>>();
        private static final LootItemCondition.Builder SHEARS_DIG = CanToolPerformAction.canToolPerformAction((ToolAction)ToolActions.SHEARS_DIG);
        private static final LootItemCondition.Builder SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));
        private static final LootItemCondition.Builder SHEARS_OR_SILK = SHEARS_DIG.m_285888_(SILK_TOUCH);
        private final List<Block> knownBlocks = new ArrayList<Block>();

        public LootProvider() {
            super(Set.of(), FeatureFlags.f_244280_.m_247355_());
        }

        protected void m_245660_() {
            this.m_245724_((Block)TreeRegistrator.SAWMILL.get());
            this.m_245724_((Block)TreeRegistrator.STRIPPER.get());
            this.m_245724_((Block)TreeRegistrator.WOOD_WORKER.get());
            this.m_245724_((Block)TreeRegistrator.POLLEN_SIFTER.get());
            this.m_245724_((Block)TreeRegistrator.TIME_TRAVELLER_DISPLAY.get());
            this.m_245724_((Block)TreeRegistrator.COCONUT_SPROUT.get());
            TreeFinder.trees.forEach((id, treeObject) -> {
                float[] saplingChance = treeObject.getStyle().saplingStyle().equals("jungle") ? JUNGLE_LEAVES_SAPLING_CHANGES : NORMAL_LEAVES_SAPLING_CHANCES;
                this.m_246481_(TreeUtil.getBlock(id, "_leaves"), leaf -> LootProvider.createOptionalLeavesDrops(leaf, TreeUtil.getBlock(id, "_sapling"), saplingChance));
                if (treeObject.hasFruit()) {
                    this.m_246481_(TreeUtil.getBlock(id, "_fruit"), leaf -> LootProvider.createFruitLeavesDrops(leaf, TreeUtil.getBlock(id, "_sapling"), treeObject.getFruit().getItem().m_41720_(), saplingChance));
                }
                this.m_245724_(TreeUtil.getBlock(id, "_sapling"));
                this.m_245724_(TreeUtil.getBlock(id, "_log"));
                this.m_245724_(TreeUtil.getBlock(id, "_planks"));
                this.m_245724_(TreeUtil.getBlock(id, "_wood"));
                this.m_245724_(TreeUtil.getBlock(id, "_stripped_log"));
                this.m_245724_(TreeUtil.getBlock(id, "_stripped_wood"));
                this.m_245724_(TreeUtil.getBlock(id, "_slab"));
                this.m_245724_(TreeUtil.getBlock(id, "_stairs"));
                this.m_245724_(TreeUtil.getBlock(id, "_fence"));
                this.m_245724_(TreeUtil.getBlock(id, "_fence_gate"));
                this.m_245724_(TreeUtil.getBlock(id, "_pressure_plate"));
                this.m_245724_(TreeUtil.getBlock(id, "_button"));
                this.dropDoor(TreeUtil.getBlock(id, "_door"));
                this.m_245724_(TreeUtil.getBlock(id, "_trapdoor"));
                this.m_245724_(TreeUtil.getBlock(id, "_bookshelf"));
                this.m_245724_(TreeUtil.getBlock(id, "_sign"));
                this.m_246125_(TreeUtil.getBlock(id, "_wall_sign"), (ItemLike)TreeUtil.getBlock(id, "_sign"));
                this.m_245724_(TreeUtil.getBlock(id, "_hanging_sign"));
                this.m_246125_(TreeUtil.getBlock(id, "_wall_hanging_sign"), (ItemLike)TreeUtil.getBlock(id, "_hanging_sign"));
                if (treeObject.getStyle().hiveStyle() != null) {
                    Block hive = (Block)ForgeRegistries.BLOCKS.getValue(treeObject.getId().m_247266_(p -> "advanced_" + p + "_beehive"));
                    Function<Block, LootTable.Builder> hiveFunc = functionTable.getOrDefault(hive, BlockLootProvider::genHiveDrop);
                    this.m_247577_(hive, hiveFunc.apply(hive));
                    Block box = (Block)ForgeRegistries.BLOCKS.getValue(treeObject.getId().m_247266_(p -> "expansion_box_" + p));
                    Function<Block, LootTable.Builder> expansionFunc = functionTable.getOrDefault(box, BlockLootProvider::genExpansionDrop);
                    this.m_247577_(box, expansionFunc.apply(box));
                }
            });
            TreeRegistrator.CRATED_CROPS.forEach(cratePath -> this.m_245724_((Block)ForgeRegistries.BLOCKS.getValue(cratePath)));
        }

        protected void m_247577_(Block block, LootTable.Builder builder) {
            super.m_247577_(block, builder);
            this.knownBlocks.add(block);
        }

        protected Iterable<Block> getKnownBlocks() {
            return this.knownBlocks;
        }

        protected void m_246481_(Block block, Function<Block, LootTable.Builder> builderFunction) {
            this.m_247577_(block, builderFunction.apply(block));
        }

        public void m_245724_(@NotNull Block block) {
            Function<Block, LootTable.Builder> func = functionTable.getOrDefault(block, LootProvider::genOptionalBlockDrop);
            this.m_247577_(block, func.apply(block));
        }

        public void dropDoor(@NotNull Block block) {
            this.m_246481_(block, x$0 -> this.m_247398_((Block)x$0));
        }

        @NotNull
        protected static LootTable.Builder createOptionalLeavesDrops(Block block, Block sapling, float ... dropChances) {
            return LootProvider.m_246160_(block, ((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)sapling).m_79080_(ExplosionCondition.m_81661_())).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])dropChances))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(SHEARS_OR_SILK.m_81807_()).m_79076_(LootItem.m_79579_((ItemLike)Items.f_42398_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])NORMAL_LEAVES_STICK_CHANCES))));
        }

        @NotNull
        protected static LootTable.Builder m_246160_(Block block, LootPoolEntryContainer.Builder<?> builder) {
            return LootProvider.m_246900_(block, (LootItemCondition.Builder)SHEARS_DIG.m_285888_(SILK_TOUCH), builder);
        }

        @NotNull
        protected static LootTable.Builder createFruitLeavesDrops(Block block, Block sapling, Item fruit, float ... dropChances) {
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)sapling).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])dropChances))).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)Items.f_42398_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])NORMAL_LEAVES_STICK_CHANCES)))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)fruit).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)ProductiveFruitBlock.getAgeProperty(), ProductiveFruitBlock.getMaxAge())))).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_())));
        }

        @NotNull
        protected static LootTable.Builder m_246900_(Block block, LootItemCondition.Builder conditions, LootPoolEntryContainer.Builder<?> alternative) {
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79080_(conditions)).m_7170_(alternative)));
        }

        protected static LootTable.Builder genOptionalBlockDrop(Block block) {
            LootPoolEntryContainer.Builder builder = LootItem.m_79579_((ItemLike)block).m_79080_(ExplosionCondition.m_81661_());
            return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(builder));
        }
    }
}

