/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.datagen.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.registry.WoodObject;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public record SawmillRecipeBuilder(Ingredient log, ItemStack plank, ItemStack secondary, ItemStack tertiary) implements RecipeBuilder
{
    public static SawmillRecipeBuilder direct(Ingredient logs, ItemStack plank, ItemStack secondary, ItemStack tertiary) {
        return new SawmillRecipeBuilder(logs, plank, secondary, tertiary);
    }

    public static SawmillRecipeBuilder tree(WoodObject tree, TagKey<Item> woodTag, Block plank) {
        ItemStack tertiary = tree.getId().m_135815_().equals("old_fustic") ? new ItemStack((ItemLike)TreeRegistrator.FUSTIC.get()) : (tree.getId().m_135815_().equals("logwood") || tree.getId().m_135815_().equals("brazilwood") ? new ItemStack((ItemLike)TreeRegistrator.HAEMATOXYLIN.get()) : ItemStack.f_41583_);
        return SawmillRecipeBuilder.direct(Ingredient.m_204132_(woodTag), new ItemStack((ItemLike)plank, 6), new ItemStack((ItemLike)TreeRegistrator.SAWDUST.get(), 2), tertiary);
    }

    public RecipeBuilder m_126132_(String name, CriterionTriggerInstance criterion) {
        return null;
    }

    public RecipeBuilder m_126145_(@Nullable String p_176495_) {
        return null;
    }

    public Item m_142372_() {
        return this.plank.m_41720_();
    }

    public void m_126140_(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.log, this.plank, this.secondary, this.tertiary));
    }

    static JsonObject itemToJson(ItemStack item) {
        JsonObject json = new JsonObject();
        json.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)item.m_41720_()).toString());
        if (item.m_41613_() > 1) {
            json.addProperty("count", (Number)item.m_41613_());
        }
        if (item.m_41783_() != null) {
            json.addProperty("type", "forge:nbt");
            json.addProperty("nbt", ((JsonElement)NbtOps.f_128958_.convertTo((DynamicOps)JsonOps.INSTANCE, (Tag)item.m_41783_())).toString());
        }
        return json;
    }

    record Result(ResourceLocation id, Ingredient log, ItemStack plank, ItemStack secondary, ItemStack tertiary) implements FinishedRecipe
    {
        public void m_7917_(JsonObject json) {
            json.add("log", this.log.m_43942_());
            json.add("planks", (JsonElement)SawmillRecipeBuilder.itemToJson(this.plank));
            if (!this.secondary.m_41619_()) {
                json.add("secondary", (JsonElement)SawmillRecipeBuilder.itemToJson(this.secondary));
            }
            if (!this.tertiary.m_41619_()) {
                json.add("tertiary", (JsonElement)SawmillRecipeBuilder.itemToJson(this.tertiary));
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)TreeRegistrator.SAW_MILLLING.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

