/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.registry;

import cy.jdkdigital.productivetrees.ProductiveTrees;
import cy.jdkdigital.productivetrees.common.block.CoconutSproutBlock;
import cy.jdkdigital.productivetrees.common.block.EntitySpawner;
import cy.jdkdigital.productivetrees.common.block.PollenSifter;
import cy.jdkdigital.productivetrees.common.block.PollinatedLeaves;
import cy.jdkdigital.productivetrees.common.block.ProductiveCeilingHangingSignBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveDanglerFruitBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveDirectionalLeavesBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveDrippyFruitBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveDroppyFruitBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveFruitBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveLeavesBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveLogBlock;
import cy.jdkdigital.productivetrees.common.block.ProductivePlankBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveRotatedPillarBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveSaplingBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveStandingSignBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveWallHangingSignBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveWallSignBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveWoodBlock;
import cy.jdkdigital.productivetrees.common.block.Sawmill;
import cy.jdkdigital.productivetrees.common.block.Stripper;
import cy.jdkdigital.productivetrees.common.block.TimeTravellerDisplay;
import cy.jdkdigital.productivetrees.common.block.WoodWorker;
import cy.jdkdigital.productivetrees.common.block.entity.EntitySpawnerBlockEntity;
import cy.jdkdigital.productivetrees.common.block.entity.PollenSifterBlockEntity;
import cy.jdkdigital.productivetrees.common.block.entity.PollinatedLeavesBlockEntity;
import cy.jdkdigital.productivetrees.common.block.entity.ProductiveHangingSignBlockEntity;
import cy.jdkdigital.productivetrees.common.block.entity.ProductiveSignBlockEntity;
import cy.jdkdigital.productivetrees.common.block.entity.SawmillBlockEntity;
import cy.jdkdigital.productivetrees.common.block.entity.StripperBlockEntity;
import cy.jdkdigital.productivetrees.common.block.entity.TimeTravellerDisplayBlockEntity;
import cy.jdkdigital.productivetrees.common.block.entity.WoodWorkerBlockEntity;
import cy.jdkdigital.productivetrees.common.feature.EntityPlacerDecorator;
import cy.jdkdigital.productivetrees.common.feature.FruitLeafPlacerDecorator;
import cy.jdkdigital.productivetrees.common.feature.FruitLeafReplacerDecorator;
import cy.jdkdigital.productivetrees.common.feature.TrunkVineDecorator;
import cy.jdkdigital.productivetrees.common.fluid.MapleSap;
import cy.jdkdigital.productivetrees.common.fluid.type.MapleSapType;
import cy.jdkdigital.productivetrees.common.item.PollenItem;
import cy.jdkdigital.productivetrees.common.item.SieveUpgradeItem;
import cy.jdkdigital.productivetrees.feature.foliageplacers.TaperedFoliagePlacer;
import cy.jdkdigital.productivetrees.feature.trunkplacers.CenteredUpwardsBranchingTrunkPlacer;
import cy.jdkdigital.productivetrees.feature.trunkplacers.UnlimitedStraightTrunkPlacer;
import cy.jdkdigital.productivetrees.integrations.productivebees.CompatHandler;
import cy.jdkdigital.productivetrees.inventory.PollenSifterContainer;
import cy.jdkdigital.productivetrees.inventory.SawmillContainer;
import cy.jdkdigital.productivetrees.inventory.StripperContainer;
import cy.jdkdigital.productivetrees.inventory.WoodWorkerContainer;
import cy.jdkdigital.productivetrees.recipe.LogStrippingRecipe;
import cy.jdkdigital.productivetrees.recipe.SawmillRecipe;
import cy.jdkdigital.productivetrees.recipe.TreeFruitingRecipe;
import cy.jdkdigital.productivetrees.recipe.TreePollinationRecipe;
import cy.jdkdigital.productivetrees.registry.TreeFinder;
import cy.jdkdigital.productivetrees.registry.TreeObject;
import cy.jdkdigital.productivetrees.util.CropConfig;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.grower.AbstractMegaTreeGrower;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class TreeRegistrator {
    public static final RegistryObject<PoiType> ADVANCED_HIVES = ProductiveTrees.POI_TYPES.register("advanced_beehive", () -> {
        HashSet blockStates = new HashSet();
        TreeFinder.trees.forEach((id, treeObject) -> {
            if (ModList.get().isLoaded("productivebees") && treeObject.getStyle().hiveStyle() != null) {
                try {
                    Block hive = (Block)ForgeRegistries.BLOCKS.getValue(treeObject.getId().m_247266_(p -> "advanced_" + p + "_beehive"));
                    blockStates.addAll(hive.m_49965_().m_61056_());
                }
                catch (NullPointerException e) {
                    throw new RuntimeException(treeObject.getId() + " failed hive");
                }
            }
        });
        return new PoiType(blockStates, 1, 1);
    });
    public static final ResourceKey<CreativeModeTab> TAB_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)new ResourceLocation("productivetrees", "productivetrees"));
    public static final RegistryObject<CreativeModeTab> TAB = ProductiveTrees.CREATIVE_MODE_TABS.register("productivetrees", () -> CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("productivetrees", "sawmill")))).m_257941_((Component)Component.m_237115_((String)"itemGroup.productivetrees")).m_257652_());
    public static final RegistryObject<Block> POLLINATED_LEAVES = TreeRegistrator.registerBlock("pollinated_leaves", () -> new PollinatedLeaves(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_)), false);
    public static final RegistryObject<BlockEntityType<PollinatedLeavesBlockEntity>> POLLINATED_LEAVES_BLOCK_ENTITY = ProductiveTrees.BLOCK_ENTITIES.register("pollinated_leaves", () -> BlockEntityType.Builder.m_155273_(PollinatedLeavesBlockEntity::new, (Block[])new Block[]{(Block)POLLINATED_LEAVES.get()}).m_58966_(null));
    public static final RegistryObject<Block> STRIPPER = TreeRegistrator.registerBlock("stripper", () -> new Stripper(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50679_).m_60955_()), true);
    public static final RegistryObject<BlockEntityType<StripperBlockEntity>> STRIPPER_BLOCK_ENTITY = ProductiveTrees.BLOCK_ENTITIES.register("stripper", () -> BlockEntityType.Builder.m_155273_(StripperBlockEntity::new, (Block[])new Block[]{(Block)STRIPPER.get()}).m_58966_(null));
    public static final RegistryObject<Block> SAWMILL = TreeRegistrator.registerBlock("sawmill", () -> new Sawmill(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50679_).m_60955_()), true);
    public static final RegistryObject<BlockEntityType<SawmillBlockEntity>> SAWMILL_BLOCK_ENTITY = ProductiveTrees.BLOCK_ENTITIES.register("sawmill", () -> BlockEntityType.Builder.m_155273_(SawmillBlockEntity::new, (Block[])new Block[]{(Block)SAWMILL.get()}).m_58966_(null));
    public static final RegistryObject<Block> WOOD_WORKER = TreeRegistrator.registerBlock("wood_worker", () -> new WoodWorker(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50679_).m_60955_()), true);
    public static final RegistryObject<BlockEntityType<WoodWorkerBlockEntity>> WOOD_WORKER_BLOCK_ENTITY = ProductiveTrees.BLOCK_ENTITIES.register("wood_worker", () -> BlockEntityType.Builder.m_155273_(WoodWorkerBlockEntity::new, (Block[])new Block[]{(Block)WOOD_WORKER.get()}).m_58966_(null));
    public static final RegistryObject<Block> POLLEN_SIFTER = TreeRegistrator.registerBlock("pollen_sifter", () -> new PollenSifter(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50679_).m_60955_()), true);
    public static final RegistryObject<BlockEntityType<PollenSifterBlockEntity>> POLLEN_SIFTER_BLOCK_ENTITY = ProductiveTrees.BLOCK_ENTITIES.register("pollen_sifter", () -> BlockEntityType.Builder.m_155273_(PollenSifterBlockEntity::new, (Block[])new Block[]{(Block)POLLEN_SIFTER.get()}).m_58966_(null));
    public static final RegistryObject<Block> ENTITY_SPAWNER = ProductiveTrees.BLOCKS.register("entity_spawner", () -> new EntitySpawner(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50016_)));
    public static final RegistryObject<BlockEntityType<EntitySpawnerBlockEntity>> ENTITY_SPAWNER_BLOCK_ENTITY = ProductiveTrees.BLOCK_ENTITIES.register("entity_spawner", () -> BlockEntityType.Builder.m_155273_(EntitySpawnerBlockEntity::new, (Block[])new Block[]{(Block)ENTITY_SPAWNER.get()}).m_58966_(null));
    public static final RegistryObject<Block> TIME_TRAVELLER_DISPLAY = TreeRegistrator.registerBlock("time_traveller_display", () -> new TimeTravellerDisplay(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50010_).m_60955_()), true);
    public static final RegistryObject<BlockEntityType<TimeTravellerDisplayBlockEntity>> TIME_TRAVELLER_DISPLAY_BLOCK_ENTITY = ProductiveTrees.BLOCK_ENTITIES.register("time_traveller_display", () -> BlockEntityType.Builder.m_155273_(TimeTravellerDisplayBlockEntity::new, (Block[])new Block[]{(Block)TIME_TRAVELLER_DISPLAY.get()}).m_58966_(null));
    public static final RegistryObject<MenuType<StripperContainer>> STRIPPER_MENU = ProductiveTrees.CONTAINER_TYPES.register("stripper", () -> IForgeMenuType.create(StripperContainer::new));
    public static final RegistryObject<MenuType<SawmillContainer>> SAWMILL_MENU = ProductiveTrees.CONTAINER_TYPES.register("sawmill", () -> IForgeMenuType.create(SawmillContainer::new));
    public static final RegistryObject<MenuType<WoodWorkerContainer>> WOOD_WORKER_MENU = ProductiveTrees.CONTAINER_TYPES.register("wood_worker", () -> IForgeMenuType.create(WoodWorkerContainer::new));
    public static final RegistryObject<MenuType<PollenSifterContainer>> POLLEN_SIFTER_MENU = ProductiveTrees.CONTAINER_TYPES.register("pollen_sifter", () -> IForgeMenuType.create(PollenSifterContainer::new));
    public static final RegistryObject<FluidType> MAPLE_SAP_TYPE = ProductiveTrees.FLUID_TYPES.register("maple_sap", MapleSapType::new);
    public static final RegistryObject<FlowingFluid> MAPLE_SAP = ProductiveTrees.FLUIDS.register("maple_sap", MapleSap.Source::new);
    public static final RegistryObject<FlowingFluid> MAPLE_SAP_FLOWING = ProductiveTrees.FLUIDS.register("flowing_maple_sap", MapleSap.Flowing::new);
    public static final RegistryObject<Item> MAPLE_SAP_BUCKET = TreeRegistrator.registerItem("maple_sap_bucket", () -> new BucketItem(MAPLE_SAP, new Item.Properties().m_41495_(Items.f_42446_)));
    public static final RegistryObject<Item> UPGRADE_POLLEN_SIEVE = TreeRegistrator.registerItem("upgrade_pollen_sieve", () -> new SieveUpgradeItem(new Item.Properties().m_41487_(1)));
    public static final RegistryObject<Item> POLLEN = TreeRegistrator.registerItem("pollen", () -> new PollenItem(new Item.Properties()));
    public static final RegistryObject<Item> SAWDUST = TreeRegistrator.registerItem("sawdust");
    public static final RegistryObject<Item> FUSTIC = TreeRegistrator.registerItem("fustic");
    public static final RegistryObject<Item> HAEMATOXYLIN = TreeRegistrator.registerItem("haematoxylin");
    public static final RegistryObject<Item> DRACAENA_SAP = TreeRegistrator.registerItem("dracaena_sap");
    public static final RegistryObject<Item> RUBBER = TreeRegistrator.registerItem("rubber");
    public static final RegistryObject<Item> CURED_RUBBER = TreeRegistrator.registerItem("cured_rubber");
    public static final RegistryObject<Item> MAPLE_SYRUP = TreeRegistrator.registerItem("maple_syrup", () -> new Item(new Item.Properties().m_41489_(Foods.f_38832_).m_41495_(Items.f_42590_)));
    public static final RegistryObject<Item> SANDALWOOD_OIL = TreeRegistrator.registerItem("sandalwood_oil");
    public static final RegistryObject<Item> DATE_PALM_JUICE = TreeRegistrator.registerItem("date_palm_juice", () -> new Item(new Item.Properties().m_41489_(Foods.f_38832_).m_41495_(Items.f_42590_)));
    public static final RegistryObject<RecipeSerializer<?>> TREE_POLLINATION = ProductiveTrees.RECIPE_SERIALIZERS.register("tree_pollination", () -> new TreePollinationRecipe.Serializer<TreePollinationRecipe>(TreePollinationRecipe::new));
    public static final RegistryObject<RecipeType<TreePollinationRecipe>> TREE_POLLINATION_TYPE = ProductiveTrees.RECIPE_TYPES.register("tree_pollination", () -> new RecipeType<TreePollinationRecipe>(){});
    public static final RegistryObject<RecipeSerializer<?>> TREE_FRUITING = ProductiveTrees.RECIPE_SERIALIZERS.register("tree_fruiting", () -> new TreeFruitingRecipe.Serializer<TreeFruitingRecipe>(TreeFruitingRecipe::new));
    public static final RegistryObject<RecipeType<TreeFruitingRecipe>> TREE_FRUITING_TYPE = ProductiveTrees.RECIPE_TYPES.register("tree_fruiting", () -> new RecipeType<TreeFruitingRecipe>(){});
    public static final RegistryObject<RecipeSerializer<?>> LOG_STRIPPING = ProductiveTrees.RECIPE_SERIALIZERS.register("log_stripping", () -> new LogStrippingRecipe.Serializer<LogStrippingRecipe>(LogStrippingRecipe::new));
    public static final RegistryObject<RecipeType<LogStrippingRecipe>> LOG_STRIPPING_TYPE = ProductiveTrees.RECIPE_TYPES.register("log_stripping", () -> new RecipeType<LogStrippingRecipe>(){});
    public static final RegistryObject<RecipeSerializer<?>> SAW_MILLLING = ProductiveTrees.RECIPE_SERIALIZERS.register("sawmill", () -> new SawmillRecipe.Serializer<SawmillRecipe>(SawmillRecipe::new));
    public static final RegistryObject<RecipeType<SawmillRecipe>> SAW_MILLLING_TYPE = ProductiveTrees.RECIPE_TYPES.register("sawmill", () -> new RecipeType<SawmillRecipe>(){});
    public static final ResourceKey<ConfiguredFeature<?, ?>> NULL_FEATURE = FeatureUtils.m_255087_((String)"productivetrees:null");
    public static final RegistryObject<TrunkPlacerType<CenteredUpwardsBranchingTrunkPlacer>> CENTERED_UPWARDS_TRUNK_PLACER = ProductiveTrees.TRUNK_PLACERS.register("centered_upwards_branching_trunk_placer", () -> new TrunkPlacerType(CenteredUpwardsBranchingTrunkPlacer.CODEC));
    public static final RegistryObject<TrunkPlacerType<UnlimitedStraightTrunkPlacer>> UNLIMITED_STRAIGHT_TRUNK_PLACER = ProductiveTrees.TRUNK_PLACERS.register("unlimited_straight_trunk_placer", () -> new TrunkPlacerType(UnlimitedStraightTrunkPlacer.CODEC));
    public static final RegistryObject<FoliagePlacerType<TaperedFoliagePlacer>> TAPERED_FOLIAGE_PLACER = ProductiveTrees.FOLIAGE_PLACERS.register("tapered_foliage_placer", () -> new FoliagePlacerType(TaperedFoliagePlacer.CODEC));
    public static final RegistryObject<TreeDecoratorType<FruitLeafReplacerDecorator>> FRUIT_LEAF_REPLACER = ProductiveTrees.TREE_DECORATORS.register("fruit_leaf_replacer", () -> new TreeDecoratorType(FruitLeafReplacerDecorator.CODEC));
    public static final RegistryObject<TreeDecoratorType<FruitLeafPlacerDecorator>> FRUIT_LEAF_PLACER = ProductiveTrees.TREE_DECORATORS.register("fruit_leaf_placer", () -> new TreeDecoratorType(FruitLeafPlacerDecorator.CODEC));
    public static final RegistryObject<TreeDecoratorType<EntityPlacerDecorator>> ENTITY_PLACER = ProductiveTrees.TREE_DECORATORS.register("entity_placer", () -> new TreeDecoratorType(EntityPlacerDecorator.CODEC));
    public static final RegistryObject<TreeDecoratorType<TrunkVineDecorator>> TRUNK_VINE = ProductiveTrees.TREE_DECORATORS.register("trunk_vine", () -> new TreeDecoratorType(TrunkVineDecorator.CODEC));
    static final FoodProperties BERRY_FOOD = new FoodProperties.Builder().m_38765_().m_38766_().m_38760_(1).m_38758_(0.1f).m_38767_();
    static final FoodProperties SMALL_FRUIT_FOOD = new FoodProperties.Builder().m_38760_(4).m_38758_(0.3f).m_38767_();
    static final FoodProperties FRUIT_FOOD = new FoodProperties.Builder().m_38760_(4).m_38758_(0.3f).m_38767_();
    static final FoodProperties BIG_FRUIT_FOOD = new FoodProperties.Builder().m_38760_(5).m_38758_(0.3f).m_38767_();
    static final FoodProperties CITRUS_FOOD = new FoodProperties.Builder().m_38760_(2).m_38758_(0.0f).m_38767_();
    static final FoodProperties BIG_CITRUS_FOOD = new FoodProperties.Builder().m_38760_(3).m_38758_(0.0f).m_38767_();
    static final FoodProperties NUT_FOOD = new FoodProperties.Builder().m_38765_().m_38766_().m_38760_(1).m_38758_(0.1f).m_38767_();
    static final FoodProperties ROASTED_NUT_FOOD = new FoodProperties.Builder().m_38765_().m_38766_().m_38760_(1).m_38758_(0.3f).m_38767_();
    public static List<CropConfig> BERRIES = new ArrayList<CropConfig>(){
        {
            this.add(new CropConfig("elderberry", BERRY_FOOD));
            this.add(new CropConfig("juniper_berry", BERRY_FOOD));
            this.add(new CropConfig("sloe", BERRY_FOOD));
            this.add(new CropConfig("haw", BERRY_FOOD));
            this.add(new CropConfig("asai_berry", BERRY_FOOD));
            this.add(new CropConfig("rowan", BERRY_FOOD));
        }
    };
    public static List<CropConfig> FRUITS = new ArrayList<CropConfig>(){
        {
            this.add(new CropConfig("apricot", SMALL_FRUIT_FOOD));
            this.add(new CropConfig("black_cherry", SMALL_FRUIT_FOOD));
            this.add(new CropConfig("cherry_plum", SMALL_FRUIT_FOOD));
            this.add(new CropConfig("date", SMALL_FRUIT_FOOD));
            this.add(new CropConfig("fig", SMALL_FRUIT_FOOD));
            this.add(new CropConfig("kumquat", SMALL_FRUIT_FOOD));
            this.add(new CropConfig("olive", SMALL_FRUIT_FOOD));
            this.add(new CropConfig("osange_orange", SMALL_FRUIT_FOOD));
            this.add(new CropConfig("plum", SMALL_FRUIT_FOOD));
            this.add(new CropConfig("sour_cherry", SMALL_FRUIT_FOOD));
            this.add(new CropConfig("sparkling_cherry", SMALL_FRUIT_FOOD));
            this.add(new CropConfig("wild_cherry", SMALL_FRUIT_FOOD));
            this.add(new CropConfig("golden_delicious_apple", FRUIT_FOOD));
            this.add(new CropConfig("granny_smith_apple", FRUIT_FOOD));
            this.add(new CropConfig("beliy_naliv_apple", FRUIT_FOOD));
            this.add(new CropConfig("avocado", FRUIT_FOOD));
            this.add(new CropConfig("banana", FRUIT_FOOD));
            this.add(new CropConfig("red_banana", FRUIT_FOOD));
            this.add(new CropConfig("sweet_crabapple", FRUIT_FOOD));
            this.add(new CropConfig("prairie_crabapple", FRUIT_FOOD));
            this.add(new CropConfig("flowering_crabapple", FRUIT_FOOD));
            this.add(new CropConfig("grapefruit", FRUIT_FOOD));
            this.add(new CropConfig("nectarine", FRUIT_FOOD));
            this.add(new CropConfig("peach", FRUIT_FOOD));
            this.add(new CropConfig("pear", FRUIT_FOOD));
            this.add(new CropConfig("persimmon", FRUIT_FOOD));
            this.add(new CropConfig("pomelo", FRUIT_FOOD));
            this.add(new CropConfig("pomegranate", FRUIT_FOOD));
            this.add(new CropConfig("sand_pear", FRUIT_FOOD));
            this.add(new CropConfig("satsuma", FRUIT_FOOD));
            this.add(new CropConfig("snake_fruit", FRUIT_FOOD));
            this.add(new CropConfig("star_fruit", FRUIT_FOOD));
            this.add(new CropConfig("tangerine", FRUIT_FOOD));
            this.add(new CropConfig("sweetsop", FRUIT_FOOD));
            this.add(new CropConfig("coconut", BIG_FRUIT_FOOD));
            this.add(new CropConfig("mango", BIG_FRUIT_FOOD));
            this.add(new CropConfig("plantain", BIG_FRUIT_FOOD));
            this.add(new CropConfig("papaya", BIG_FRUIT_FOOD));
            this.add(new CropConfig("breadfruit", BIG_FRUIT_FOOD));
            this.add(new CropConfig("copoazu", BIG_FRUIT_FOOD));
            this.add(new CropConfig("cempedak", BIG_FRUIT_FOOD));
            this.add(new CropConfig("jackfruit", BIG_FRUIT_FOOD));
            this.add(new CropConfig("hala_fruit", BIG_FRUIT_FOOD));
            this.add(new CropConfig("soursop", BIG_FRUIT_FOOD));
            this.add(new CropConfig("baobab_fruit", BIG_FRUIT_FOOD));
            this.add(new CropConfig("lime", CITRUS_FOOD));
            this.add(new CropConfig("key_lime", CITRUS_FOOD));
            this.add(new CropConfig("finger_lime", CITRUS_FOOD));
            this.add(new CropConfig("citron", CITRUS_FOOD));
            this.add(new CropConfig("lemon", CITRUS_FOOD));
            this.add(new CropConfig("orange", BIG_CITRUS_FOOD));
            this.add(new CropConfig("mandarin", BIG_CITRUS_FOOD));
            this.add(new CropConfig("buddhas_hand", BIG_CITRUS_FOOD));
        }
    };
    public static List<CropConfig> NUTS = new ArrayList<CropConfig>(){
        {
            this.add(new CropConfig("almond", NUT_FOOD));
            this.add(new CropConfig("beechnut", NUT_FOOD));
            this.add(new CropConfig("brazil_nut", NUT_FOOD));
            this.add(new CropConfig("butternut", NUT_FOOD));
            this.add(new CropConfig("candlenut", NUT_FOOD));
            this.add(new CropConfig("cashew", NUT_FOOD));
            this.add(new CropConfig("chestnut", NUT_FOOD));
            this.add(new CropConfig("ginkgo_nut", NUT_FOOD));
            this.add(new CropConfig("hazelnut", NUT_FOOD));
            this.add(new CropConfig("pecan", NUT_FOOD));
            this.add(new CropConfig("pistachio", NUT_FOOD));
            this.add(new CropConfig("walnut", NUT_FOOD));
        }
    };
    public static List<CropConfig> ROASTED_NUTS = new ArrayList<CropConfig>(){
        {
            this.add(new CropConfig("roasted_almond", ROASTED_NUT_FOOD));
            this.add(new CropConfig("roasted_beechnut", ROASTED_NUT_FOOD));
            this.add(new CropConfig("roasted_brazil_nut", ROASTED_NUT_FOOD));
            this.add(new CropConfig("roasted_butternut", ROASTED_NUT_FOOD));
            this.add(new CropConfig("roasted_candlenut", ROASTED_NUT_FOOD));
            this.add(new CropConfig("roasted_cashew", ROASTED_NUT_FOOD));
            this.add(new CropConfig("roasted_chestnut", ROASTED_NUT_FOOD));
            this.add(new CropConfig("roasted_ginkgo_nut", ROASTED_NUT_FOOD));
            this.add(new CropConfig("roasted_hazelnut", ROASTED_NUT_FOOD));
            this.add(new CropConfig("roasted_pecan", ROASTED_NUT_FOOD));
            this.add(new CropConfig("roasted_pistachio", ROASTED_NUT_FOOD));
            this.add(new CropConfig("roasted_walnut", ROASTED_NUT_FOOD));
            this.add(new CropConfig("roasted_coffee_bean", null));
        }
    };
    public static List<ResourceLocation> CRATED_CROPS = new ArrayList<ResourceLocation>();
    public static final RegistryObject<Item> COFFEE_BEAN = TreeRegistrator.registerItem("coffee_bean");
    public static final RegistryObject<Item> CAROB = TreeRegistrator.registerItem("carob");
    public static final RegistryObject<Item> ALLSPICE = TreeRegistrator.registerItem("allspice");
    public static final RegistryObject<Item> CLOVE = TreeRegistrator.registerItem("clove");
    public static final RegistryObject<Item> CINNAMON = TreeRegistrator.registerItem("cinnamon");
    public static final RegistryObject<Item> NUTMEG = TreeRegistrator.registerItem("nutmeg");
    public static final RegistryObject<Item> STAR_ANISE = TreeRegistrator.registerItem("star_anise");
    public static final RegistryObject<Item> CORK = TreeRegistrator.registerItem("cork");
    public static final RegistryObject<Item> PLANET_PEACH = TreeRegistrator.registerItem("planet_peach", Foods.f_38831_);
    public static final RegistryObject<Block> AMBER_PUDDLE = TreeRegistrator.registerBlock("brown_amber_puddle", () -> new SnowLayerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50125_).m_60955_().m_60918_(SoundType.f_56750_)), false);
    public static final RegistryObject<Block> COCONUT_SPROUT = TreeRegistrator.registerBlock("coconut_sprout", () -> new CoconutSproutBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_).m_222979_(BlockBehaviour.OffsetType.XZ).m_60988_()), true);
    private static List<RegistryObject<Block>> SIGNS = new ArrayList<RegistryObject<Block>>();
    private static List<RegistryObject<Block>> HANGING_SIGNS = new ArrayList<RegistryObject<Block>>();
    public static Supplier<BlockEntityType<ProductiveSignBlockEntity>> SIGN_BE;
    public static Supplier<BlockEntityType<ProductiveHangingSignBlockEntity>> HANGING_SIGN_BE;

    public static void init() {
        BERRIES.forEach(cropConfig -> {
            TreeRegistrator.registerItem(cropConfig.name(), cropConfig.food());
            CRATED_CROPS.add(new ResourceLocation("productivetrees", cropConfig.name() + "_crate"));
        });
        FRUITS.forEach(cropConfig -> {
            TreeRegistrator.registerItem(cropConfig.name(), cropConfig.food());
            CRATED_CROPS.add(new ResourceLocation("productivetrees", cropConfig.name() + "_crate"));
        });
        NUTS.forEach(cropConfig -> {
            TreeRegistrator.registerItem(cropConfig.name(), cropConfig.food());
            CRATED_CROPS.add(new ResourceLocation("productivetrees", cropConfig.name() + "_crate"));
        });
        ROASTED_NUTS.forEach(cropConfig -> {
            TreeRegistrator.registerItem(cropConfig.name(), cropConfig.food());
            CRATED_CROPS.add(new ResourceLocation("productivetrees", cropConfig.name() + "_crate"));
        });
        CRATED_CROPS.add(new ResourceLocation("productivetrees", "coffee_bean_crate"));
        CRATED_CROPS.add(new ResourceLocation("productivetrees", "clove_crate"));
        CRATED_CROPS.add(new ResourceLocation("productivetrees", "cinnamon_crate"));
        CRATED_CROPS.add(new ResourceLocation("productivetrees", "nutmeg_crate"));
        CRATED_CROPS.add(new ResourceLocation("productivetrees", "star_anise_crate"));
        CRATED_CROPS.add(new ResourceLocation("productivetrees", "red_delicious_apple_crate"));
        CRATED_CROPS.forEach(cropName -> TreeRegistrator.registerBlock(cropName.m_135815_(), () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50618_).m_60918_(SoundType.f_56756_)), true));
    }

    public static void registerTree(final TreeObject treeObject) {
        String name = treeObject.getId().m_135815_();
        boolean noOcclusion = TreeUtil.isTranslucentTree(name);
        ToIntFunction<BlockState> lightLevel = state -> treeObject.getDecoration().lightLevel();
        Object grower = treeObject.getMegaFeature().equals(NULL_FEATURE) ? new AbstractTreeGrower(){

            protected ResourceKey<ConfiguredFeature<?, ?>> m_213888_(RandomSource rand, boolean hasFlowers) {
                return treeObject.getFeature();
            }
        } : new AbstractMegaTreeGrower(){

            protected ResourceKey<ConfiguredFeature<?, ?>> m_213888_(RandomSource rand, boolean hasFlowers) {
                return treeObject.getFeature();
            }

            @Nullable
            protected ResourceKey<ConfiguredFeature<?, ?>> m_213566_(RandomSource rand) {
                return treeObject.getMegaFeature();
            }
        };
        RegistryObject<Block> sapling = TreeRegistrator.registerBlock(name + "_sapling", () -> TreeRegistrator.lambda$registerTree$52((AbstractTreeGrower)grower, treeObject));
        RegistryObject<Block> pottedSapling = TreeRegistrator.registerBlock(name + "_potted_sapling", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, (Supplier)sapling, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50277_)), false);
        ((FlowerPotBlock)Blocks.f_50276_).addPlant(new ResourceLocation("productivetrees", name + "_sapling"), pottedSapling);
        TreeRegistrator.registerBlock(name + "_leaves", () -> new ProductiveLeavesBlock(TreeRegistrator.getProperties(Blocks.f_50050_, noOcclusion, lightLevel), treeObject));
        if (treeObject.hasFruit()) {
            if (name.equals("coconut")) {
                TreeRegistrator.registerBlock(name + "_fruit", () -> new ProductiveDroppyFruitBlock(TreeRegistrator.getProperties(Blocks.f_50050_, noOcclusion, null), treeObject, (Supplier<Block>)COCONUT_SPROUT), false);
            } else if (name.equals("brown_amber")) {
                TreeRegistrator.registerBlock(name + "_fruit", () -> new ProductiveDrippyFruitBlock(TreeRegistrator.getProperties(Blocks.f_50050_, noOcclusion, null), treeObject, (Supplier<Block>)AMBER_PUDDLE), false);
            } else if (!treeObject.getFruit().style().equals("default")) {
                TreeRegistrator.registerBlock(name + "_fruit", () -> new ProductiveDanglerFruitBlock(TreeRegistrator.getProperties(Blocks.f_50050_, noOcclusion, null).m_222979_(BlockBehaviour.OffsetType.XZ).m_60988_(), treeObject), false);
            } else {
                TreeRegistrator.registerBlock(name + "_fruit", () -> new ProductiveFruitBlock(TreeRegistrator.getProperties(Blocks.f_50050_, noOcclusion, null), treeObject), false);
            }
        }
        TreeRegistrator.registerBlock(name + "_log", () -> new ProductiveLogBlock(TreeRegistrator.getProperties(treeObject.isFireProof() ? Blocks.f_50686_ : Blocks.f_49999_, noOcclusion, lightLevel)));
        TreeRegistrator.registerBlock(name + "_stripped_log", () -> new ProductiveRotatedPillarBlock(TreeRegistrator.getProperties(treeObject.isFireProof() ? Blocks.f_50687_ : Blocks.f_50010_, noOcclusion, lightLevel)));
        TreeRegistrator.registerBlock(name + "_wood", () -> new ProductiveWoodBlock(TreeRegistrator.getProperties(treeObject.isFireProof() ? Blocks.f_50686_ : Blocks.f_50011_, noOcclusion, lightLevel)));
        TreeRegistrator.registerBlock(name + "_stripped_wood", () -> new ProductiveRotatedPillarBlock(TreeRegistrator.getProperties(treeObject.isFireProof() ? Blocks.f_50687_ : Blocks.f_50044_, noOcclusion, lightLevel)));
        RegistryObject<Block> plank = TreeRegistrator.registerBlock(name + "_planks", () -> new ProductivePlankBlock(TreeRegistrator.getProperties(treeObject.isFireProof() ? Blocks.f_50656_ : Blocks.f_50705_, noOcclusion, lightLevel), name));
        TreeRegistrator.registerBlock(name + "_stairs", () -> new StairBlock(() -> ((Block)plank.get()).m_49966_(), TreeRegistrator.getProperties(Blocks.f_50086_, noOcclusion, lightLevel)));
        TreeRegistrator.registerBlock(name + "_slab", () -> new SlabBlock(TreeRegistrator.getProperties(Blocks.f_50398_, noOcclusion, lightLevel)));
        TreeRegistrator.registerBlock(name + "_fence", () -> new FenceBlock(TreeRegistrator.getProperties(Blocks.f_50132_, noOcclusion, lightLevel)));
        TreeRegistrator.registerBlock(name + "_fence_gate", () -> new FenceGateBlock(TreeRegistrator.getProperties(Blocks.f_50192_, noOcclusion, lightLevel), WoodType.f_61830_));
        TreeRegistrator.registerBlock(name + "_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, TreeRegistrator.getProperties(Blocks.f_50167_, noOcclusion, lightLevel), BlockSetType.f_271198_));
        TreeRegistrator.registerBlock(name + "_button", () -> new ButtonBlock(TreeRegistrator.getProperties(Blocks.f_50251_, noOcclusion, lightLevel), BlockSetType.f_271198_, 30, true));
        TreeRegistrator.registerBlock(name + "_door", () -> new DoorBlock(TreeRegistrator.getProperties(Blocks.f_50154_, noOcclusion, lightLevel), BlockSetType.f_271198_));
        TreeRegistrator.registerBlock(name + "_trapdoor", () -> new TrapDoorBlock(TreeRegistrator.getProperties(Blocks.f_50220_, noOcclusion, lightLevel), BlockSetType.f_271198_));
        TreeRegistrator.registerBlock(name + "_bookshelf", () -> new Block(TreeRegistrator.getProperties(Blocks.f_50078_, noOcclusion, lightLevel)));
        WoodType woodType = WoodType.m_61844_((WoodType)new WoodType("productivetrees:" + name, BlockSetType.m_272115_((BlockSetType)new BlockSetType("productivetrees:" + name))));
        RegistryObject<Block> signBlock = TreeRegistrator.registerBlock(name + "_sign", () -> new ProductiveStandingSignBlock(TreeRegistrator.getProperties(Blocks.f_50095_, noOcclusion, lightLevel), woodType), false);
        RegistryObject<Block> wallSignBlock = TreeRegistrator.registerBlock(name + "_wall_sign", () -> new ProductiveWallSignBlock(TreeRegistrator.getProperties(Blocks.f_50158_, noOcclusion, lightLevel), woodType), false);
        RegistryObject<Block> hangingSignBlock = TreeRegistrator.registerBlock(name + "_hanging_sign", () -> new ProductiveCeilingHangingSignBlock(TreeRegistrator.getProperties(Blocks.f_244319_, noOcclusion, lightLevel), woodType), false);
        RegistryObject<Block> wallHangingSignBlock = TreeRegistrator.registerBlock(name + "_wall_hanging_sign", () -> new ProductiveWallHangingSignBlock(TreeRegistrator.getProperties(Blocks.f_244093_, noOcclusion, lightLevel), woodType), false);
        TreeRegistrator.registerItem(name + "_sign", () -> new SignItem(new Item.Properties(), (Block)signBlock.get(), (Block)wallSignBlock.get()));
        TreeRegistrator.registerItem(name + "_hanging_sign", () -> new SignItem(new Item.Properties(), (Block)hangingSignBlock.get(), (Block)wallHangingSignBlock.get()));
        SIGNS.add(signBlock);
        SIGNS.add(wallSignBlock);
        HANGING_SIGNS.add(hangingSignBlock);
        HANGING_SIGNS.add(wallHangingSignBlock);
        if (treeObject.getStyle().hiveStyle() != null && ModList.get().isLoaded("productivebees")) {
            CompatHandler.createHive(name, treeObject, lightLevel);
        }
        if (name.equals("monkey_puzzle")) {
            TreeRegistrator.registerBlock("monkey_puzzle_small_leaves", () -> new ProductiveDirectionalLeavesBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_), treeObject));
            TreeRegistrator.registerBlock("monkey_puzzle_medium_leaves", () -> new ProductiveDirectionalLeavesBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_), treeObject));
        }
    }

    public static void registerSignBlockEntities() {
        SIGN_BE = TreeRegistrator.registerBlockEntity("productivetrees_sign", () -> TreeRegistrator.createBlockEntityType(ProductiveSignBlockEntity::new, SIGNS.stream().map(RegistryObject::get).toList().toArray(new Block[0])));
        HANGING_SIGN_BE = TreeRegistrator.registerBlockEntity("productivetrees_hanging_sign", () -> TreeRegistrator.createBlockEntityType(ProductiveHangingSignBlockEntity::new, HANGING_SIGNS.stream().map(RegistryObject::get).toList().toArray(new Block[0])));
        if (ModList.get().isLoaded("productivebees")) {
            CompatHandler.registerBlockEntities();
        }
    }

    public static RegistryObject<Item> registerItem(String name) {
        return TreeRegistrator.registerItem(name, () -> new Item(new Item.Properties()));
    }

    public static RegistryObject<Item> registerItem(String name, FoodProperties food) {
        return TreeRegistrator.registerItem(name, () -> new Item(new Item.Properties().m_41489_(food)));
    }

    public static RegistryObject<Item> registerItem(String name, Supplier<Item> supplier) {
        return ProductiveTrees.ITEMS.register(name, supplier);
    }

    public static RegistryObject<Block> registerBlock(String name, Supplier<Block> supplier, boolean hasItem) {
        RegistryObject block = ProductiveTrees.BLOCKS.register(name, supplier);
        if (hasItem) {
            TreeRegistrator.registerItem(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        }
        return block;
    }

    private static RegistryObject<Block> registerBlock(String name, Supplier<Block> blockSupplier) {
        return TreeRegistrator.registerBlock(name, blockSupplier, true);
    }

    public static <E extends BlockEntity, T extends BlockEntityType<E>> Supplier<T> registerBlockEntity(String id, Supplier<T> supplier) {
        return ProductiveTrees.BLOCK_ENTITIES.register(id, supplier);
    }

    public static <E extends BlockEntity> BlockEntityType<E> createBlockEntityType(BlockEntityType.BlockEntitySupplier<E> factory, Block ... blocks) {
        return BlockEntityType.Builder.m_155273_(factory, (Block[])blocks).m_58966_(null);
    }

    private static BlockBehaviour.Properties getProperties(Block copyFrom, boolean noOcclusion, @Nullable ToIntFunction<BlockState> lightLevel) {
        BlockBehaviour.Properties behavior = BlockBehaviour.Properties.m_60926_((BlockBehaviour)copyFrom);
        if (lightLevel != null) {
            behavior = behavior.m_60953_(lightLevel);
        }
        if (noOcclusion) {
            behavior = behavior.m_60955_();
        }
        return behavior;
    }

    private static /* synthetic */ Block lambda$registerTree$52(AbstractTreeGrower grower, TreeObject treeObject) {
        return new ProductiveSaplingBlock(grower, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50746_), treeObject);
    }
}

