/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.common.item.food;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.brnbrd.delightful.Util;
import net.brnbrd.delightful.common.item.food.DConsumableItem;
import net.brnbrd.delightful.common.item.food.Nutrition;
import net.brnbrd.delightful.data.tags.DelightfulItemTags;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.registry.ModParticleTypes;
import vectorwing.farmersdelight.common.utility.MathUtils;

public class RockCandyItem
extends DConsumableItem {
    private static final List<MobEffectInstance> FED_EFFECTS = ImmutableList.of((Object)new MobEffectInstance(MobEffects.f_19613_, 200, 0));

    public RockCandyItem(Item.Properties properties) {
        super(properties, true, false);
    }

    @Override
    @Nullable
    public TagKey<Item> getDependencyTag() {
        return DelightfulItemTags.GEMS_ROSE_QUARTZ;
    }

    public static List<MobEffectInstance> getFeedEffects() {
        ArrayList ALL_EFFECTS = Lists.newArrayList(Util.getFoodEffects(Nutrition.ROCK_CANDY));
        ALL_EFFECTS.addAll(FED_EFFECTS);
        return ALL_EFFECTS;
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity target, @NotNull InteractionHand hand) {
        Level level = player.m_9236_();
        if (level instanceof ServerLevel) {
            TamableAnimal tame;
            ServerLevel server = (ServerLevel)level;
            if (target.m_6084_() && target.m_5801_() && target instanceof TamableAnimal && (tame = (TamableAnimal)target).m_21824_()) {
                Util.addEffects(target, RockCandyItem.getFeedEffects());
                server.m_5594_(null, target.m_20183_(), SoundEvents.f_11912_, SoundSource.PLAYERS, 0.8f, 0.8f);
                for (int i = 0; i < 4; ++i) {
                    server.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.STAR.get()), target.m_20208_(0.55), target.m_20187_(), target.m_20262_(0.55), 1, MathUtils.RAND.nextGaussian() * 0.02, MathUtils.RAND.nextGaussian() * 0.02, MathUtils.RAND.nextGaussian() * 0.02, 0.0);
                }
                player.m_36335_().m_41524_((Item)this, 40);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42398_));
                }
            }
        }
        return InteractionResult.m_19078_((boolean)player.m_9236_().m_5776_());
    }

    @Override
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> comps, @NotNull TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, comps, isAdvanced);
        if (this.enabled()) {
            comps.add((Component)Component.m_237119_());
            comps.add((Component)Util.delightfulTooltip("rose_rock_candy.when_feeding").m_130940_(ChatFormatting.GRAY));
            for (MobEffectInstance effectInstance : RockCandyItem.getFeedEffects()) {
                MutableComponent effectDescription = Component.m_237113_((String)" ");
                effectDescription.m_7220_((Component)Component.m_237115_((String)effectInstance.m_19576_()));
                MobEffect effect = effectInstance.m_19544_();
                if (effectInstance.m_19564_() > 0) {
                    effectDescription.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)("potion.potency." + effectInstance.m_19564_())));
                }
                if (effectInstance.m_19557_() > 20) {
                    effectDescription.m_130946_(" (").m_7220_(MobEffectUtil.m_267641_((MobEffectInstance)effectInstance, (float)1.0f)).m_130946_(")");
                }
                comps.add((Component)effectDescription.m_130940_(effect.m_19483_().m_19497_()));
            }
        }
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 48;
    }

    public boolean m_6777_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player) {
        return !player.m_7500_();
    }
}

