/*
 * Decompiled with CFR 0.152.
 */
package elocindev.necronomicon.util;

import java.awt.Color;

public class ColorUtils {
    public static int interpolate(int color1, int color2, double ratio) {
        int r = (int)((double)ColorUtils.getRed(color1) * (1.0 - ratio) + (double)ColorUtils.getRed(color2) * ratio);
        int g = (int)((double)ColorUtils.getGreen(color1) * (1.0 - ratio) + (double)ColorUtils.getGreen(color2) * ratio);
        int b = (int)((double)ColorUtils.getBlue(color1) * (1.0 - ratio) + (double)ColorUtils.getBlue(color2) * ratio);
        return r << 16 | g << 8 | b;
    }

    public static int interpolateAnimation(int color1, int color2, double ratio, double animationFactor) {
        int r = (int)((double)ColorUtils.getRed(color1) * (1.0 - ratio) + (double)ColorUtils.getRed(color2) * ratio);
        int g = (int)((double)ColorUtils.getGreen(color1) * (1.0 - ratio) + (double)ColorUtils.getGreen(color2) * ratio);
        int b = (int)((double)ColorUtils.getBlue(color1) * (1.0 - ratio) + (double)ColorUtils.getBlue(color2) * ratio);
        r = (int)((double)r + (double)(255 - r) * animationFactor);
        g = (int)((double)g + (double)(255 - g) * animationFactor);
        b = (int)((double)b + (double)(255 - b) * animationFactor);
        return r << 16 | g << 8 | b;
    }

    public static int getRed(int color) {
        return color >> 16 & 0xFF;
    }

    public static int getGreen(int color) {
        return color >> 8 & 0xFF;
    }

    public static int getBlue(int color) {
        return color & 0xFF;
    }

    private static double bounceBack(double input, double range) {
        double doubleRange = range * 2.0;
        double position = (input = Math.abs(input)) % doubleRange;
        return position >= range ? doubleRange - position : position;
    }

    public static Color gradientSlide(float progression, Color start, Color end) {
        progression = (float)ColorUtils.bounceBack(progression, 1.0);
        int red = (int)((float)start.getRed() + progression * (float)(end.getRed() - start.getRed()));
        int green = (int)((float)start.getGreen() + progression * (float)(end.getGreen() - start.getGreen()));
        int blue = (int)((float)start.getBlue() + progression * (float)(end.getBlue() - start.getBlue()));
        return new Color(red, green, blue);
    }
}

