/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost;

import gollorum.signpost.Signpost;
import gollorum.signpost.utils.serialization.CompoundSerializable;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class PlayerHandle {
    public static final PlayerHandle Invalid = new PlayerHandle((Entity)((LivingEntity)null));
    public final UUID id;
    public static final CompoundSerializable<PlayerHandle> Serializer = new SerializerImpl();

    public PlayerHandle(@Nonnull UUID id) {
        this.id = id;
    }

    public PlayerHandle(@Nullable Entity player) {
        this.id = player == null ? Util.f_137441_ : player.m_20148_();
    }

    public static PlayerHandle from(@Nullable Entity player) {
        return new PlayerHandle(player);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayerHandle that = (PlayerHandle)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public ServerPlayer asEntity() {
        return Signpost.getServerInstance().m_6846_().m_11259_(this.id);
    }

    public static final class SerializerImpl
    implements CompoundSerializable<PlayerHandle> {
        @Override
        public CompoundTag write(PlayerHandle playerHandle, CompoundTag compound) {
            compound.m_128362_("Id", playerHandle.id);
            return compound;
        }

        @Override
        public boolean isContainedIn(CompoundTag compound) {
            return compound.m_128441_("Id");
        }

        @Override
        public PlayerHandle read(CompoundTag compound) {
            return new PlayerHandle(compound.m_128342_("Id"));
        }

        @Override
        public Class<PlayerHandle> getTargetClass() {
            return PlayerHandle.class;
        }

        @Override
        public void write(PlayerHandle playerHandle, FriendlyByteBuf buffer) {
            buffer.m_130077_(playerHandle.id);
        }

        @Override
        public PlayerHandle read(FriendlyByteBuf buffer) {
            return new PlayerHandle(buffer.m_130259_());
        }
    }
}

