/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.config;

import com.google.common.collect.Lists;
import gollorum.signpost.minecraft.block.ModelWaystone;
import gollorum.signpost.minecraft.config.Config;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeConfigSpec;

public class WorldGenConfig {
    private final ForgeConfigSpec.BooleanValue isVillageGenerationEnabled;
    private final ForgeConfigSpec.BooleanValue villagesOnlyTargetVillages;
    private final ForgeConfigSpec.IntValue maxSignpostsPerVillage;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> allowedVillageWaystones;
    private final ForgeConfigSpec.BooleanValue debugMode;
    private final Naming naming;
    @Nullable
    private final ForgeConfigSpec.BooleanValue overrideDefaults;
    private final boolean isServer;

    public boolean isVillageGenerationEnabled() {
        return (Boolean)this.getFinalValue(d -> d.isVillageGenerationEnabled).get();
    }

    public boolean villagesOnlyTargetVillages() {
        return (Boolean)this.getFinalValue(d -> d.villagesOnlyTargetVillages).get();
    }

    public int maxSignpostsPerVillage() {
        return (Integer)this.getFinalValue(d -> d.maxSignpostsPerVillage).get();
    }

    public List<? extends String> allowedVillageWaystones() {
        return (List)this.getFinalValue(d -> d.allowedVillageWaystones).get();
    }

    public boolean debugMode() {
        return (Boolean)this.getFinalValue(d -> d.debugMode).get();
    }

    public Naming naming() {
        return this.getFinalValue(d -> d.naming);
    }

    private <T> Supplier<T> defaults(T defaultVal, Function<WorldGenConfig, ForgeConfigSpec.ConfigValue<T>> factory) {
        return this.isServer ? () -> ((ForgeConfigSpec.ConfigValue)factory.apply(Config.Common.worldGenDefaults)).get() : () -> defaultVal;
    }

    private <T> T getFinalValue(Function<WorldGenConfig, T> factory) {
        return factory.apply(this.isServer && this.overrideDefaults != null && (Boolean)this.overrideDefaults.get() != false ? this : Config.Common.worldGenDefaults);
    }

    WorldGenConfig(ForgeConfigSpec.Builder builder, boolean isServer) {
        this.isServer = isServer;
        this.overrideDefaults = isServer ? builder.comment("Enables this [world_gen] section. If false, the COMMON config values will be used").define("override_defaults", true) : null;
        this.isVillageGenerationEnabled = builder.comment("Enables the generation of signposts and waystones in villages").define("enable_generation", this.defaults(true, d -> d.isVillageGenerationEnabled));
        this.villagesOnlyTargetVillages = builder.comment("Defines whether village signposts can have any waystones as destination or just the ones generated in other villages").define("only_target_other_villages", this.defaults(true, d -> d.villagesOnlyTargetVillages));
        this.maxSignpostsPerVillage = builder.comment("The maximum number of signposts that can spawn in one village. Will be ignored for 'Repurposed Structures' villages, use data packs for that.").defineInRange("max_signposts_per_village", this.defaults(2, d -> d.maxSignpostsPerVillage), 0, Integer.MAX_VALUE);
        this.allowedVillageWaystones = builder.comment(new String[]{"Decide what waystone models are generated in villages", "You can look up the model names at https://www.curseforge.com/minecraft/mc-mods/signpost/pages/waystone-models"}).defineList("allowed_waystone_models", this.defaults(Stream.of(ModelWaystone.simple_0, ModelWaystone.simple_1, ModelWaystone.simple_2, ModelWaystone.detailed_0, ModelWaystone.detailed_1).map(v -> v.name).collect(Collectors.toList()), d -> d.allowedVillageWaystones), n -> n instanceof String && ModelWaystone.variants.contains(new ModelWaystone.Variant((String)n, null, null, 0.0f)));
        this.debugMode = builder.comment("Disables generator blocks/signs being replaced with actual ones and makes them visible. Only enable this if you want to design structures with auto generated waystones / sign posts").define("debug_mode", this.defaults(false, d -> d.debugMode));
        builder.push("naming");
        this.naming = new Naming(builder);
        builder.pop();
    }

    public class Naming {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> villageNamePrefixes;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> villageNameInfixes;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> villageNamePostfixes;
        private static final List<String> genericNamePrefixes = Lists.newArrayList((Object[])new String[]{"ak", "dev", "dol ", "ed", "il", "og", "por", "rov", "tek ", "tar", "tol ", "ves", ""});
        private static final List<String> genericNameInfixes = Lists.newArrayList((Object[])new String[]{"do ", "en", "go", "na", "nah ", "ker", "ol", "ora", "ra", "rem", "ro"});
        private static final List<String> genericNamePostfixes = Lists.newArrayList((Object[])new String[]{"ar", "blo", "bo", "bro", "do", "dra", "er", "ker", "lia", "tek"});
        private static final List<String> germanNamePrefixes = Lists.newArrayList((Object[])new String[]{"", "", "", "", "klein", "gro\u00df", "nieder", "ober", "bad ", "hinter", "neu "});
        private static final List<String> germanNameInfixes = Lists.newArrayList((Object[])new String[]{"", "sege", "m\u00fchl", "s\u00e4ngers", "bach", "stein", "holz", "w\u00fcrz", "h\u00f6ch", "wolfs", "katz", "hunds", "lauter", "hildes", "heides", "ochsen", "ochs", "k\u00f6nigs", "neu", "schafs", "rotten", "ger", "schweins", "frank", "hexen", "m\u00fcnch", "ber", "see", "freuden"});
        private static final List<String> germanNamePostfixes = Lists.newArrayList((Object[])new String[]{"heim", "stadt", "stedt", "berg", "tal", "hausen", "dorf", "ingen", "burg", "furt", "haven", "feld", "felde", "br\u00fcck", "br\u00fccken", "kirch", "horn", "brunn", "loch", "fluch", "en", "beck", "end", "walde", "wind", "garten", "ach", "au", "hofen"});
        private static final List<String> englishNamePrefixes = Lists.newArrayList((Object[])new String[]{"", "", "", "", "", "", "", "", "", "", "", "little ", "grand ", "St ", "new "});
        private static final List<String> englishNameInfixes = Lists.newArrayList((Object[])new String[]{"black", "bow", "long", "cal", "glen", "elk", "taylors", "man", "spring", "cats", "brad", "leakes", "singers", "thorn", "lake", "burn", "chip", "brace", "raven", "middle"});
        private static final List<String> englishNamePostfixes = Lists.newArrayList((Object[])new String[]{"ville", "bridge", "ham", " island", "cester", "water", "town", " creek", " valley", "view", "bury", "burgh", "ington", "field", "dale", " port", "worth", "sey", "don", "pool", "wood", "ley", "ford", " hill", "gate"});

        Naming(ForgeConfigSpec.Builder builder) {
            this.villageNamePrefixes = builder.comment(new String[]{"The names of waystones generated in villages will consist of a prefix, an infix and a postfix, each randomly selected from these lists.", "e.g.: If \"tol \", \"ker\" and \"dra\" are selected, the name will be \"Tol Kerdra\"", "Here are some language-specific examples:", "english:", "village_name_prefixes = [\"" + String.join((CharSequence)"\", \"", englishNamePrefixes) + "\"]", "village_name_infixes = [\"" + String.join((CharSequence)"\", \"", englishNameInfixes) + "\"]", "village_name_postfixes = [\"" + String.join((CharSequence)"\", \"", englishNamePostfixes) + "\"]", "german:", "village_name_prefixes = [\"" + String.join((CharSequence)"\", \"", germanNamePrefixes) + "\"]", "village_name_infixes = [\"" + String.join((CharSequence)"\", \"", germanNameInfixes) + "\"]", "village_name_postfixes = [\"" + String.join((CharSequence)"\", \"", germanNamePostfixes) + "\"]"}).defineList("village_name_prefixes", WorldGenConfig.this.defaults(genericNamePrefixes, d -> d.naming.villageNamePrefixes), x -> x instanceof String);
            this.villageNameInfixes = builder.defineList("village_name_infixes", WorldGenConfig.this.defaults(genericNameInfixes, d -> d.naming.villageNameInfixes), x -> x instanceof String);
            this.villageNamePostfixes = builder.defineList("village_name_postfixes", WorldGenConfig.this.defaults(genericNamePostfixes, d -> d.naming.villageNamePostfixes), x -> x instanceof String);
        }
    }
}

