/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.data;

import gollorum.signpost.minecraft.block.ModelWaystone;
import gollorum.signpost.minecraft.data.BlockModels;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.loaders.ObjModelBuilder;

public class WaystoneModel {
    private final BlockModels blockModelProvider;
    public final BlockModelBuilder waystoneModel;
    public static final ResourceLocation inPostLocation = new ResourceLocation("signpost", "block/in_post_waystone");
    public final Map<ModelWaystone.Variant, ModelFile> variantModels = new HashMap<ModelWaystone.Variant, ModelFile>();

    public WaystoneModel(BlockModels blockModelProvider) {
        this.blockModelProvider = blockModelProvider;
        this.waystoneModel = new BlockModelBuilder(new ResourceLocation("signpost", "block/waystone"), blockModelProvider.existingFileHelper);
    }

    public void registerModels() {
        ResourceLocation waystoneTexture = new ResourceLocation("signpost", "block/waystone");
        this.blockModelProvider.cubeAll("waystone", waystoneTexture);
        ((BlockModelBuilder)((BlockModelBuilder)this.blockModelProvider.getBuilder(inPostLocation.toString())).element().from(-3.0f, 0.0f, -3.0f).to(3.0f, 6.0f, 3.0f).allFaces((dir, builder) -> builder.texture("#texture").uvs(5.0f, 5.0f, 11.0f, 11.0f)).end()).texture("texture", waystoneTexture);
        for (ModelWaystone.Variant variant : ModelWaystone.variants) {
            ResourceLocation loc = new ResourceLocation("signpost", "block/" + variant.registryName);
            BlockModelBuilder builder2 = (BlockModelBuilder)((BlockModelBuilder)((ObjModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.blockModelProvider.getBuilder(loc.toString())).parent((ModelFile)new ModelFile.ExistingModelFile(new ResourceLocation("block/block"), this.blockModelProvider.existingFileHelper))).texture("particle", waystoneTexture)).customLoader(ObjModelBuilder::begin)).modelLocation(new ResourceLocation(loc.m_135827_(), "models/block/" + variant.registryName + ".obj")).flipV(true).shadeQuads(true).emissiveAmbient(false).end()).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, 315.0f, 0.0f).translation(0.0f, variant.modelYOffset, 0.0f).scale(0.625f).end().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(0.0f, 315.0f, 0.0f).translation(0.0f, variant.modelYOffset, 0.0f).scale(0.4f).end().transform(ItemDisplayContext.FIRST_PERSON_LEFT_HAND).rotation(0.0f, 315.0f, 0.0f).translation(0.0f, variant.modelYOffset, 0.0f).scale(0.4f).end().end();
            this.variantModels.put(variant, (ModelFile)builder2);
        }
    }
}

