/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui.widgets;

import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.widgets.InputBox;
import gollorum.signpost.utils.math.Angle;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;

public class AngleInputBox
extends InputBox {
    public static final String degreeSign = Character.toString('\u00b0');
    private float currentResult;

    public AngleInputBox(Font fontRenderer, Rect inputFieldRect, double zOffset) {
        super(fontRenderer, new Rect(new Point(inputFieldRect.point.x + inputFieldRect.height, inputFieldRect.point.y), inputFieldRect.width - inputFieldRect.height, inputFieldRect.height), true, zOffset);
        this.m_94153_(null);
        this.m_94144_("0" + degreeSign);
        this.m_94151_(null);
    }

    private static boolean isValidValue(String text) {
        return text.endsWith(degreeSign) ? AngleInputBox.canParse(text.substring(0, text.length() - 1)) : AngleInputBox.canParse(text);
    }

    private static boolean canParse(String text) {
        if (text.equals("")) {
            return true;
        }
        if (text.equals("-")) {
            return true;
        }
        try {
            Integer.parseInt(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private float getResult() {
        String text = this.m_94155_().endsWith(degreeSign) ? this.m_94155_().substring(0, this.m_94155_().length() - 1) : this.m_94155_();
        return text.equals("") || text.equals("-") ? 0.0f : (float)Integer.parseInt(text);
    }

    public Angle getCurrentAngle() {
        return Angle.fromDegrees(this.currentResult);
    }

    public void m_94151_(@Nullable Consumer<String> responder) {
        super.m_94151_(value -> {
            this.currentResult = this.getResult();
            if (responder != null) {
                responder.accept((String)value);
            }
        });
    }

    public void m_94153_(@Nullable Predicate<String> filter) {
        super.m_94153_(value -> AngleInputBox.isValidValue(value) && (filter == null || filter.test((String)value)));
    }

    public void setAngleResponder(@Nullable Consumer<Angle> responder) {
        this.m_94151_(responder == null ? null : value -> responder.accept(Angle.fromDegrees(this.currentResult)));
    }

    public void setSelectedAngle(Angle angle) {
        this.m_94144_(Math.round(angle.degrees()) + degreeSign);
    }
}

