/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.gui.widgets;

import gollorum.signpost.minecraft.gui.utils.Point;
import gollorum.signpost.minecraft.gui.utils.Rect;
import gollorum.signpost.minecraft.gui.utils.TextureResource;
import gollorum.signpost.minecraft.gui.widgets.GuiModelRenderer;
import gollorum.signpost.minecraft.rendering.FlippableModel;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.ItemStack;

public class ModelButton
extends ImageButton {
    private final List<GuiModelRenderer> modelRenderers = new ArrayList<GuiModelRenderer>();

    public ModelButton(TextureResource background, Point point, float scale, Rect.XAlignment xAlignment, Rect.YAlignment yAlignment, Function<Rect, Rect> rectBuilder, Runnable onPress, ModelData ... modelData) {
        this(background, new Rect(point, background.size.scale(scale), xAlignment, yAlignment), scale, rectBuilder, b -> onPress.run(), modelData);
    }

    private ModelButton(TextureResource background, Rect rect, float scale, Function<Rect, Rect> rectBuilder, Button.OnPress onPress, ModelData ... modelData) {
        super(rect.point.x, rect.point.y, rect.width, rect.height, 0, 0, (int)((float)background.size.height * scale), background.location, (int)((float)background.fileSize.width * scale), (int)((float)background.fileSize.height * scale), onPress);
        for (ModelData model : modelData) {
            this.modelRenderers.add(new GuiModelRenderer(rectBuilder.apply(rect), model.model, model.modelSpaceXOffset, model.modelSpaceYOffset, model.renderType, model.tints));
        }
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_87963_(graphics, mouseX, mouseY, partialTicks);
        for (GuiModelRenderer model : this.modelRenderers) {
            model.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public static class ModelData {
        public final FlippableModel model;
        public final float modelSpaceXOffset;
        public final float modelSpaceYOffset;
        public final ItemStack itemStack;
        public final RenderType renderType;
        public final int[] tints;

        public ModelData(FlippableModel model, float modelSpaceXOffset, float modelSpaceYOffset, ItemStack itemStack, RenderType renderType, int[] tints) {
            this.model = model;
            this.modelSpaceXOffset = modelSpaceXOffset;
            this.modelSpaceYOffset = modelSpaceYOffset;
            this.itemStack = itemStack;
            this.renderType = renderType;
            this.tints = tints;
        }
    }
}

