/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.utils.tints;

import gollorum.signpost.utils.Tint;
import gollorum.signpost.utils.serialization.CompoundSerializable;
import gollorum.signpost.utils.serialization.ResourceLocationSerializer;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public record BlockColorTint(Block block, int tintIndex) implements Tint
{
    public static final CompoundSerializable<BlockColorTint> serializer = new CompoundSerializable<BlockColorTint>(){

        @Override
        public CompoundTag write(BlockColorTint tint, CompoundTag compound) {
            ResourceLocationSerializer.Instance.write(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)tint.block)), compound);
            compound.m_128405_("TintIndex", tint.tintIndex);
            return compound;
        }

        @Override
        public boolean isContainedIn(CompoundTag compound) {
            return ResourceLocationSerializer.Instance.isContainedIn(compound);
        }

        @Override
        public BlockColorTint read(CompoundTag compound) {
            return new BlockColorTint((Block)ForgeRegistries.BLOCKS.getValue(ResourceLocationSerializer.Instance.read(compound)), compound.m_128451_("TintIndex"));
        }

        @Override
        public void write(BlockColorTint tint, FriendlyByteBuf buffer) {
            ResourceLocationSerializer.Instance.write(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)tint.block)), buffer);
            buffer.writeInt(tint.tintIndex);
        }

        @Override
        public BlockColorTint read(FriendlyByteBuf buffer) {
            return new BlockColorTint((Block)ForgeRegistries.BLOCKS.getValue(ResourceLocationSerializer.Instance.read(buffer)), buffer.readInt());
        }

        @Override
        public Class<BlockColorTint> getTargetClass() {
            return BlockColorTint.class;
        }
    };

    @Override
    public int getColorAt(BlockAndTintGetter level, BlockPos pos) {
        return Minecraft.m_91087_().m_91298_().m_92577_(this.block.m_49966_(), level, pos, this.tintIndex);
    }

    public static void register() {
        Tint.Serialization.register("blockColor", serializer);
    }
}

