/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.minecraft.utils.tints;

import gollorum.signpost.utils.Tint;
import gollorum.signpost.utils.serialization.CompoundSerializable;
import gollorum.signpost.utils.serialization.ResourceLocationSerializer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.registries.ForgeRegistries;

public record FluidTint(Fluid fluid) implements Tint
{
    public static final CompoundSerializable<FluidTint> serializer = new CompoundSerializable<FluidTint>(){

        @Override
        public CompoundTag write(FluidTint fluidTint, CompoundTag compound) {
            ResourceLocationSerializer.Instance.write(ForgeRegistries.FLUIDS.getKey((Object)fluidTint.fluid), compound);
            return compound;
        }

        @Override
        public boolean isContainedIn(CompoundTag compound) {
            return ResourceLocationSerializer.Instance.isContainedIn(compound);
        }

        @Override
        public FluidTint read(CompoundTag compound) {
            return new FluidTint((Fluid)ForgeRegistries.FLUIDS.getValue(ResourceLocationSerializer.Instance.read(compound)));
        }

        @Override
        public void write(FluidTint fluidTint, FriendlyByteBuf buffer) {
            ResourceLocationSerializer.Instance.write(ForgeRegistries.FLUIDS.getKey((Object)fluidTint.fluid), buffer);
        }

        @Override
        public FluidTint read(FriendlyByteBuf buffer) {
            return new FluidTint((Fluid)ForgeRegistries.FLUIDS.getValue(ResourceLocationSerializer.Instance.read(buffer)));
        }

        @Override
        public Class<FluidTint> getTargetClass() {
            return FluidTint.class;
        }
    };

    @Override
    public int getColorAt(BlockAndTintGetter level, BlockPos pos) {
        return IClientFluidTypeExtensions.of((Fluid)this.fluid).getTintColor(this.fluid.m_76145_(), level, pos);
    }

    public static void register() {
        Tint.Serialization.register("fluid", serializer);
    }
}

