/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.networking;

import gollorum.signpost.networking.PacketHandler;
import gollorum.signpost.networking.SerializedWith;
import gollorum.signpost.utils.Tuple;
import gollorum.signpost.utils.serialization.BufferSerializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public abstract class ReflectionEvent<Self extends ReflectionEvent<Self>>
implements PacketHandler.Event<Self> {
    private final List<Tuple<Field, BufferSerializable>> fieldsAndSerializers;

    protected ReflectionEvent(Object thisIsNotTheEmptyConstructor) {
        this.fieldsAndSerializers = null;
    }

    protected ReflectionEvent() {
        this.fieldsAndSerializers = Arrays.stream(this.getClass().getDeclaredFields()).filter(f -> f.isAnnotationPresent(SerializedWith.class)).map(f -> {
            f.setAccessible(true);
            try {
                SerializedWith annotation = f.getAnnotation(SerializedWith.class);
                BufferSerializable<?> serializer = annotation.serializer().newInstance();
                if (annotation.optional()) {
                    serializer = serializer.optional();
                }
                if (f.getType().isAssignableFrom(serializer.getTargetClass())) {
                    return new Tuple((Field)f, serializer);
                }
                throw new RuntimeException("Tried to construct serializer for field " + f.getName() + " in class " + this.getClass().getName() + ", but the given one was for " + serializer.getTargetClass().getName() + " (expected " + f.getType() + ")");
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("Could not construct serializer for field " + f.getName() + " in class " + this.getClass().getName() + ": " + e.getMessage());
            }
        }).collect(Collectors.toList());
    }

    @Override
    public final void encode(Self self, FriendlyByteBuf buffer) {
        try {
            for (Tuple<Field, BufferSerializable> tuple : this.fieldsAndSerializers) {
                ((BufferSerializable)tuple._2).write(((Field)tuple._1).get(self), buffer);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Something went wrong trying to serialize class " + this.getClass().getName() + ": " + e.getMessage());
        }
    }

    @Override
    public final Self decode(FriendlyByteBuf buffer) {
        try {
            ReflectionEvent self = (ReflectionEvent)this.getClass().newInstance();
            for (Tuple<Field, BufferSerializable> tuple : this.fieldsAndSerializers) {
                ((Field)tuple._1).set(self, ((BufferSerializable)tuple._2).read(buffer));
            }
            return (Self)self;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Something went wrong trying to deserialize class " + this.getClass().getName() + ": " + e.getMessage());
        }
    }

    @Override
    public abstract void handle(Self var1, NetworkEvent.Context var2);
}

