/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public interface EventDispatcher<Event> {
    public boolean addListener(@Nonnull Listener<Event> var1);

    default public boolean addListener(@Nonnull Consumer<Event> listener) {
        return this.addListener(new ConsumerWrapper<Event>(listener));
    }

    public boolean removeListener(@Nonnull Listener<Event> var1);

    default public boolean removeListener(@Nonnull Consumer<Event> listener) {
        return this.removeListener(new ConsumerWrapper<Event>(listener));
    }

    public static class ConsumerWrapper<Event>
    implements Listener<Event> {
        private final Consumer<Event> consumer;

        public ConsumerWrapper(Consumer<Event> consumer) {
            this.consumer = consumer;
        }

        @Override
        public boolean accept(Event event) {
            this.consumer.accept(event);
            return false;
        }

        public int hashCode() {
            return this.consumer.hashCode();
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof ConsumerWrapper && this.consumer.equals(((ConsumerWrapper)obj).consumer) || this.consumer.equals(obj);
        }
    }

    public static interface Listener<Event> {
        public boolean accept(Event var1);
    }

    public static abstract class Impl<Event>
    implements EventDispatcher<Event> {
        protected final Set<Listener<Event>> listeners = new HashSet<Listener<Event>>();

        @Override
        public boolean addListener(@Nonnull Listener<Event> listener) {
            return this.listeners.add(listener);
        }

        @Override
        public boolean removeListener(@Nonnull Listener<Event> listener) {
            return this.listeners.remove(listener);
        }

        protected void dispatch(Event event, Set<Listener<Event>> listeners, boolean clearAfterwards) {
            listeners.forEach(listener -> {
                if (listener.accept(event) && !clearAfterwards) {
                    this.listeners.remove(listener);
                }
            });
        }

        public static class WithPublicDispatch<Event>
        extends Impl<Event> {
            public void dispatch(Event event, boolean clearAfterwards) {
                HashSet copyOfListeners = new HashSet(this.listeners);
                if (clearAfterwards) {
                    this.clear();
                }
                super.dispatch(event, copyOfListeners, clearAfterwards);
            }

            public void clear() {
                this.listeners.clear();
            }
        }
    }
}

