/*
 * Decompiled with CFR 0.152.
 */
package gollorum.signpost.utils.modelGeneration;

import java.util.function.Function;

public class TextureSegment {
    public final float from;
    public final float to;

    public TextureSegment(float from, float to, boolean clampCoords) {
        if (!(!clampCoords || TextureSegment.isInTextureBounds(from) && TextureSegment.isInTextureBounds(to))) {
            float originalFrom = from;
            float originalTo = to;
            float diff = to - from;
            if ((from %= 16.0f) < 0.0f) {
                from += 16.0f;
            }
            if (from == 0.0f && diff < 0.0f) {
                from = 16.0f;
            }
            if (!TextureSegment.isInTextureBounds(to = from + diff)) {
                throw new RuntimeException("The coordinates cannot be clamped; they cut the boundary: (" + originalFrom + "|" + originalTo + ")");
            }
        }
        this.from = from;
        this.to = to;
    }

    private static boolean isInTextureBounds(float i) {
        return i >= 0.0f && i <= 16.0f;
    }

    public TextureSegment map(Function<Float, Float> mapping) {
        return new TextureSegment(mapping.apply(Float.valueOf(this.from)).floatValue(), mapping.apply(Float.valueOf(this.to)).floatValue(), false);
    }

    public TextureSegment flip() {
        return new TextureSegment(this.to, this.from, false);
    }
}

