/*
 * Decompiled with CFR 0.152.
 */
package com.matt1235r.ConfigChecker;

import com.matt1235r.ConfigChecker.ApprovedModChecker;
import com.matt1235r.ConfigChecker.Event;
import com.matt1235r.ConfigChecker.MessageClass;
import com.matt1235r.ConfigChecker.ModConfigManager;
import com.matt1235r.ConfigChecker.ModVariables;
import java.awt.Desktop;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.io.FilenameUtils;

@Mod(value="concheckrmd")
public class Main {
    public Main() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ModConfigManager.spec);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        try {
            System.setProperty("java.awt.headless", "false");
            if (GraphicsEnvironment.isHeadless()) {
                System.out.printf("\n=========================================================================================\n\n[MODPACK CONFIGURATION CHECKER] NO DISPLAY DETECTED\n\n Modpack Configuration Checker can not check configuration in this enviroment. \n\n=========================================================================================\n", new Object[0]);
            } else {
                this.runChecks();
            }
        }
        catch (Exception e) {
            System.out.printf("\n=========================================================================================\n\n[MODPACK CONFIGURATION CHECKER] NO DISPLAY DETECTED\n\n Modpack Configuration Checker can not check configuration in this enviroment. \n\n=========================================================================================\n", new Object[0]);
        }
    }

    public void runChecks() {
        Main.LoadBetaConfig();
        ModVariables.gamebooting = true;
        ApprovedModChecker.StartChecks();
        this.meetsrequiredram();
        this.meetsrecommendedram();
        this.launchwebpage();
        this.displaycustommessage();
        MinecraftForge.EVENT_BUS.register((Object)new Event());
        this.gamelaunchtimout();
    }

    public static void LoadBetaConfig() {
        ModVariables.ramrecommendedinmbonload = (Integer)ModConfigManager.ramlaunch.launchrecommendedraminmb.get();
        ModVariables.checkRecommendedRAM = (Boolean)ModConfigManager.ramlaunch.launchcheckrecommendedram.get();
        ModVariables.RecommendedRAMPopupTopmost = (Boolean)ModConfigManager.ramlaunch.launchdisplayrammessageboxtopmost.get();
        ModVariables.DisplayCustomMessageBoxRecommendations = (Boolean)ModConfigManager.ramlaunch.launchcustomrecommendedtext.get();
        ModVariables.CustomRAMRecommendationsMessageBox = (String)ModConfigManager.ramlaunch.messageboxtext.get();
        ModVariables.ramrecommendedinmbingame = (Integer)ModConfigManager.ramgame.chatrecommendedraminmb.get();
        ModVariables.showrecommendedramingame = (Boolean)ModConfigManager.ramgame.chatcheckrecommendedram.get();
        ModVariables.showrecommendedramingamecustommessage = (Boolean)ModConfigManager.ramgame.chatcustomrecommendedtext.get();
        ModVariables.recommendedramingamecustommessage = (String)ModConfigManager.ramgame.chatramcustomtext.get();
        ModVariables.ramrequiredinmb = (Integer)ModConfigManager.reqram.requiredraminmb.get();
        ModVariables.checkRequiredRAM = (Boolean)ModConfigManager.reqram.checkrequiredram.get();
        ModVariables.RequiredRAMPopupTopmost = (Boolean)ModConfigManager.reqram.ramreqmessageboxtopmost.get();
        ModVariables.DisplayCustomMessageBoxRequirements = (Boolean)ModConfigManager.reqram.customrequiredtext.get();
        ModVariables.CustomRAMRequirementsMessageBox = (String)ModConfigManager.reqram.requiredramcustomtext.get();
        ModVariables.displaygreetingmessageingame = (Boolean)ModConfigManager.customg.displaychatgreeting.get();
        ModVariables.greetingmessagetext = (String)ModConfigManager.customg.greetingmessagetext.get();
        ModVariables.greetingmessagecolor = Event.parseGreetingColor((ModConfigManager.TextFormattingColor)((Object)ModConfigManager.customg.greetingmessagecolor.get()));
        ModVariables.launchtimeoutinseconds = (Integer)ModConfigManager.launchtimeout.launchtimeoutinseconds.get();
        ModVariables.checklaunchtimeout = (Boolean)ModConfigManager.launchtimeout.checklaunchtimeout.get();
        ModVariables.launchtimeoutmessageboxtopmost = (Boolean)ModConfigManager.launchtimeout.launchtimeoutmessageboxtopmost.get();
        ModVariables.displaycustomlaunchtimeoutmessagebox = (Boolean)ModConfigManager.launchtimeout.displaycustomlaunchtimeoutmessagebox.get();
        ModVariables.customlaunchtimeoutmessageboxtext = (String)ModConfigManager.launchtimeout.customlaunchtimeoutmessageboxtext.get();
        ModVariables.webpageURL = (String)ModConfigManager.webpage.websiteurl.get();
        ModVariables.launchwebpage = (Boolean)ModConfigManager.webpage.displaywebsite.get();
        ModVariables.displaylaunchmessage = (Boolean)ModConfigManager.custommb.displaymessagebox.get();
        ModVariables.launchmessagetext = (String)ModConfigManager.custommb.messageboxtext.get();
        ModVariables.launchmessagetopmost = (Boolean)ModConfigManager.custommb.displaymessageboxtopmost.get();
        ModVariables.displayfirstlaunchmessage = (Boolean)ModConfigManager.customfirstlaunchmb.displaymessagebox.get();
        ModVariables.firstlaunchmessagetext = (String)ModConfigManager.customfirstlaunchmb.messageboxtext.get();
        ModVariables.firstlaunchmessagetopmost = (Boolean)ModConfigManager.customfirstlaunchmb.displaymessageboxtopmost.get();
    }

    public static boolean previousversion() {
        return new File("config/Config Checker.cfg").exists();
    }

    public void filedatecheck() {
        if (ModVariables.checkfiledate1.booleanValue()) {
            if (new File(ModVariables.pathtofiledate1).exists()) {
                this.filedatecheck1();
            } else if (ModVariables.filedatedebugmode) {
                JOptionPane.showMessageDialog(new JFrame(), "File: " + new File(ModVariables.pathtofiledate1).getName() + " does not exist. Can not check file version.", "File does not exist", 2);
            }
        }
    }

    public void filedatecheck1() {
        JFrame topframe = new JFrame();
        topframe.setAlwaysOnTop(true);
        try {
            int dialogResult;
            JFrame jf;
            SimpleDateFormat sdf = null;
            try {
                sdf = new SimpleDateFormat(ModVariables.datetimeformatstring1);
            }
            catch (Exception e) {
                if (ModVariables.filedatedebugmode) {
                    JOptionPane.showMessageDialog(topframe, "Error parsing date format string: " + ModVariables.datetimeformatstring1 + ". Date format strings should follow a structure similar to 'dd/MM/yyyy', 'MM/dd/yy' etc.", "Error parsing date format string", 2);
                }
                return;
            }
            Calendar reqcal = Calendar.getInstance();
            try {
                reqcal.setTimeInMillis(sdf.parse(ModVariables.minimumdatetime1).getTime());
            }
            catch (Exception e) {
                if (ModVariables.filedatedebugmode) {
                    JOptionPane.showMessageDialog(topframe, "Error parsing minimum date: " + ModVariables.minimumdatetime1 + ". This date should follow the format of the date string: " + ModVariables.datetimeformatstring1, "Error parsing date format string", 2);
                }
                return;
            }
            Calendar filecal = Calendar.getInstance();
            try {
                FileReader fileReader = new FileReader(ModVariables.pathtofiledate1);
                fileReader.read();
                fileReader.close();
                filecal.setTimeInMillis(new File(ModVariables.pathtofiledate1).lastModified());
            }
            catch (Exception e) {
                if (ModVariables.filedatedebugmode) {
                    JOptionPane.showMessageDialog(topframe, "Error detecting last modified date of file: " + new File(ModVariables.pathtofiledate1).getName() + ". This is probably due to insufficient access rights on the file. ", "Error detecting last modified", 2);
                }
                return;
            }
            if (filecal.compareTo(reqcal) == -1 && ModVariables.datechecknewerorolder1 == "FileOlder") {
                jf = new JFrame();
                if (ModVariables.filedatetopmost1.booleanValue()) {
                    jf.setAlwaysOnTop(true);
                }
                if ((dialogResult = ModVariables.custommessagefiledate1 != false ? new MessageClass().PopulateMessage(jf, "A Problem was Detected while Launching the Game", ModVariables.custommessagefiledate1text, "", "", 0) : new MessageClass().PopulateMessage(jf, "A Problem was Detected while Launching the Game", "Modpack Configuration Checker has detected that the following file is out of date and should be updated.\r\n\r\nPlease contact the modpack author to download an updated version.\r\n\r\nOutdated File: " + FilenameUtils.getName((String)ModVariables.pathtofiledate1), "", "", 0)) == 1) {
                    System.exit(0);
                }
            }
            if (filecal.compareTo(reqcal) == 1 && ModVariables.datechecknewerorolder1 == "FileNewer") {
                jf = new JFrame();
                if (ModVariables.filedatetopmost1.booleanValue()) {
                    jf.setAlwaysOnTop(true);
                }
                if ((dialogResult = ModVariables.custommessagefiledate1 != false ? new MessageClass().PopulateMessage(jf, "A Problem was Detected while Launching the Game", ModVariables.custommessagefiledate1text, "", "", 0) : new MessageClass().PopulateMessage(jf, "A Problem was Detected while Launching the Game", "Modpack Configuration Checker has detected that the following file has been modified too recently is not compatible with this version.\r\n\r\nPlease contact the modpack author to download an older version.\r\n\r\nIncompatible File: " + FilenameUtils.getName((String)ModVariables.pathtofiledate1), "", "", 0)) == 1) {
                    System.exit(0);
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(topframe, "Something went wrong while checking file date. Error Message says: " + e.getMessage(), "Error detecting last modified", 2);
        }
    }

    public void gamelaunchtimout() {
        if (ModVariables.checklaunchtimeout) {
            Timer timer = new Timer();
            final JFrame jf = new JFrame();
            long launchtimeout = TimeUnit.SECONDS.toMillis(ModVariables.launchtimeoutinseconds);
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (ModVariables.gamebooting) {
                        if (ModVariables.launchtimeoutmessageboxtopmost) {
                            jf.setAlwaysOnTop(true);
                        }
                        if (ModVariables.displaycustomlaunchtimeoutmessagebox) {
                            new MessageClass().PopulateMessage(jf, "Message from Modpack Author", ModVariables.customlaunchtimeoutmessageboxtext, "", "", 1);
                        } else {
                            new MessageClass().PopulateMessage(jf, "Message from Modpack Author", "Modpack Configuration Checker has detected that the game has taken too long to start.\r\n\r\nThis may be due to this computer not being powerful enough to run this modpack, or the game may not be configured correctly.\r\n\r\nPlease contact the modpack author for assistance.", "", "", 1);
                        }
                        System.exit(1);
                    }
                }
            }, launchtimeout);
        }
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit = 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String calculateTime(long millis) {
        long days = TimeUnit.MILLISECONDS.toDays(millis);
        long hours = TimeUnit.MILLISECONDS.toHours(millis -= TimeUnit.DAYS.toMillis(days));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis -= TimeUnit.MINUTES.toMillis(minutes));
        StringBuilder sb = new StringBuilder(64);
        if (days == 1L) {
            sb.append(days);
            sb.append(" day ");
        } else if (days != 0L) {
            sb.append(days);
            sb.append(" days ");
        }
        if (hours == 1L) {
            sb.append(hours);
            sb.append(" hour ");
        } else if (hours != 0L) {
            sb.append(hours);
            sb.append(" hours ");
        }
        if (minutes == 1L) {
            sb.append(minutes);
            sb.append(" minute ");
        } else if (minutes != 0L) {
            sb.append(minutes);
            sb.append(" minutes ");
        }
        if (seconds == 1L) {
            sb.append(seconds);
            sb.append(" second ");
        } else if (seconds != 0L) {
            sb.append(seconds);
            sb.append(" seconds ");
        }
        return sb.toString();
    }

    public void launchwebpage() {
        if (ModVariables.launchwebpage) {
            Desktop desktop = Desktop.getDesktop();
            try {
                if (ModVariables.webpageURL.startsWith("http")) {
                    desktop.browse(URI.create(ModVariables.webpageURL));
                } else {
                    desktop.browse(URI.create("http://" + ModVariables.webpageURL));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                JFrame jf = new JFrame();
                jf.setAlwaysOnTop(true);
                JOptionPane.showMessageDialog(jf, "Error opening webpage. The error is: " + e.getMessage(), "Error Opening Webpage", 0);
            }
        }
    }

    public void displaycustommessage() {
        if (ModVariables.displaylaunchmessage) {
            JFrame jf = new JFrame();
            if (ModVariables.launchmessagetopmost) {
                jf.setAlwaysOnTop(true);
            }
            int n = new MessageClass().PopulateMessage(jf, "Message from Modpack Author", ModVariables.launchmessagetext, "", "", 2);
        }
    }

    public void meetsrecommendedram() {
        int currentraminmb;
        if (ModVariables.checkRecommendedRAM && ModVariables.ramrecommendedinmbonload > (currentraminmb = (int)(Runtime.getRuntime().maxMemory() / 1024L / 1024L))) {
            this.coulddowithmoreram();
        }
    }

    public void coulddowithmoreram() {
        int dialogResult;
        long RamRecommendedinbytes = ModVariables.ramrecommendedinmbonload * 1024;
        JFrame jf = new JFrame();
        if (ModVariables.RecommendedRAMPopupTopmost) {
            jf.setAlwaysOnTop(true);
        }
        if ((dialogResult = ModVariables.DisplayCustomMessageBoxRecommendations ? new MessageClass().PopulateMessage(jf, "A Problem was Detected while Launching the Game", ModVariables.CustomRAMRecommendationsMessageBox, Main.humanReadableByteCount(Runtime.getRuntime().maxMemory(), true), Main.humanReadableByteCount(RamRecommendedinbytes * 1024L, true), 0) : new MessageClass().PopulateMessage(jf, "A Problem was Detected while Launching the Game", "Modpack Configuration Checker has detected that you have not assigned the recommended amount of memory to this modpack.\r\n\r\nNot meeting the memory requirements can result in degraded performance, resulting in freezing and crashes.\r\n\r\nIt is recommended that you exit the game and assign more memory to this modpack now.", Main.humanReadableByteCount(Runtime.getRuntime().maxMemory(), true), Main.humanReadableByteCount(RamRecommendedinbytes * 1024L, true), 0)) == 1) {
            System.exit(0);
        }
    }

    public void meetsrequiredram() {
        int currentraminmb;
        if (ModVariables.checkRequiredRAM && ModVariables.ramrequiredinmb > (currentraminmb = (int)(Runtime.getRuntime().maxMemory() / 1024L / 1024L))) {
            this.needmoreram();
        }
    }

    public void needmoreram() {
        long RamRequiredinbytes = ModVariables.ramrequiredinmb * 1024;
        JFrame jf = new JFrame();
        if (ModVariables.RequiredRAMPopupTopmost) {
            jf.setAlwaysOnTop(true);
        }
        if (ModVariables.DisplayCustomMessageBoxRequirements) {
            new MessageClass().PopulateMessage(jf, "A Problem was Detected while Launching the Game", ModVariables.CustomRAMRequirementsMessageBox, Main.humanReadableByteCount(Runtime.getRuntime().maxMemory(), true), Main.humanReadableByteCount(RamRequiredinbytes * 1024L, true), 1);
        } else {
            new MessageClass().PopulateMessage(jf, "A Problem was Detected while Launching the Game", "Modpack Configuration Checker has detected that you have not assigned the required amount of memory to this modpack.\r\n\r\nNot meeting the memory requirements will result in poor performance, resulting in freezing and crashes.\r\n\r\nTo play this modpack you must exit the game and assign more memory to this modpack now.", Main.humanReadableByteCount(Runtime.getRuntime().maxMemory(), true), Main.humanReadableByteCount(RamRequiredinbytes * 1024L, true), 1);
        }
        System.exit(0);
    }
}

