/*
 * Decompiled with CFR 0.152.
 */
package com.matt1235r.ConfigChecker;

import net.minecraftforge.common.ForgeConfigSpec;

public class ModConfigManager {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final CustomGreetingMessage customg = new CustomGreetingMessage(BUILDER);
    public static final CustomMessageBox custommb = new CustomMessageBox(BUILDER);
    public static final FirstLaunchMessageBox customfirstlaunchmb = new FirstLaunchMessageBox(BUILDER);
    public static final DisplayWebpage webpage = new DisplayWebpage(BUILDER);
    public static final RamRecommendationLaunch ramlaunch = new RamRecommendationLaunch(BUILDER);
    public static final RamRecommendationChat ramgame = new RamRecommendationChat(BUILDER);
    public static final RamRequired reqram = new RamRequired(BUILDER);
    public static final GameLaunchTimeout launchtimeout = new GameLaunchTimeout(BUILDER);
    public static final ForgeConfigSpec spec = BUILDER.build();

    public static class CustomGreetingMessage {
        public final ForgeConfigSpec.ConfigValue<Boolean> displaychatgreeting;
        public final ForgeConfigSpec.ConfigValue<String> greetingmessagetext;
        public final ForgeConfigSpec.ConfigValue<TextFormattingColor> greetingmessagecolor;

        public CustomGreetingMessage(ForgeConfigSpec.Builder builder) {
            builder.push("Customisable Chat Greeting Message").comment("Customisable message that will appear in chat when a world is loaded. This is useful for displaying credits.");
            this.displaychatgreeting = builder.comment("Customisable message that will be displayed in chat when a world is loaded.").define("#1) Display Chat Greeting Message?", false);
            this.greetingmessagetext = builder.comment("The text to be displayed in chat.").define("#2) Greeting Message Text", (Object)"Hello there! Welcome to my modpack.");
            this.greetingmessagecolor = builder.comment("The color of the message to be displayed in chat.").defineEnum("#3) Greeting Message Color", (Enum)TextFormattingColor.Purple);
            builder.pop();
        }
    }

    public static class CustomMessageBox {
        public final ForgeConfigSpec.ConfigValue<Boolean> displaymessagebox;
        public final ForgeConfigSpec.ConfigValue<Boolean> displaymessageboxtopmost;
        public final ForgeConfigSpec.ConfigValue<String> messageboxtext;

        public CustomMessageBox(ForgeConfigSpec.Builder builder) {
            builder.push("Customisable Start Message").comment("Customisable message that will appear each time the game starts. This is useful for displaying credits.");
            this.displaymessagebox = builder.comment("Customisable message that will appear each time the game starts. This is useful for displaying credits.").define("#1) Display message box?", false);
            this.displaymessageboxtopmost = builder.comment("Will the window show on top of all other windows? Recommended to keep set to True.").define("#2) Display message box topmost?", true);
            this.messageboxtext = builder.comment("The text that will be displayed in the message box.").define("#3) Message Box Text", (Object)"Hello Modpack Users! Made by matt_r__");
            builder.pop();
        }
    }

    public static class FirstLaunchMessageBox {
        public final ForgeConfigSpec.ConfigValue<Boolean> displaymessagebox;
        public final ForgeConfigSpec.ConfigValue<Boolean> displaymessageboxtopmost;
        public final ForgeConfigSpec.ConfigValue<String> messageboxtext;

        public FirstLaunchMessageBox(ForgeConfigSpec.Builder builder) {
            builder.push("Customisable First Start Message").comment("A customisable message that will only appear when the game is started for the first time. This is useful for displaying instructions.");
            this.displaymessagebox = builder.comment("A message box that will be displayed when the game is started for the first time. This is useful for displaying instructions.").define("#1) Display message box?", false);
            this.displaymessageboxtopmost = builder.comment("Will the window show on top of all other windows? Recommended to keep set to True.").define("#2) Display message box topmost?", true);
            this.messageboxtext = builder.comment("The text that will be displayed in the message box.").define("#3) Message Box Text", (Object)"Welcome. Thank you for starting my modpack for the first time!");
            builder.pop();
        }
    }

    public static class DisplayWebpage {
        public final ForgeConfigSpec.ConfigValue<Boolean> displaywebsite;
        public final ForgeConfigSpec.ConfigValue<String> websiteurl;

        public DisplayWebpage(ForgeConfigSpec.Builder builder) {
            builder.push("Open A Website when the Game Starts").comment("The browser will open a webpage when the game starts. This is useful for providing support and displaying credits.");
            this.displaywebsite = builder.comment("Opens a webpage when the game starts. This is useful for modpack support.").define("#1) Display Website when game starts?", false);
            this.websiteurl = builder.comment("The URL of the website that will be displayed. This can be formatted like: http://google.com, www.google.com or google.com.").define("#2) Website URL", (Object)"minecraft.curseforge.com/projects/config-checker");
            builder.pop();
        }
    }

    public static class RamRecommendationLaunch {
        public final ForgeConfigSpec.ConfigValue<Integer> launchrecommendedraminmb;
        public final ForgeConfigSpec.ConfigValue<Boolean> launchcheckrecommendedram;
        public final ForgeConfigSpec.ConfigValue<Boolean> launchdisplayrammessageboxtopmost;
        public final ForgeConfigSpec.ConfigValue<Boolean> launchcustomrecommendedtext;
        public final ForgeConfigSpec.ConfigValue<String> messageboxtext;

        public RamRecommendationLaunch(ForgeConfigSpec.Builder builder) {
            builder.push("RAM Recommended for Game to Start").comment("Set a recommended amount of RAM that is recommended for the modpack to run. If this recommendation is not met then a warning will be displayed when the game is started.");
            this.launchrecommendedraminmb = builder.comment("The amount of RAM recommended for stable gameplay.").defineInRange("#1) Ram Recommended (IN MB)", 2048, 128, 51200);
            this.launchcheckrecommendedram = builder.comment("If the player has less than the recommended amount of RAM assigned to the modpack then a warning will be displayed when the game is started.").define("#2) Check RAM meets recommendation?", true);
            this.launchdisplayrammessageboxtopmost = builder.comment("Will the window show on top of all other windows? I highly recommend this is left as true.").define("#3) Display message box topmost?", true);
            this.launchcustomrecommendedtext = builder.comment("Customise the text that appears in the warning message. Will display custom message instead of the default text.").define("#4) Customise low RAM Warning?", false);
            this.messageboxtext = builder.comment("The custom message to be displayed if you have set the previous setting to 'True'. Will display custom message instead of the default text.").define("#5) Custom Message", (Object)"You should assign more RAM to expierence better performance.");
            builder.pop();
        }
    }

    public static class RamRecommendationChat {
        public final ForgeConfigSpec.ConfigValue<Integer> chatrecommendedraminmb;
        public final ForgeConfigSpec.ConfigValue<Boolean> chatcheckrecommendedram;
        public final ForgeConfigSpec.ConfigValue<Boolean> chatcustomrecommendedtext;
        public final ForgeConfigSpec.ConfigValue<String> chatramcustomtext;

        public RamRecommendationChat(ForgeConfigSpec.Builder builder) {
            builder.push("Recommended RAM Chat Message").comment("SetSet a recommended amount of RAM that is recommended for the modpack to run. If this recommendation is not met then a warning will be displayed in chat when a world is loaded.");
            this.chatrecommendedraminmb = builder.comment("The amount of RAM recommended for stable gameplay.").defineInRange("#1) Ram Recommended (IN MB)", 2048, 128, 51200);
            this.chatcheckrecommendedram = builder.comment("If the player has less than the recommended amount of RAM assigned to the modpack then a warning will be displayed in chat when a world is loaded.").define("#2) Check RAM meets recommendation?", true);
            this.chatcustomrecommendedtext = builder.comment("Customise the text that appears in the warning message. Will display custom message instead of the default text.").define("#3) Customise low RAM Warning?", false);
            this.chatramcustomtext = builder.comment("The custom message to be displayed in chat if you have set the previous setting to 'True'. Will display custom message instead of the default text.").define("#4) Custom Message", (Object)"You should assign more RAM to expierence better performance.");
            builder.pop();
        }
    }

    public static class RamRequired {
        public final ForgeConfigSpec.ConfigValue<Integer> requiredraminmb;
        public final ForgeConfigSpec.ConfigValue<Boolean> checkrequiredram;
        public final ForgeConfigSpec.ConfigValue<Boolean> ramreqmessageboxtopmost;
        public final ForgeConfigSpec.ConfigValue<Boolean> customrequiredtext;
        public final ForgeConfigSpec.ConfigValue<String> requiredramcustomtext;

        public RamRequired(ForgeConfigSpec.Builder builder) {
            builder.push("RAM Required for Game to Start").comment("Set a required amount of RAM that is required for the modpack to run. If this requirement is not met then an error will be displayed when the game is started and the game will close.");
            this.requiredraminmb = builder.comment("The amount of RAM required for the game to run.").defineInRange("#1) Ram Required (IN MB)", 1024, 128, 51200);
            this.checkrequiredram = builder.comment("If the player has less than the required amount of RAM assigned to the modpack then they will be alerted as the game starts and the game will close.").define("#2) Check RAM meets requirement?", false);
            this.ramreqmessageboxtopmost = builder.comment("Will the window show on top of all other windows? I highly recommend this is left as true.").define("#3) Display message box topmost?", true);
            this.customrequiredtext = builder.comment("Customise the text that appears in the error message. Will display custom message instead of the default text.").define("#4) Display custom text in messagebox?", false);
            this.requiredramcustomtext = builder.comment("The custom message to be displayed if you have set the previous setting to 'True'. Will display custom message instead of the default text.").define("#5) Custom Message", (Object)"You need more RAM. The game will close.");
            builder.pop();
        }
    }

    public static class GameLaunchTimeout {
        public final ForgeConfigSpec.ConfigValue<Integer> launchtimeoutinseconds;
        public final ForgeConfigSpec.ConfigValue<Boolean> checklaunchtimeout;
        public final ForgeConfigSpec.ConfigValue<Boolean> launchtimeoutmessageboxtopmost;
        public final ForgeConfigSpec.ConfigValue<Boolean> displaycustomlaunchtimeoutmessagebox;
        public final ForgeConfigSpec.ConfigValue<String> customlaunchtimeoutmessageboxtext;

        public GameLaunchTimeout(ForgeConfigSpec.Builder builder) {
            builder.push("Game Launch Time Limit").comment("Set the maximum time the game can spend booting. If the game exceeds this time limit then then an error will be displayed when the game is started and the game will close.");
            this.launchtimeoutinseconds = builder.comment("The maximum amount of time the game will be allowed to spend booting. (IN SECONDS)").defineInRange("#1) Launch Timeout (IN SECONDS)", 30, 5, 5400);
            this.checklaunchtimeout = builder.comment("If the game exceeds the launch timeout then a messagebox will be displayed and the game will close.").define("#2) Check game meets launch timeout?", false);
            this.launchtimeoutmessageboxtopmost = builder.comment("Will the window show on top of all other windows? I highly recommend this is left as true.").define("#3) Display message box topmost?", true);
            this.displaycustomlaunchtimeoutmessagebox = builder.comment("Customise the text that appears in the error message. Will display custom message instead of the default text.").define("#4) Display custom text in error message?", false);
            this.customlaunchtimeoutmessageboxtext = builder.comment("The custom message to be displayed if you have set the previous setting to 'True'. Will display custom message instead of the default text.").define("#5) Custom Message", (Object)"The game has taken too long too start to start this modpack. This is probably due to insufficient system resources. The game will now close.");
            builder.pop();
        }
    }

    public static enum TextFormattingColor {
        Blue,
        Green,
        Red,
        Aqua,
        Yellow,
        White,
        Black,
        Grey,
        Purple,
        Dark_Blue,
        Dark_Green,
        Dark_Red,
        Dark_Purple;

    }
}

