/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix4f;
import slimeknights.mantle.client.screen.ElementScreen;
import slimeknights.tconstruct.library.client.RenderUtils;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;

public final class GuiUtil {
    public static void drawBackground(GuiGraphics graphics, AbstractContainerScreen<?> screen, ResourceLocation background) {
        graphics.m_280218_(background, screen.f_97735_, screen.f_97736_, 0, 0, screen.f_97726_, screen.f_97727_);
    }

    public static boolean isHovered(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseY >= y && mouseX < x + width && mouseY < y + height;
    }

    public static boolean isTankHovered(int mouseX, int mouseY, int amount, int capacity, int x, int y, int width, int height) {
        if (mouseX < x || mouseX > x + width || mouseY > y + height) {
            return false;
        }
        int topHeight = height - height * amount / capacity;
        return mouseY > y + topHeight;
    }

    public static void renderFluidTank(PoseStack matrices, AbstractContainerScreen<?> screen, FluidStack stack, int capacity, int x, int y, int width, int height, int depth) {
        GuiUtil.renderFluidTank(matrices, screen, stack, stack.getAmount(), capacity, x, y, width, height, depth);
    }

    public static void renderFluidTank(PoseStack matrices, AbstractContainerScreen<?> screen, FluidStack stack, int amount, int capacity, int x, int y, int width, int height, int depth) {
        if (!stack.isEmpty() && capacity > 0) {
            int maxY = y + height;
            int fluidHeight = Math.min(height * amount / capacity, height);
            GuiUtil.renderTiledFluid(matrices, screen, stack, x, maxY - fluidHeight, width, fluidHeight, depth);
        }
    }

    public static void renderTiledFluid(PoseStack matrices, AbstractContainerScreen<?> screen, FluidStack stack, int x, int y, int width, int height, int depth) {
        if (!stack.isEmpty()) {
            IClientFluidTypeExtensions clientFluid = IClientFluidTypeExtensions.of((Fluid)stack.getFluid());
            TextureAtlasSprite fluidSprite = (TextureAtlasSprite)screen.getMinecraft().m_91258_(InventoryMenu.f_39692_).apply(clientFluid.getStillTexture(stack));
            RenderUtils.setColorRGBA(clientFluid.getTintColor(stack));
            GuiUtil.renderTiledTextureAtlas(matrices, screen, fluidSprite, x, y, width, height, depth, stack.getFluid().getFluidType().isLighterThanAir());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static void renderTiledTextureAtlas(PoseStack matrices, AbstractContainerScreen<?> screen, TextureAtlasSprite sprite, int x, int y, int width, int height, int depth, boolean upsideDown) {
        RenderUtils.bindTexture(sprite.m_247685_());
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        float u1 = sprite.m_118409_();
        float v1 = sprite.m_118411_();
        int spriteHeight = sprite.m_245424_().m_245330_();
        int spriteWidth = sprite.m_245424_().m_246492_();
        int startX = x + screen.f_97735_;
        int startY = y + screen.f_97736_;
        do {
            int renderHeight = Math.min(spriteHeight, height);
            height -= renderHeight;
            float v2 = sprite.m_118393_((double)(16.0f * (float)renderHeight / (float)spriteHeight));
            int x2 = startX;
            int widthLeft = width;
            Matrix4f matrix = matrices.m_85850_().m_252922_();
            do {
                int renderWidth = Math.min(spriteWidth, widthLeft);
                widthLeft -= renderWidth;
                float u2 = sprite.m_118367_((double)(16.0f * (float)renderWidth / (float)spriteWidth));
                if (upsideDown) {
                    GuiUtil.buildSquare(matrix, builder, x2, x2 + renderWidth, startY, startY + renderHeight, depth, u1, u2, v2, v1);
                } else {
                    GuiUtil.buildSquare(matrix, builder, x2, x2 + renderWidth, startY, startY + renderHeight, depth, u1, u2, v1, v2);
                }
                x2 += renderWidth;
            } while (widthLeft > 0);
            startY += renderHeight;
        } while (height > 0);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
        RenderSystem.enableDepthTest();
    }

    private static void buildSquare(Matrix4f matrix, BufferBuilder builder, int x1, int x2, int y1, int y2, int z, float u1, float u2, float v1, float v2) {
        builder.m_252986_(matrix, (float)x1, (float)y2, (float)z).m_7421_(u1, v2).m_5752_();
        builder.m_252986_(matrix, (float)x2, (float)y2, (float)z).m_7421_(u2, v2).m_5752_();
        builder.m_252986_(matrix, (float)x2, (float)y1, (float)z).m_7421_(u2, v1).m_5752_();
        builder.m_252986_(matrix, (float)x1, (float)y1, (float)z).m_7421_(u1, v1).m_5752_();
    }

    public static void drawProgressUp(GuiGraphics graphics, ElementScreen element, int x, int y, float progress) {
        int height = progress > 1.0f ? element.h : (progress < 0.0f ? 0 : (int)((double)(progress * (float)element.h) + 0.5));
        int deltaY = element.h - height;
        graphics.m_280163_(element.texture, x, y + deltaY, (float)element.x, (float)(element.y + deltaY), element.w, height, element.texW, element.texH);
    }

    public static void renderHighlight(GuiGraphics graphics, int x, int y, int width, int height) {
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        graphics.m_280046_(x, y, x + width, y + height, 100, -2130706433);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
    }

    public static void renderPattern(GuiGraphics graphics, Pattern pattern, int x, int y) {
        TextureAtlasSprite sprite = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_).m_118316_(pattern.getTexture());
        graphics.m_280159_(x, y, 100, 16, 16, sprite);
    }

    private GuiUtil() {
    }
}

