/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.library.client.armor.texture.ArmorTextureSupplier;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.item.armor.ModifiableArmorItem;

public abstract class AbstractArmorModel
extends Model {
    @Nullable
    protected HumanoidModel<?> base;
    protected boolean hasGlint = false;
    protected ArmorTextureSupplier.TextureType textureType = ArmorTextureSupplier.TextureType.ARMOR;
    protected boolean hasWings = false;
    @Nullable
    public static MultiBufferSource buffer;
    @Nullable
    private static ElytraModel<LivingEntity> wingsModel;

    protected AbstractArmorModel() {
        super(RenderType::m_110458_);
    }

    protected void setup(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> base) {
        this.base = base;
        this.hasGlint = stack.m_41790_();
        this.textureType = ArmorTextureSupplier.TextureType.fromSlot(slot);
        if (slot == EquipmentSlot.CHEST) {
            this.hasWings = ModifierUtil.checkVolatileFlag(stack, ModifiableArmorItem.ELYTRA);
            if (this.hasWings) {
                ElytraModel<LivingEntity> wings = this.getWings();
                wings.m_6973_(living, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                AbstractArmorModel.copyProperties(base, wings);
            }
        } else {
            this.hasWings = false;
        }
    }

    public static void renderColored(Model model, PoseStack matrices, VertexConsumer buffer, int packedLightIn, int packedOverlayIn, int color, float red, float green, float blue, float alpha) {
        if (color != -1) {
            alpha *= (float)(color >> 24 & 0xFF) / 255.0f;
            red *= (float)(color >> 16 & 0xFF) / 255.0f;
            green *= (float)(color >> 8 & 0xFF) / 255.0f;
            blue *= (float)(color & 0xFF) / 255.0f;
        }
        model.m_7695_(matrices, buffer, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    protected void renderWings(PoseStack matrices, int packedLightIn, int packedOverlayIn, ArmorTextureSupplier.ArmorTexture texture, float red, float green, float blue, float alpha, boolean hasGlint) {
        matrices.m_85836_();
        matrices.m_85837_(0.0, 0.0, 0.125);
        assert (buffer != null);
        texture.renderTexture((Model)this.getWings(), matrices, buffer, packedLightIn, packedOverlayIn, red, green, blue, alpha, hasGlint);
        matrices.m_85849_();
    }

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, false, RenderLivingEvent.Pre.class, event -> {
            buffer = event.getMultiBufferSource();
        });
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, false, RenderLivingEvent.Post.class, event -> {
            buffer = null;
        });
    }

    private ElytraModel<LivingEntity> getWings() {
        if (wingsModel == null) {
            wingsModel = new ElytraModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171141_));
        }
        return wingsModel;
    }

    public static <T extends LivingEntity> void copyProperties(EntityModel<T> base, EntityModel<?> other) {
        base.m_102624_(other);
    }
}

