/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.modifiers.adding;

import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.util.LazyModifier;
import slimeknights.tconstruct.library.recipe.modifiers.adding.AbstractModifierRecipeBuilder;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IncrementalModifierRecipe;

public class IncrementalModifierRecipeBuilder
extends AbstractModifierRecipeBuilder<IncrementalModifierRecipeBuilder> {
    private Ingredient input = Ingredient.f_43901_;
    private int amountPerItem;
    private int neededPerLevel;
    private ItemOutput leftover = ItemOutput.EMPTY;

    protected IncrementalModifierRecipeBuilder(ModifierId result) {
        super(result);
    }

    public static IncrementalModifierRecipeBuilder modifier(ModifierId modifier) {
        return new IncrementalModifierRecipeBuilder(modifier);
    }

    public static IncrementalModifierRecipeBuilder modifier(LazyModifier modifier) {
        return IncrementalModifierRecipeBuilder.modifier(modifier.getId());
    }

    public IncrementalModifierRecipeBuilder setInput(Ingredient input, int amountPerItem, int neededPerLevel) {
        if (amountPerItem < 1) {
            throw new IllegalArgumentException("Amount per item must be at least 1");
        }
        if (neededPerLevel <= amountPerItem) {
            throw new IllegalArgumentException("Needed per level must be greater than amount per item");
        }
        this.input = input;
        this.amountPerItem = amountPerItem;
        this.neededPerLevel = neededPerLevel;
        return this;
    }

    public IncrementalModifierRecipeBuilder setInput(ItemLike item, int amountPerItem, int neededPerLevel) {
        return this.setInput(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), amountPerItem, neededPerLevel);
    }

    public IncrementalModifierRecipeBuilder setInput(TagKey<Item> tag, int amountPerItem, int neededPerLevel) {
        return this.setInput(Ingredient.m_204132_(tag), amountPerItem, neededPerLevel);
    }

    public IncrementalModifierRecipeBuilder setLeftover(ItemOutput leftover) {
        this.leftover = leftover;
        return this;
    }

    public IncrementalModifierRecipeBuilder setLeftover(ItemStack stack) {
        return this.setLeftover(ItemOutput.fromStack((ItemStack)stack));
    }

    public IncrementalModifierRecipeBuilder setLeftover(ItemLike item) {
        return this.setLeftover(ItemOutput.fromItem((ItemLike)item));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.input == Ingredient.f_43901_) {
            throw new IllegalStateException("Must set input");
        }
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "modifiers");
        consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new IncrementalModifierRecipe(id, this.input, this.amountPerItem, this.neededPerLevel, this.tools, this.maxToolSize, this.result, ModifierEntry.VALID_LEVEL.range(this.minLevel, this.maxLevel), this.slots, this.leftover, this.allowCrystal, this.checkTraitLevel), IncrementalModifierRecipe.LOADER, advancementId));
    }
}

