/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.context;

import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;

public class LootingContext {
    private final LivingEntity holder;
    private final Entity target;
    @Nullable
    private final LivingEntity livingTarget;
    @Nullable
    private final DamageSource damageSource;
    @Nullable
    private final EquipmentSlot lootingSlot;

    public LootingContext(LivingEntity holder, Entity target, @Nullable DamageSource damageSource, @Nullable EquipmentSlot lootingSlot) {
        LivingEntity living;
        this.holder = holder;
        this.target = target;
        this.livingTarget = target instanceof LivingEntity ? (living = (LivingEntity)target) : null;
        this.damageSource = damageSource;
        this.lootingSlot = lootingSlot;
    }

    public LootingContext(LivingEntity holder, LivingEntity target, @Nullable DamageSource damageSource, @Nullable EquipmentSlot lootingSlot) {
        this.holder = holder;
        this.target = target;
        this.livingTarget = target;
        this.damageSource = damageSource;
        this.lootingSlot = lootingSlot;
    }

    public boolean isIndirect() {
        return this.lootingSlot == null;
    }

    public boolean isAttack() {
        return this.damageSource != null;
    }

    public LivingEntity getHolder() {
        return this.holder;
    }

    public Entity getTarget() {
        return this.target;
    }

    @Nullable
    public LivingEntity getLivingTarget() {
        return this.livingTarget;
    }

    @Nullable
    public DamageSource getDamageSource() {
        return this.damageSource;
    }

    @Nullable
    public EquipmentSlot getLootingSlot() {
        return this.lootingSlot;
    }
}

