/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.entity.EquipmentSlot;

public class ArmorUtil {
    private static final String DIAMOND_ARMOR = "textures/models/armor/diamond_layer_1.png";
    private static final String DIAMOND_LEGGINGS = "textures/models/armor/diamond_layer_2.png";

    private ArmorUtil() {
    }

    public static float getDamageBeforeArmorAbsorb(float damage, float armor, float toughness) {
        if (damage <= 0.0f) {
            return 0.0f;
        }
        float boostedToughness = toughness + 8.0f;
        float atProduct = armor * boostedToughness;
        return 5.0f * Mth.m_14036_((float)(((float)Math.sqrt(boostedToughness * (0.04f * armor * atProduct - 2.0f * atProduct + 25.0f * boostedToughness + 16.0f * damage)) + 0.2f * atProduct - 5.0f * boostedToughness) / 8.0f), (float)(damage * 25.0f / (125.0f - armor)), (float)damage);
    }

    public static float getDamageAfterMagicAbsorb(float damage, float enchantModifiers) {
        return ArmorUtil.getDamageAfterMagicAbsorb(damage, enchantModifiers, 20.0f);
    }

    public static float getDamageAfterMagicAbsorb(float damage, float enchantModifiers, float cap) {
        if (enchantModifiers == 0.0f || damage <= 0.0f) {
            return damage;
        }
        return damage * (1.0f - Mth.m_14036_((float)enchantModifiers, (float)-20.0f, (float)cap) / 25.0f);
    }

    public static float getDamageBeforeMagicAbsorb(float damage, float enchantModifiers) {
        return damage / (1.0f - Mth.m_14036_((float)enchantModifiers, (float)0.0f, (float)20.0f) / 25.0f);
    }

    public static float getDamageForEvent(float originalDamage, float armor, float toughness, float vanillaModifiers, float finalModifiers) {
        return ArmorUtil.getDamageForEvent(originalDamage, armor, toughness, vanillaModifiers, finalModifiers, 20.0f);
    }

    public static float getDamageForEvent(float originalDamage, float armor, float toughness, float vanillaModifiers, float finalModifiers, float modifierCap) {
        if (vanillaModifiers == finalModifiers && modifierCap == 20.0f) {
            return originalDamage;
        }
        float damage = originalDamage;
        if (armor > 0.0f) {
            damage = CombatRules.m_19272_((float)damage, (float)armor, (float)toughness);
        }
        if (finalModifiers != 0.0f) {
            damage = ArmorUtil.getDamageAfterMagicAbsorb(damage, finalModifiers, modifierCap);
        }
        if (vanillaModifiers > 0.0f) {
            damage = ArmorUtil.getDamageBeforeMagicAbsorb(damage, vanillaModifiers);
        }
        if (armor > 0.0f) {
            damage = ArmorUtil.getDamageBeforeArmorAbsorb(damage, armor, toughness);
        }
        return damage;
    }

    public static String getDummyArmorTexture(EquipmentSlot slot) {
        return slot == EquipmentSlot.LEGS ? DIAMOND_LEGGINGS : DIAMOND_ARMOR;
    }
}

