/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.DoubleSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import slimeknights.mantle.util.OffhandCooldownTracker;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.definition.module.weapon.MeleeHitToolHook;
import slimeknights.tconstruct.library.tools.helper.ModifierLootingHandler;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.Util;

public class ToolAttackUtil {
    private static final UUID SLOT_MAINHAND_ATTRIBUTE = UUID.fromString("fd666e50-d2cc-11eb-b8bc-0242ac130003");
    private static final float DEGREE_TO_RADIANS = (float)Math.PI / 180;
    private static final AttributeModifier ANTI_KNOCKBACK_MODIFIER = new AttributeModifier("tconstruct.anti_knockback", 1.0, AttributeModifier.Operation.ADDITION);
    public static final DoubleSupplier NO_COOLDOWN = () -> 1.0;

    public static DoubleSupplier getCooldownFunction(Player player, InteractionHand hand) {
        if (hand == InteractionHand.OFF_HAND) {
            return () -> OffhandCooldownTracker.getCooldown((Player)player);
        }
        return () -> player.m_36403_(0.5f);
    }

    public static float getSlotAttribute(IToolStackView tool, LivingEntity holder, EquipmentSlot slotType, Attribute attribute, float toolValue) {
        if (slotType == EquipmentSlot.MAINHAND) {
            return (float)holder.m_21133_(attribute);
        }
        AttributeInstance instance = holder.m_21051_(attribute);
        if (instance == null) {
            return (float)holder.m_21172_(attribute);
        }
        ItemStack mainStack = holder.m_21205_();
        Collection mainModifiers = List.of();
        if (!mainStack.m_41619_()) {
            mainModifiers = mainStack.m_41638_(EquipmentSlot.MAINHAND).get((Object)attribute);
            for (AttributeModifier modifier2 : mainModifiers) {
                instance.m_22130_(modifier2);
            }
        }
        ArrayList<AttributeModifier> slotAttributes = new ArrayList<AttributeModifier>();
        if (toolValue != 0.0f) {
            slotAttributes.add(new AttributeModifier(SLOT_MAINHAND_ATTRIBUTE, "tconstruct.tool.slot_mainhand_attribute", (double)toolValue, AttributeModifier.Operation.ADDITION));
        }
        BiConsumer<Attribute, AttributeModifier> attributeConsumer = (check, modifier) -> {
            if (check == attribute) {
                slotAttributes.add((AttributeModifier)modifier);
            }
        };
        for (ModifierEntry entry : tool.getModifierList()) {
            entry.getHook(ModifierHooks.ATTRIBUTES).addAttributes(tool, entry, EquipmentSlot.MAINHAND, attributeConsumer);
        }
        for (AttributeModifier modifier3 : slotAttributes) {
            instance.m_22118_(modifier3);
        }
        float value = (float)instance.m_22135_();
        for (AttributeModifier modifier4 : slotAttributes) {
            instance.m_22130_(modifier4);
        }
        for (AttributeModifier modifier4 : mainModifiers) {
            instance.m_22118_(modifier4);
        }
        return value;
    }

    public static float getAttributeAttackDamage(IToolStackView tool, LivingEntity holder, EquipmentSlot slotType) {
        if (holder.m_9236_().f_46443_) {
            return (float)holder.m_21133_(Attributes.f_22281_);
        }
        return ToolAttackUtil.getSlotAttribute(tool, holder, slotType, Attributes.f_22281_, tool.getStats().get(ToolStats.ATTACK_DAMAGE).floatValue());
    }

    public static boolean dealDefaultDamage(LivingEntity attacker, Entity target, float damage) {
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            return target.m_6469_(attacker.m_269291_().m_269075_(player), damage);
        }
        return target.m_6469_(attacker.m_269291_().m_269333_(attacker), damage);
    }

    public static boolean attackEntity(ItemStack stack, Player attacker, Entity targetEntity) {
        return ToolAttackUtil.attackEntity(ToolStack.from(stack), attacker, targetEntity);
    }

    public static boolean attackEntity(IToolStackView tool, Player attacker, Entity targetEntity) {
        return ToolAttackUtil.attackEntity(tool, (LivingEntity)attacker, InteractionHand.MAIN_HAND, targetEntity, ToolAttackUtil.getCooldownFunction(attacker, InteractionHand.MAIN_HAND), false);
    }

    public static boolean attackEntity(IToolStackView tool, LivingEntity attackerLiving, InteractionHand hand, Entity targetEntity, DoubleSupplier cooldownFunction, boolean isExtraAttack) {
        return ToolAttackUtil.attackEntity(tool, attackerLiving, hand, targetEntity, cooldownFunction, isExtraAttack, Util.getSlotType(hand));
    }

    @Nullable
    public static LivingEntity getLivingEntity(Entity entity) {
        LivingEntity living;
        if (entity instanceof PartEntity) {
            PartEntity part = (PartEntity)entity;
            entity = part.getParent();
        }
        return entity instanceof LivingEntity ? (living = (LivingEntity)entity) : null;
    }

    public static boolean attackEntity(IToolStackView tool, LivingEntity attackerLiving, InteractionHand hand, Entity targetEntity, DoubleSupplier cooldownFunction, boolean isExtraAttack, EquipmentSlot sourceSlot) {
        SoundEvent sound;
        if (tool.isBroken() || !tool.hasTag(TinkerTags.Items.MELEE)) {
            return false;
        }
        Level level = attackerLiving.m_9236_();
        if (level.f_46443_ || !targetEntity.m_6097_() || targetEntity.m_7313_((Entity)attackerLiving)) {
            return true;
        }
        LivingEntity targetLiving = ToolAttackUtil.getLivingEntity(targetEntity);
        Player attackerPlayer = null;
        if (attackerLiving instanceof Player) {
            Player player;
            attackerPlayer = player = (Player)attackerLiving;
        }
        float damage = ToolAttackUtil.getAttributeAttackDamage(tool, attackerLiving, sourceSlot);
        float cooldown = (float)cooldownFunction.getAsDouble();
        boolean fullyCharged = cooldown > 0.9f;
        boolean isCritical = !isExtraAttack && fullyCharged && attackerLiving.f_19789_ > 0.0f && !attackerLiving.m_20096_() && !attackerLiving.m_6147_() && !attackerLiving.m_20069_() && !attackerLiving.m_21023_(MobEffects.f_19610_) && !attackerLiving.m_20159_() && targetLiving != null && !attackerLiving.m_20142_();
        ToolAttackContext context = new ToolAttackContext(attackerLiving, attackerPlayer, hand, sourceSlot, targetEntity, targetLiving, isCritical, cooldown, isExtraAttack);
        float baseDamage = damage;
        List<ModifierEntry> modifiers = tool.getModifierList();
        for (ModifierEntry entry : modifiers) {
            damage = entry.getHook(ModifierHooks.MELEE_DAMAGE).getMeleeDamage(tool, entry, context, baseDamage, damage);
        }
        if (damage <= 0.0f) {
            return !isExtraAttack;
        }
        boolean isMagic = damage > baseDamage;
        float knockback = ToolAttackUtil.getSlotAttribute(tool, attackerLiving, sourceSlot, Attributes.f_22282_, 0.0f) / 2.0f;
        if (targetLiving != null) {
            knockback += 0.4f;
        }
        if (attackerLiving.m_20142_() && fullyCharged) {
            sound = SoundEvents.f_12314_;
            knockback += 0.5f;
        } else {
            sound = fullyCharged ? SoundEvents.f_12316_ : SoundEvents.f_12318_;
        }
        if (!isExtraAttack) {
            float criticalModifier;
            float f = criticalModifier = isCritical ? 1.5f : 1.0f;
            if (attackerPlayer != null) {
                CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((Player)attackerPlayer, (Entity)targetEntity, (boolean)isCritical, (float)(isCritical ? 1.5f : 1.0f));
                boolean bl = isCritical = hitResult != null;
                if (isCritical) {
                    criticalModifier = hitResult.getDamageModifier();
                }
            }
            if (isCritical && criticalModifier != 1.0f) {
                damage += baseDamage * (criticalModifier - 1.0f);
            }
        }
        if (cooldown < 1.0f) {
            damage *= 0.2f + cooldown * cooldown * 0.8f;
        }
        float oldHealth = 0.0f;
        if (targetLiving != null) {
            oldHealth = targetLiving.m_21223_();
        }
        float baseKnockback = knockback;
        for (ModifierEntry entry : modifiers) {
            knockback = entry.getHook(ModifierHooks.MELEE_HIT).beforeMeleeHit(tool, entry, context, damage, baseKnockback, knockback);
        }
        ModifierLootingHandler.setLootingSlot(attackerLiving, sourceSlot);
        Optional<AttributeInstance> knockbackModifier = ToolAttackUtil.getKnockbackAttribute(targetLiving);
        boolean canceledKnockback = false;
        if (knockback < 0.4f) {
            canceledKnockback = true;
            knockbackModifier.ifPresent(ToolAttackUtil::disableKnockback);
        } else if (targetLiving != null) {
            knockback -= 0.4f;
        }
        boolean didHit = isExtraAttack ? ToolAttackUtil.dealDefaultDamage(attackerLiving, targetEntity, damage) : MeleeHitToolHook.dealDamage(tool, context, damage);
        ModifierLootingHandler.setLootingSlot(attackerLiving, EquipmentSlot.MAINHAND);
        if (canceledKnockback) {
            knockbackModifier.ifPresent(ToolAttackUtil::enableKnockback);
        }
        if (!didHit) {
            if (!isExtraAttack) {
                level.m_6263_(null, attackerLiving.m_20185_(), attackerLiving.m_20186_(), attackerLiving.m_20189_(), SoundEvents.f_12315_, attackerLiving.m_5720_(), 1.0f, 1.0f);
            }
            for (ModifierEntry entry : modifiers) {
                entry.getHook(ModifierHooks.MELEE_HIT).failedMeleeHit(tool, entry, context, damage);
            }
            return !isExtraAttack;
        }
        float damageDealt = damage;
        if (targetLiving != null) {
            damageDealt = oldHealth - targetLiving.m_21223_();
        }
        if (knockback > 0.0f) {
            if (targetLiving != null) {
                targetLiving.m_147240_((double)knockback, (double)Mth.m_14031_((float)(attackerLiving.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(attackerLiving.m_146908_() * ((float)Math.PI / 180)))));
            } else {
                targetEntity.m_5997_((double)(-Mth.m_14031_((float)(attackerLiving.m_146908_() * ((float)Math.PI / 180))) * knockback), 0.1, (double)(Mth.m_14089_((float)(attackerLiving.m_146908_() * ((float)Math.PI / 180))) * knockback));
            }
            attackerLiving.m_20256_(attackerLiving.m_20184_().m_82542_(0.6, 1.0, 0.6));
            attackerLiving.m_6858_(false);
        }
        if (targetEntity.f_19864_ && targetEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)targetEntity;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(targetEntity));
            targetEntity.f_19864_ = false;
        }
        if (attackerPlayer != null) {
            if (isCritical) {
                sound = SoundEvents.f_12313_;
                attackerPlayer.m_5704_(targetEntity);
            }
            if (isMagic) {
                attackerPlayer.m_5700_(targetEntity);
            }
            level.m_6263_(null, attackerLiving.m_20185_(), attackerLiving.m_20186_(), attackerLiving.m_20189_(), sound, attackerLiving.m_5720_(), 1.0f, 1.0f);
        }
        if (damageDealt > 2.0f && level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            int particleCount = (int)(damageDealt * 0.5f);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123798_, targetEntity.m_20185_(), targetEntity.m_20227_(0.5), targetEntity.m_20189_(), particleCount, 0.1, 0.0, 0.1, 0.2);
        }
        attackerLiving.m_21335_(targetEntity);
        if (targetLiving != null) {
            EnchantmentHelper.m_44823_((LivingEntity)targetLiving, (Entity)attackerLiving);
        }
        for (ModifierEntry entry : modifiers) {
            entry.getHook(ModifierHooks.MELEE_HIT).afterMeleeHit(tool, entry, context, damageDealt);
        }
        float speed = tool.getStats().get(ToolStats.ATTACK_SPEED).floatValue();
        int time = Math.round(20.0f / speed);
        if (time < targetEntity.f_19802_) {
            targetEntity.f_19802_ = (targetEntity.f_19802_ + time) / 2;
        }
        if (attackerPlayer != null) {
            if (targetLiving != null) {
                ItemStack held;
                if (!(level.f_46443_ || isExtraAttack || (held = attackerLiving.m_6844_(sourceSlot)).m_41619_())) {
                    held.m_41640_(targetLiving, attackerPlayer);
                }
                attackerPlayer.m_36222_(Stats.f_12928_, Math.round(damageDealt * 10.0f));
            }
            attackerPlayer.m_36399_(0.1f);
            if (!isExtraAttack) {
                attackerPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)tool.getItem()));
            }
        }
        if (!tool.hasTag(TinkerTags.Items.UNARMED)) {
            int durabilityLost;
            int n = durabilityLost = targetLiving != null ? 1 : 0;
            if (!tool.hasTag(TinkerTags.Items.MELEE_PRIMARY)) {
                durabilityLost *= 2;
            }
            ToolDamageUtil.damageAnimated(tool, durabilityLost, attackerLiving);
        }
        return true;
    }

    public static boolean extraEntityAttack(IToolStackView tool, LivingEntity attackerLiving, InteractionHand hand, Entity targetEntity) {
        return ToolAttackUtil.attackEntity(tool, attackerLiving, hand, targetEntity, NO_COOLDOWN, true);
    }

    public static void spawnAttackParticle(ParticleOptions particleData, Entity entity, double height) {
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            double xd = -Mth.m_14031_((float)(entity.m_146908_() / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(entity.m_146909_() / 180.0f * (float)Math.PI));
            double zd = Mth.m_14089_((float)(entity.m_146908_() / 180.0f * (float)Math.PI)) * Mth.m_14089_((float)(entity.m_146909_() / 180.0f * (float)Math.PI));
            double yd = -Mth.m_14031_((float)(entity.m_146909_() / 180.0f * (float)Math.PI));
            server.m_8767_(particleData, entity.m_20185_() + xd, entity.m_20186_() + (double)entity.m_20206_() * height, entity.m_20189_() + zd, 0, xd, yd, zd, 0.0);
        }
    }

    private static Optional<AttributeInstance> getKnockbackAttribute(@Nullable LivingEntity living) {
        return Optional.ofNullable(living).map(e -> e.m_21051_(Attributes.f_22278_)).filter(attribute -> !attribute.m_22109_(ANTI_KNOCKBACK_MODIFIER));
    }

    private static void disableKnockback(AttributeInstance instance) {
        instance.m_22118_(ANTI_KNOCKBACK_MODIFIER);
    }

    private static void enableKnockback(AttributeInstance instance) {
        instance.m_22130_(ANTI_KNOCKBACK_MODIFIER);
    }

    public static boolean attackEntitySecondary(DamageSource source, float damage, Entity target, @Nullable LivingEntity living, boolean noKnockback) {
        float oldLastDamage;
        Optional<AttributeInstance> knockbackResistance = ToolAttackUtil.getKnockbackAttribute(living);
        float f = oldLastDamage = living == null ? 0.0f : living.f_20898_;
        if (noKnockback) {
            knockbackResistance.ifPresent(ToolAttackUtil::disableKnockback);
        }
        int lastInvulnerableTime = target.f_19802_;
        target.f_19802_ = 0;
        boolean hit = target.m_6469_(source, damage);
        target.f_19802_ = lastInvulnerableTime;
        if (living != null) {
            living.f_20898_ += oldLastDamage;
        }
        if (noKnockback) {
            knockbackResistance.ifPresent(ToolAttackUtil::enableKnockback);
        }
        return hit;
    }
}

